<?php

namespace App\Models\CustomerChequeReturnPayment_Models;

use App\Models\Bank_Models\Bank;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class CusCheqRtrnOnlinePayment extends Model implements AuditableContract
{
    use HasFactory, Auditable;
    public $timestamps = false;
    protected $guarded = [];

    public function bank()
    {
        return $this->belongsTo(Bank::class, 'bank_code', 'code');
    }

    public function modeOfPayment()
    {
        return $this->belongsTo(CheqRtrnModeOfPayment::class, 'mode_of_payment_code', 'code');
    }

    public function cusCheqReturnReceipt()
    {
        return $this->belongsTo(CusCheqReturnReceipt::class, 'cheque_receipt_code', 'code');
    }
}
