<?php

namespace App\Models\CustomerChequeReturnPayment_Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Models\Customer_Models\Customer;
use App\Models\PaymentReceipt_Models\ChequePayment;
use App\Models\Stock_Models\StockLocation;
use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;
use OwenIt\Auditing\Auditable;

class CusCheqReturnReceipt extends Model implements AuditableContract
{
    use HasFactory, Auditable;
    public $timestamps=false;
    protected $guarded = [];

    public function customer()
    {
        return $this->belongsTo(Customer::class,'customer_code','code');
    }

    public function cheqRtrnModeOfPayments()
    {
       return $this->hasMany(CheqRtrnModeOfPayment::class,'cheque_receipt_code', 'code');
    }

    public function chequePayments()
    {
        return $this->belongsToMany(ChequePayment::class, 'cheq_pay_cust_cheq_receipts','cheque_receipt_code', 'cheque_paym_code');
    }
    
    public function user()
    {
        return $this->belongsTo(User::class, 'created_by', 'id');
    }

    public function stockLocation()
    {
        return $this->belongsTo(StockLocation::class, 'stock_location_code', 'code');
    }
}
