<?php

namespace App\Models\CustomerChequeReturnPayment_Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class CheqRtrnModeOfPayment extends Model implements AuditableContract
{   
    use HasFactory, Auditable;
    public $timestamps=false;
    protected $guarded = [];

    public function cusCheqReturnReceipt()
    {
        return $this->belongsTo(CusCheqReturnReceipt::class, 'cheque_receipt_code', 'code');
    }

    function paymentType()
    {
        return $this->belongsTo(paymentType::class, 'payment_type_code','code');
    }

    public function cheqPayCustCheqReceipts()
    {
        return $this->hasMany(CheqPayCustCheqReceipt::class, 'mode_of_payment_code','code');
    }

    public function cashPayments()
    {
        return $this->hasMany(CusCheqRtrnCashPayment::class, 'mode_of_payment_code','code');
    }

    public function chequePayments()
    {
        return $this->hasMany(CusCheqRtrnChequePayment::class, 'mode_of_payment_code','code');
    }

    public function cardPayments()
    {
        return $this->hasMany(CusCheqRtrnCardPayment::class, 'mode_of_payment_code','code');
    }

    public function bankPayments()
    {
        return $this->hasMany(CusCheqRtrnBankPayment::class, 'mode_of_payment_code','code');
    }


}
