<?php

namespace App\Models\CustomerChequeReturnPayment_Models;

use App\Models\PaymentReceipt_Models\ChequePayment;
use App\Models\CustomerChequeReturnPayment_Models\CusCheqReturnReceipt;
use App\Models\CustomerChequeReturnPayment_Models\CheqRtrnModeOfPayment;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class CheqPayCustCheqReceipt extends Model implements AuditableContract
{
    use HasFactory, Auditable;
    public $timestamps=false;
    protected $guarded = [];

    public function chequePayment()
    {
        return $this->belongsTo(ChequePayment::class, 'cheque_paym_code', 'code');
    }

    public function cusCheqReturnReceipt()
    {
        return $this->belongsTo(CusCheqReturnReceipt::class,'cheque_receipt_code', 'code');
    }

    public function cheqRtrnModeOfPayment()
    {
       return $this->belongsTo(CheqRtrnModeOfPayment::class,'mode_of_payment_code', 'code');
    }
}
