<?php

namespace App\Models\Bank_Models;

use App\Models\Payment_Receipt_Models\ChequePaymentReceipt;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;


class BankBranch extends Model implements AuditableContract
{
    use HasFactory;
    use Auditable;
    public $timestamps=false;
    protected $guarded = [];

    public function bank()
    {
        return $this->belongsTo(Bank::class, 'bank_code','code');
    }

    public function chequePaymentReceipts()
    {
        return $this->hasMany(ChequePaymentReceipt::class, 'branch_code','code');
    }
}


