<?php

namespace App\Models\Bank_Models;

use App\Models\Expense_Models\Expense;
use App\Models\Expense_Models\ExpensePayment;
use App\Models\Payment_Receipt_Models\BankTransferPaymentReceipt;
use App\Models\Payment_Receipt_Models\CardPaymentReceipt;
use App\Models\Payment_Receipt_Models\ChequePaymentReceipt;
use App\Models\PaymentVoucher_Models\SupplierBankPayment;
use App\Models\PaymentVoucher_Models\SupplierCardPayment;
use App\Models\PaymentVoucher_Models\SupplierChequePayment;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;


class Bank extends Model implements AuditableContract
{
    use HasFactory;
    use Auditable;
    public $timestamps=false;
    protected $guarded = [];
    

    public function bankBranches()
    {
        return $this->hasMany(BankBranch::class, 'bank_code','code');
    }

    public function expensePayments()
    {
        return $this->hasMany(ExpensePayment::class, 'bank_code','code');
    }

    public function expenses()
    {
       return $this->hasMany(Expense::class,'bank_code', 'code');
    }

    public function cardPaymentReceipts()
    {
        return $this->hasMany(CardPaymentReceipt::class, 'bank_code','code');
    }

    public function bankTransferPaymentReceipts()
    {
        return $this->hasMany(BankTransferPaymentReceipt::class, 'bank_code','code');
    }

    public function chequePaymentReceipts()
    {
        return $this->hasMany(ChequePaymentReceipt::class, 'bank_code','code');
    }

    public function supplierChequePayments()
    { 
        return $this->hasMany(SupplierChequePayment::class, 'bank_code','code');
    }
    
    public function supplierCardPayments()
    {
        return $this->hasMany(SupplierCardPayment::class, 'bank_code','code');
    }
    
    public function supplierBankPayments()
    {       
        return $this->hasMany(SupplierBankPayment::class, 'bank_code','code');
    }

    
}
