<?php

namespace App\Models\AccountTransaction_Models;

use App\Models\GeneralLedger_Model\GeneralLedger;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class AccTransaction extends Model implements AuditableContract
{
    use HasFactory;
    public $timestamps = false;
    protected $guarded = [];
    use Auditable;


    public function journalType()
    {
        return $this->belongsTo(AccJournalType::class, 'acc_journal_type_code', 'code');
    }

    public function generalLedgers()
    {
        return $this->hasMany(AccGeneralLedger::class, 'source_code', 'code');
    }
}