<?php

namespace App\Models\AccountTransaction_Models;

use App\Models\AccountTransaction_Models\AccClosingBalance;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;


class AccLedgerType extends Model implements AuditableContract
{
    use HasFactory;
    public $timestamps = false;
    protected $guarded = [];
    use Auditable;
    

    public function ledgerType()
    {
        return $this->hasMany(AccClosingBalance::class,'acc_ledger_type_code','code');
    }

    public function accLedgerTypeFrom()
    {
        return $this->hasMany(AccJournalType::class,'acc_ledger_type_from_code','code');
    }

    public function accLedgerTypeTo()
    {
        return $this->hasMany(AccJournalType::class,'acc_ledger_type_to_code','code');
    }

}
