<?php

namespace App\Models\AccountTransaction_Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class AccJournalType extends Model implements AuditableContract
{
    use HasFactory;
    use Auditable;
    public $timestamps = false;
    protected $guarded = [];

    
    public function accLedgerTypeFrom()
    {
        return $this->belongsTo(AccLedgerType::class, 'acc_ledger_type_from_code', 'code');
    }

    public function accLedgerTypeTo()
    {
        return $this->belongsTo(AccLedgerType::class, 'acc_ledger_type_to_code', 'code');
    }
}