<?php

namespace App\Models\AccountTransaction_Models;

use App\Models\AccountTransaction_Models\AccTransaction;
use App\Models\AccountTransaction_Models\ClosingBalance;
use App\Models\Expense_Models\Expense;
use App\Models\Invoice_Models\SalesReturn;
use App\Models\PaymentReceipt_Models\PaymentReceipt;
use App\Models\PaymentVoucher_Models\PaymentVoucher;
use App\Models\Supplier_Models\PurchaseReturn;
use Illuminate\Database\Eloquent\Factories\HasPenuFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class AccGeneralLedger extends Model implements AuditableContract
{
    use HasFactory;
    use Auditable;
    public $timestamps = false;
    protected $guarded = [];

    
    public function accTransaction()
    {
        return $this->belongsTo(AccTransaction::class, 'source_code', 'code');
    }

    public function closingBalance()
    {
        return $this->belongsTo(AccClosingBalance::class,'acc_closing_balance_code','code');
    }

    // public function paymentReceipt()
    // {
    //     return $this->belongsTo(PaymentReceipt::class, 'source_code', 'code');
    // }

    // public function paymentVoucher()
    // {
    //     return $this->belongsTo(PaymentVoucher::class, 'source_code','code');
    // }

    // public function salesReturn()
    // {
    //     return $this->belongsTo(SalesReturn::class, 'source_code', 'code');
    // }

    // public function purchaseReturn()
    // {
    //     return $this->belongsTo(PurchaseReturn::class, 'source_code', 'code');
    // }

    // public function expense()
    // {
    //     return $this->belongsTo(Expense::class,'source_code','code');
    // }

    
}