<?php

namespace App\Models\AccountTransaction_Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class AccClosingBalance extends Model implements AuditableContract
{
    use HasFactory;
    public $timestamps = false;
    protected $guarded = [];
    use Auditable;


    public function ledgerType()
    {
        return $this->belongsTo(AccLedgerType::class,'acc_ledger_type_code','code');
    }
    
    public function generalLedgers()
    {
        return $this->hasMany(AccGeneralLedger::class, 'acc_closing_balance_code', 'code');
    }


}
