<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Laravel\Sanctum\PersonalAccessToken;
use Illuminate\Support\Facades\Auth;

class CustomSanctumMiddleware
{
    public function handle(Request $request, Closure $next)
    {
        $authorizationHeader = $request->header('Titumauthorization');

        if ($authorizationHeader) {
            // Extract token from the header
            $token = str_replace('Bearer ', '', $authorizationHeader);

            // Find the token in the database
            $accessToken = PersonalAccessToken::findToken($token);

            if ($accessToken) {
                // Retrieve the user associated with the token
                $user = $accessToken->tokenable;
                
                // Optionally set the authenticated user
                Auth::setUser($user);

                // Proceed with the request
                return $next($request);
            }
        }

        // Unauthorized response if token is invalid or not found
        return response()->json(['message' => 'Unauthorized'], 401);
    }
}