<?php

namespace App\Http\Controllers\Vehicle_Controllers;

use Illuminate\Http\Request;
use App\Enums\TransactionCode;
use App\Http\Controllers\Controller;
use App\Models\Vehicle_Models\VehicleType;
use Exception;

class VehicleTypeController extends Controller
{
    public function index()
    {
        try{
            $type = VehicleType::select('code','name','description')
            ->where( 'is_active', '=', 1)
            ->get();
            return response()->json(['status'=> 200, 'type'=>$type]);

         }catch (\Exception $e) {
             return response()->json([
                 'status'=> 500,
                 'message'=> $e
             ],500);
         }

    }

    public function show($id)
    {

        try{
            $type = VehicleType::select('code','name','description')
            ->where( 'code',$id)
            ->where('is_active','=',1)
            ->first();
            return response()->json(['status'=> 200, 'type'=>$type]);

         }catch (\Exception $e) {
             return response()->json([
                 'status'=> 500,
                 'message'=> $e
             ],500);
         }
    }


    public function create()
    {
        //
    }


    public function store(Request $request)
    {

        try{

            $vehicleType =TransactionCode::VEHICLE_TYPE;
            $max_code = VehicleType::max('code');
            $max_id= $max_code==null ? config('global.code_value')+1 : substr("$max_code",3)+1;

            $type = VehicleType::create([
                'code'=> $vehicleType.$max_id,
                'name'=>$request->name,
                'description'=>$request->description,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);
            return response()->json(['status'=> 200, 'message'=>"Vehicle Type Created"]);

         }catch (\Exception $e) {
             return response()->json([
                 'status'=> 500,
                 'message'=> $e
             ],500);
         }


    }


    public function edit($id)
    {
        //
    }


    public function update(Request $request, $id)
    {

        try{

            $type= VehicleType::where('code',$id)->first();
            $type ->update([
                'name'=>$request->name,
                'description'=>$request->description,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);
            return response()->json(['status'=> 200, 'message'=>"Vehicle Type updated"]);


         }catch (\Exception $e) {
             return response()->json([
                 'status'=> 500,
                 'message'=> $e
             ],500);
         }
    }

  /**
     * searchVehicleType
     * Author: Suhail Jamaldeen
     * Date: 14.02.2023
     * Logic: Search Vehicle Type
     * @param  mixed $key
     * @return void
     */
    public function searchVehicleType($key)
    {
        try {

            $types = VehicleType::select(
                'code',
                'name'
            )->where([['is_active', '=', 1]])
                ->where(function ($query) use ($key) {
                    $query->Where('name', 'like', "%$key%");

                })->get();

            return response()->json([
                'status' => 200,
                'types' => $types
            ]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }
    public function destroy($id)
    {
        try{
        $type = VehicleType::findOrFail($id);
        $type->update([
            'is_active'=>0
        ]);
        return response()->json(['status'=> 200, 'message'=>"type Deleted"]);

        }catch (\Exception $e) {
            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }
}
