<?php

namespace App\Http\Controllers\Vehicle_Controllers;


use Illuminate\Http\Request;
use App\Enums\TransactionCode;
use App\Http\Controllers\Controller;
use App\Models\Vehicle_Models\VehicleMaster;
use Illuminate\Contracts\Queue\Job;
use Illuminate\Support\Facades\DB;

class VehicleMasterController extends Controller
{

    public function index()
    {
        try {

            $vehicles = VehicleMaster::select(
                'code',
                'brand_code',
                'type_code',
                'customer_code',
                'description',
                'vehicle_number',
                'service_km',
                'service_period',
                'brand_code',
                'type_code'
            )
                ->with(
                    [
                        'vehicleBrand' => function ($query) {
                            $query->select('code', 'name')->where('is_active', '=', 1);
                        },
                        'vehicleType' => function ($query) {
                            $query->select('code', 'name')->Where('is_active', '=', 1);
                        }
                    ]
                )
                ->with([
                    'customer.customerAddresses' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'customer.invoices.invoiceExt' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->where('vehicle_masters.is_active', 1)->get();

            return response()->json(['status' => 200, 'vehicles' => $vehicles]);
        } catch (\Exception $e) {
            return response()->Json([
                'status' => 500,
                'message' => $e
            ]);
        }
    }


    public function upcomingService()
    {
        try {

            $vehicles = VehicleMaster::select(
                'code',
                'brand_code',
                'type_code',
                'customer_code',
                'description',
                'vehicle_number',
                'service_km',
                'service_period',
                'brand_code',
                'type_code'
            )
                ->with(
                    [
                        'vehicleBrand' => function ($query) {
                            $query->select('code', 'name')->where('is_active', '=', 1);
                        },
                        'vehicleType' => function ($query) {
                            $query->select('code', 'name')->Where('is_active', '=', 1);
                        }
                    ]
                )
                ->with([
                    'customer.customerAddresses' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                // ->with([
                //     'customer.invoices.invoiceExt' => function ($query) {
                //         $query
                //         ->orderBy('code','DESC')->limit(1)
                //         ->where('is_active', '=', 1);
                //     }
                // ])
                ->with([
                    'invoiceExts' => function ($query) {
                        $query
                        ->orderBy('code','DESC')->limit(1)
                        ->where('is_active', '=', 1);
                    }
                ])
                ->where('vehicle_masters.is_active', 1)->get();

            return response()->json(['status' => 200, 'vehicles' => $vehicles]);
        } catch (\Exception $e) {
            return response()->Json([
                'status' => 500,
                'message' => $e
            ]);
        }
    }

    public function show($id)
    {
        try {

            $vehicle = VehicleMaster::select(
                'code',
                'brand_code',
                'type_code',
                'customer_code',
                'description',
                'vehicle_number',
                'service_km',
                'service_period'
            )
                ->with([
                    'vehicleBrand' => function ($query) {
                        $query->select('code', 'name')->where('is_active', '=', 1);
                    },
                    'vehicleType' => function ($query) {
                        $query->select('code', 'name')->Where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'customer.customerAddresses' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'invoiceExts.invoice' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->where('code', $id)
                ->where('is_active', 1)
                ->first();
            return response()->Json([
                'status' => 200,
                'vehicle' => $vehicle
            ]);
        } catch (\Exception $e) {
            return response()->Json([
                'status' => 500,
                'message' => $e
            ]);
        }
    }


    public function searchVehicleMaster($key)
    {
        try {
            $vehicles = VehicleMaster::select(
                'vehicle_masters.code',
                'brand_code',
                'type_code',
                'customer_code',
                'description',
                'vehicle_number',
                'service_km',
                'service_period',
            )
                ->with([
                    'vehicleBrand' => function ($query) {
                        $query->select('code', 'name')->where('is_active', '=', 1);
                    },
                    'vehicleType' => function ($query) {
                        $query->select('code', 'name')->Where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'customer.customerAddresses' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->where('vehicle_masters.code', 'like', "%$key%")
                ->orWhere('brand_code', 'like', "%$key%")
                ->orWhere('type_code', 'like', "%$key%")
                ->orWhere('vehicle_masters.customer_code', 'like', "%$key%")
                ->orWhere('vehicle_number', 'like', "%$key%")
                ->orWhere('vehicle_masters.description', 'like', "%$key%")
                ->where('vehicle_masters.is_active', '=', 1)
                ->get();
            return response()->json(['status' => 200, 'vehicles' => $vehicles]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }


    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        DB::beginTransaction();
        try {


            $vehicle_code = TransactionCode::VEHICLE_MASTER;
            $max_id = VehicleMaster::max('code');
            $max_code = $max_id == null ? config('global.code_value') + 1 : substr("$max_id", 3) + 1;


            $vehicle = VehicleMaster::create([
                'code' => $vehicle_code . $max_code,
                'brand_code' => $request->vehicleBrand['code'],
                'type_code' => $request->vehicleType['code'],
                'customer_code' => $request->customer['code'],
                'description' => $request->description,
                'vehicle_number' => $request->vehicleNumber,
                'service_km' => $request->serviceKm,
                'service_period' => $request->servicePeriod,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),

            ]);

            DB::commit();
            return response(['status' => 200, 'message' => ' Vehicle Master created']);
        } catch (\Exception $e) {
            DB::rollback();
            return response(['status' => 500, 'message' => $e]);
        }
    }




    public function edit($id)
    {
        //
    }


    public function update(Request $request, $id)
    {
        DB::beginTransaction();
        try {
            $vehicle = VehicleMaster::where('code', $id)->first();
            $vehicle->update([
                'brand_code' => $request->vehicleBrand['code'],
                'type_code' => $request->vehicleType['code'],
                'customer_code' => $request->customer['code'],
                'description' => $request->description,
                'vehicle_number' => $request->vehicleNumber,
                'service_km' => $request->serviceKm,
                'service_period' => $request->servicePeriod,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),

            ]);

            DB::commit();

            return response(['status' => 200, 'message' => ' Vehicle Master updated']);


        } catch (\Exception $e) {
            DB::rollback();
            return response(['status' => 500, 'message' => $e]);
        }
    }


    public function destroy($id)
    {
        //
    }

    public function vehicleServiceDetailsByPeriod(Request $request)
    {

        try {
            $code = $request->code;
            // $fromDate =  date('Y-m-d', strtotime($request->fromDate));
            // $toDate=  date('Y-m-d', strtotime($request->toDate));
            $fromDate = $request->fromDate;
            $toDate = $request->toDate;
            $startDate = '2021-10-01';

            $vehicles = VehicleMaster::select('vehicle_masters.code', 'invoices.vehicle_master_code', 'brand_code', 'type_code', 'vehicle_masters.customer_code', 'vehicle_masters.description', 'vehicle_masters.vehicle_number', 'service_km', 'service_period', 'vehicle_brands.name AS vehicleBrand', 'vehicle_types.name AS vehicleType')
                ->join('vehicle_brands', 'vehicle_brands.code', '=', 'vehicle_masters.brand_code')
                ->join('vehicle_types', 'vehicle_types.code', '=', 'vehicle_masters.type_code')
                ->join('invoices', 'invoices.vehicle_master_code', '=', 'vehicle_masters.code')

                ->with([
                    'customer' => function ($query) {
                        $query->select('code', 'first_name', 'second_name', 'phone_1')->where('is_active', '=', 1);
                    },
                    'invoice' => function ($query) {
                        $query->where('is_active', '=', 1);
                    },
                ])

                ->where('vehicle_masters.code', 'like', "%$code%")
                ->orWhere('brand_code', 'like', "%$code%")
                ->orWhere('type_code', 'like', "%$code%")
                ->orWhere('vehicle_masters.customer_code', 'like', "%$code%")
                ->orWhere('vehicle_number', 'like', "%$code%")
                ->orWhere('vehicle_masters.description', 'like', "%$code%")
                ->where('vehicle_masters.is_active', '=', 1)
                ->first();
            return response()->json([
                'status' => 200,
                'service' => $vehicles
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

}