<?php

namespace App\Http\Controllers\Vehicle_Controllers;

use Illuminate\Http\Request;
use App\Enums\TransactionCode;
use App\Http\Controllers\Controller;
use App\Models\Vehicle_Models\VehicleBrand;


class VehicleBrandController extends Controller
{
    public function index()
    {
        try {
            $brand = VehicleBrand::select('code', 'name', 'description')
                ->where('is_active', '=', 1)
                ->get();
            return response()->json(['status' => 200, 'brand' => $brand]);

        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }

    }

    public function show($id)
    {

        try {
            $brand = VehicleBrand::select('code', 'name', 'description')
                ->where('code', $id)
                ->where('is_active', '=', 1)
                ->first();
            return response()->json(['status' => 200, 'brand' => $brand]);

        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }


    public function create()
    {
        //
    }


    public function store(Request $request)
    {

        try {

            $VehicleBrand = TransactionCode::VEHICLE_BRAND;
            $max_code = VehicleBrand::max('code');
            $max_id = $max_code == null ? config('global.code_value') + 1 : substr("$max_code", 3) + 1;

            $brand = VehicleBrand::create([
                'code' => $VehicleBrand . $max_id,
                'name' => $request->name,
                'description' => $request->description,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);
            return response()->json(['status' => 200, 'message' => "Brand Created"]);

        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }


    }


    public function edit($id)
    {
        //
    }



    /**
     * searchVehicleBrand
     * Author: Suhail Jamaldeen
     * Date: 14.02.2023
     * Logic: Search Vehicle Brand
     * @param  mixed $key
     * @return void
     */
    public function searchVehicleBrand($key)
    {
        try {

            $brands = VehicleBrand::select(
                'code',
                'name'
            )->where([['is_active', '=', 1]])
                ->where(function ($query) use ($key) {
                    $query->Where('name', 'like', "%$key%");

                })->get();

            return response()->json([
                'status' => 200,
                'brands' => $brands
            ]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }
    public function update(Request $request, $id)
    {

        try {

            $brand = VehicleBrand::where('code', $id)->first();
            $brand->update([
                'name' => $request->name,
                'description' => $request->description,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);
            return response()->json(['status' => 200, 'message' => "Brand updated"]);


        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }


    public function destroy($id)
    {
        try {
            $brand = VehicleBrand::findOrFail($id);
            $brand->update([
                'is_active' => 0
            ]);
            return response()->json(['status' => 200, 'message' => "Brand Deleted"]);

        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }
}