<?php

namespace App\Http\Controllers\Vehicle_Controllers;

use Illuminate\Http\Request;
use App\Enums\TransactionCode;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\Vehicle_Models\ServicePackage;
use App\Models\Vehicle_Models\ServicePackageData;
use App\Models\Vehicle_Models\InvoiceServicePackage;
use App\Http\Controllers\Function_Controllers\ServicePackageDataFunction;
use App\Models\Vehicle_Models\VehicleMaster;

class ServicePackageController extends Controller
{
    private $serviceData;
    public function __construct()
    {
        $this->serviceData = new ServicePackageDataFunction();
    }

    public function index()
    {
        try {
            $service = ServicePackage::select('code', 'name', 'remarks','is_active')
                ->with([
                    'servicePackageDatas' => function ($query) {
                        $query->where('is_active', '=', 1);
                    },
                ])
                ->with([
                    'servicePackageDatas.itemMaster' => function ($query) {
                        $query->where('is_active', '=', 1);
                    },
                ])
                //->where('is_active', '=', 1)
                ->get();
            return response()->json(['status' => 200, 'service' => $service]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    public function vehicleMaster()
    {
        try {
            $service = ServicePackage::select('code', 'name', 'remarks')
                ->with([
                    'servicePackageDatas' => function ($query) {
                        $query->where('is_active', '=', 1);
                    },
                ])
                ->with([
                    'servicePackageDatas.itemMaster' => function ($query) {
                        $query->where('is_active', '=', 1);
                    },
                ])
                ->where('is_active', '=', 1)
                ->get();
            return response()->json(['status' => 200, 'service' => $service]);
        }
        // try {

        //     $vehicles = VehicleMaster::select('code', 'brand_code', 'type_code', 'customer_code', 'description', 'vehicle_number', 'service_km', 'service_period')
        //         ->with(['vehicleBrand' => function ($query) {
        //             $query->select('code', 'name')->where('is_active', '=', 1);
        //         }, 'vehicleType' => function ($query) {
        //             $query->select('code', 'name')->Where('is_active', '=', 1);
        //         }, 'customer' => function ($query) {
        //             $query->select('code', 'first_name', 'second_name',)->where('is_active', '=', 1);
        //         }])
        //         ->where('is_active', 1)
        //         ->get();
        //     return response([
        //         'status' => 200,
        //         'vehicles' => $vehicles
        //     ]);
        // } catch (\Exception $e) {
        //     return response([
        //         'status' => 500,
        //         'message' => $e
        //     ]);
        // }
        catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    public function show($id)
    {

        try {
            $service = ServicePackage::select('code', 'name', 'remarks','is_active')
                ->with([
                    'servicePackageDatas' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'servicePackageDatas.itemMaster' => function ($query) {
                        $query->where('is_active', '=', 1);
                    },
                ])
                ->where('code', $id)
               // ->where('is_active', '=', 1)
                ->first();
            return response()->json(['status' => 200, 'service' => $service]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    /**
     * searchServicePackage
     * Author: Suhail Jamaldeen
     * Date: 14.02.2023
     * Logic: Search the service packages
     * @param  mixed $key
     * @return void
     */
    public function searchServicePackage($key)
    {

        try {
            $service = ServicePackage::select(
                'code',
                'name',
                'remarks'
            )
                ->with(
                    [
                        'servicePackageDatas' => function ($query) {
                            $query->select(
                                'code',
                                'service_package_code',
                                'item_code'
                            )
                                ->where('is_active', '=', 1);
                        },
                        'servicePackageDatas.itemMaster' => function ($query) {
                            $query->select(
                                'code',
                                'name',
                                'retail_price',
                                'is_service'
                            )->where('is_active', '=', 1)
                            ->where('is_service', '=', 1);
                        },
                        'servicePackageDatas.itemMaster.itemUnit' => function ($query) {
                            $query->select(
                                'code',
                                'name'
                            )->where('is_active', '=', 1);
                        }
                    ]
                )
                ->orWhere('code', 'like', "%$key%")
                ->orWhere('name', 'like', "%$key%")
                ->where('is_active', '=', 1)
                ->get();
            return response()->json(
                ['status' => 200, 'services' => $service]
            );
        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }


    public function create()
    {
        //
    }


    public function store(Request $request)
    {

        try {
            DB::beginTransaction();
            $ServicePackage = TransactionCode::SERVICE_PACKAGE;
            $stockLocationCode = getCurrentLocationCode($request);
            $locationPrefix = substr($stockLocationCode, -2);
            $max_code = ServicePackage::select('code')
                ->where('stock_location_code', '=', $stockLocationCode)
                ->max('code');
            $max_id = $max_code == null ? config('global.code_value') + 1 : substr($max_code, 5) + 1;

            $service = ServicePackage::create([
                'code' => $ServicePackage . $locationPrefix . $max_id,
                'stock_location_code' => getCurrentLocationCode($request),
                'name' => $request->name,
                'remarks' => $request->remarks,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);
            if ($service) {
                $package_data = $request->servicePackageDatas;
                if (count($package_data) > 0) {
                    foreach ($package_data as $packageData) {
                        $this->serviceData->servicePackageData($packageData, $service->code);
                    }
                }
            }
            DB::commit();
            return response()->json([
                'status' => 200,
                'message' => "Service Created"
            ], 200);
        } catch (\Exception $e) {
            DB::rollback();
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    public function addInvoicePaymentForVehicleMaster($service, $invoice)
    {
        try {
            DB::beginTransaction();

            $payment_code = TransactionCode::BILL_PAYMENT_CODE;
            $cus_code = InvoiceServicePackage::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $invoiceServicePackage = InvoiceServicePackage::create([
                'code' => $payment_code . $max_id,
                'service_package_code' => $service->code,
                'invoice_code' => $invoice['code'],
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);

            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }


    public function edit($id)
    {
        //
    }


    public function update(Request $request, $id)
    {

        try {
            DB::beginTransaction();
            $service = ServicePackage::where('code', $id)->first();
            $service->update([
                'name' => $request->name,
                'remarks' => $request->remarks,
                'is_active' => $request->isActive,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);

            // if ($service) {
            //     $package_data = $request->servicePackageDatas;
            //     $this->serviceData->updateServicePackageData($package_data, $service->code);
            // }

            DB::commit();
            return response()->json(['status' => 200, 'message' => "Service Updated"]);
        } catch (\Exception $e) {
            DB::rollback();
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }


    public function destroy(Request $request, $id)
    {
        try {
            $service = ServicePackage::where('code', $id)->first();
            $servicePackageData = $request->servicePackageData;
            if (count($servicePackageData) > 0) {
                foreach ($servicePackageData as $servicePackageData) {
                    ServicePackageData::where('service_package_code', '=', $service['code'])
                        ->each(function ($oldRecord) {
                            $oldRecord->delete();
                        });
                }
            }
            $service->delete();
            return response()->json(['status' => 200, 'message' => "service Pack Deleted"]);

        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }
}