<?php

namespace App\Http\Controllers\Supplier_Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Supplier_Models\SupplierShippingAddress;

class SupplierShippingAddressController extends Controller
{
   /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {


        try{
             $suppliersShippingAddress = SupplierShippingAddress::select('supplier_code','first_name','second_name','company_name','phone_1','phone_2','address','city','district','province','postcode','order_notes')
             ->where('is_active', '=', 1)
             ->get();
             return response()->json([
                 'status' => 200,
                 'supplier' =>  $suppliersShippingAddress
             ]);


         }catch (\Exception $e) {
             return response()->json([
                 'status'=> 500,
                 'message'=> $e
             ],500);
         }
    }


    public function show($id)
    {
        try{

               $SupplierShippingAddress = SupplierShippingAddress::select('supplier_code','first_name','second_name','company_name','phone_1','phone_2','address','city','district','province','postcode','order_notes')
               ->where( 'is_active', '=', 1)
               ->where('id', $id)->first();
               return response()->json([
                   'status' => 200,
                   'supplier' =>  $SupplierShippingAddress
               ]);

           }catch (\Exception $e) {
               return response()->json([
                   'status'=> 500,
                   'message'=> $e
               ],500);
           }
    }


    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        try{
            //$current_date_time = Carbon::now()->toDateTimeString();
            $SupplierShippingAddress = SupplierShippingAddress::create([
            'supplier_code'=>$request->supplier_code,
            'first_name'=>$request->first_name  ,
            'second_name'=>$request->second_name  ,
            'company_name'=>$request->company_name  ,
            'phone_1'=>$request-> phone_1 ,
            'phone_2'=>$request->phone_2  ,
            'address'=>$request->address  ,
            'city'=>$request->city  ,
            'district'=>$request->district  ,
            'province'=>$request-> province ,
            'postcode'=>$request->postcode  ,
            'order_notes'=>$request->order_notes  ,
            'created_by' => getUserCode(),
            'created_at' => getDateTimeNow(),
            'updated_by' => getUserCode(),
            'updated_at' => getDateTimeNow(),

        ]);
        return response()->json([
            'status'=> 200,
            'message'=>'supplier Billig - Created'
            ]);


        } catch (\Exception $e) {


            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function edit($id)
    {
        //
    }


    public function update(Request $request, $id)
    {
        try{

            $SupplierShippingAddress= SupplierShippingAddress::findOrFail($id);
            $SupplierShippingAddress->update([
                'supplier_code'=>$request->supplier_code,
                'first_name'=>$request->first_name  ,
                'second_name'=>$request->second_name  ,
                'company_name'=>$request->company_name  ,
                'phone_1'=>$request-> phone_1 ,
                'phone_2'=>$request->phone_2  ,
                'address'=>$request->address  ,
                'city'=>$request->city  ,
                'district'=>$request->district  ,
                'province'=>$request-> province ,
                'postcode'=>$request->postcode  ,
                'order_notes'=>$request->order_notes  ,
                'updated_by'=> getUserCode(),
                'updated_at'=> getDateTimeNow(),

            ]);
            return response()->json(['status'=> 200, 'message'=> 'supplier Billing Address Updated']);

        } catch (\Exception $e) {


            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try{
            $SupplierShippingAddress = SupplierShippingAddress::select('id','is_active')->findOrFail($id);
            $SupplierShippingAddress->update([
                'is_active'=>0
            ]);
            return response()->json([
                'status'=> 204,
                'message'=>"supplier Billing Address - Deleted"
                ]);


            }catch (\Exception $e) {
                return response()->json([
                    'status'=> 500,
                    'message'=> $e
                ],500);
            }
    }


}
