<?php

namespace App\Http\Controllers\Supplier_Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json;
use  App\Models\Supplier_Models\Supplier;
use  App\Models\Supplier_Models\SupplierAddress;
use App\Enums\TransactionCode;
use Exception;
use Illuminate\Support\Facades\DB;


class SupplierController extends Controller
{

    public function index()
    {

        try {
            $supplier = Supplier::select('code', 'custom_code','stock_location_code', 'name', 'contact_name', 'address_1', 'address_2', 'currency', 'country', 'phone_1', 'phone_2', 'web_site', 'email', 'debit_amount', 'username', 'password', 'passport_number', 'nic_number', 'created_by', 'updated_by')
                ->where('is_active', '=', 1)
                ->get();
            return response()->json([
                'status' => 200,
                'supplier' =>  $supplier
            ]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    public function show($id)
    {
        try {
            $supplier = Supplier::select('code','stock_location_code', 'custom_code', 'name', 'contact_name', 'address_1', 'address_2', 'currency', 'country', 'phone_1', 'phone_2', 'web_site', 'email', 'debit_amount', 'username', 'password', 'passport_number', 'nic_number', 'created_by', 'updated_by', 'is_active')
                ->with(['supplierAddresses' => function ($query) {
                    $query->where('is_active', '=', 1);
                }])
                ->where('is_active', '=', 1)
                ->where('code', $id)
                ->first();
            return response()->json([
                'status' => 200,
                'supplier' => $supplier
            ]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }


    public function supplierSearch($key, Request $request)
    {
        try {
            $supplier = Supplier::select('code','stock_location_code', 'custom_code', 'name', 'contact_name', 'address_1', 'address_2', 'currency', 'country', 'phone_1', 'phone_2', 'web_site', 'email', 'debit_amount', 'over_payment','return_amount','username', 'password', 'passport_number', 'nic_number', 'created_by', 'updated_by')
                ->where([['is_active', '=', 1]])
                ->where(function ($query) use ($key) {
                    $query->Where('code', 'like', "%$key%")
                        ->orWhere('custom_code', 'like', "%$key%")
                        ->orWhere('name', 'like', "%$key%")
                        ->orWhere('phone_1', 'like', "%$key%")
                        ->orWhere('nic_number', 'like', "%$key%");
                })
                ->where('stock_location_code', '=', getCurrentLocationCode($request))
                ->get();
            return response()->json([ 'status' => 200, 'supplier' => $supplier ]);

        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }



    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        DB::beginTransaction();
        try {

            $supCode = TransactionCode::SUPPLIER;
            $bixz_code = Supplier::max('code');
            $max_id = $bixz_code == null ? config('global.code_value') + 1 : substr("$bixz_code", 3) + 1;
            $supplier = Supplier::create([

                'code' => $supCode . $max_id,
                'stock_location_code'=> getCurrentLocationCode($request),
                'custom_code' => $request->customCode,
                'name' => $request->name,
                'contact_name' => $request->contactName,
                'address_1' => $request->address1,
                'address_2' => $request->address2,
                'currency' => $request->currency,
                'country' => $request->country,
                'phone_1' => $request->phone1,
                'phone_2' => $request->phone2,
                'web_site' => $request->webSite,
                'email' => $request->email,
                'grn_total' => 0,
                'received_amount' => 0,
                'over_payment' => 0,
                'debit_amount' => 0,
                'return_amount' => 0,
                'cheque_return_amount' => 0,          
                'username' => $request->username,
                'password' => $request->password,
                'passport_number' => $request->passportNumber,
                'nic_number' => $request->nicNumber,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),

            ]);

            if ($supplier) {
                $supplierAddress = $request->supplierAddresses;

                $this->addSupplierAddress($supplierAddress, $supplier->code);

                DB::commit();
                return response()->json([ 'status' => 200, 'message' => "Supplier Created",
                    // 'message'=>$supplierAddress
                ], 200);
            }
        } catch (\Exception $e) {

            DB::rollBack();
            throw new Exception($e);
        }
    }


    public function edit($id)
    {
        //
    }

    public function update(Request $request, $id)
    {

        try {

            DB::beginTransaction();
            $supplier = Supplier::select('id', 'code')->where('code', $id)->first();
            $supplier->update([
                'custom_code' => $request->customCode,
                'name' => $request->name,
                'contact_name' => $request->contactName,
                'address_1' => $request->address1,
                'address_2' => $request->address2,
                'currency' => $request->currency,
                'country' => $request->country,
                'phone_1' => $request->phone1,
                'phone_2' => $request->phone2,
                'web_site' => $request->webSite,
                'email' => $request->email,
                'debit_amount' => $request->debitBalance,
                // 'grn_total' => 0,
                // 'received_amount' => 0,
                // 'over_payment' => 0,
                // 'return_amount' => 0,
                //'cheque_return_amount' => 0,          
                'username' => $request->username,
                'password' => $request->password,
                'passport_number' => $request->passportNumber,
                'nic_number' => $request->nicNumber,
                'is_active' => $request->isActive,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);
            if ($supplier) {
                $supplierAddress = $request->supplierAddresses;

                $this->updateSupplierAddress($supplierAddress, $id);
            }
            DB::commit();
            return response()->json([ 'status' => 200, 'message' => "Supplier Updated",], 200);
        } catch (\Exception $e) {
            DB::rollBack();

            throw new Exception($e);
        }
    }

    public function destroy($id)
    {
        try {
            $supplier = Supplier::select('is_active')->findOrFail($id);
            $supplier->update([
                'is_active' => 0
            ]);

            return response()->json([
                'status' => 200,
                'message' => 'Supplier Deleted'

            ]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }


    protected function addSupplierAddress($supplierAddress, $supplier_code)
    {
        try {

            if (count($supplierAddress) > 0) {

                foreach ($supplierAddress as $address) {

                    SupplierAddress::create([
                        'supplier_code' => $supplier_code,
                        'first_name' => $address['firstName'],
                        'second_name' => $address['secondName'],
                        'email' => $address['email'],
                        'phone_1' => $address['phone1'],
                        'phone_2' => $address['phone2'],
                        'address' => $address['address'],
                        'country' => $address['country'],
                        'city' => $address['city'],
                        'post_box' => $address['postBox'],
                        //'company' =>$address['company'],
                        'created_by' => getUserCode(),
                        'created_at' => getDateTimeNow(),
                        'updated_by' => getUserCode(),
                        'updated_at' => getDateTimeNow(),
                    ]);
                }
            }
        } catch (\Exception $e) {


            throw new Exception($e);
        }
    }

    protected function updateSupplierAddress($supplierAddress, $supplier_code)
    {
        foreach ($supplierAddress as $address) {
            $supplierAddress = "";
            if (isset($address['id'])) {
                $supplierAddress = SupplierAddress::select('id', 'supplier_code')
                    ->where('id', $address['id'])
                    ->where('supplier_code', $supplier_code)
                    ->first();
            }

            if ($supplierAddress) {
                $supplierAddress->update([
                    'first_name' => $address['firstName'],
                    'second_name' => $address['secondName'],
                    'email' => $address['email'],
                    'phone_1' => $address['phone1'],
                    'phone_2' => $address['phone2'],
                    'address' => $address['address'],
                    'country' => $address['country'],
                    'city' => $address['city'],
                    'post_box' => $address['postBox'],
                    'is_active' => $address['isActive'],
                    //'company' =>$address['company'],
                    'updated_by' => getUserCode(),
                    'updated_at' => getDateTimeNow(),

                ]);
            } else {
                $this->createSingleAddress($address, $supplier_code);
            }
        }
    }


    protected function createSingleAddress($address, $supplier_code)
    {
        SupplierAddress::create([
            'supplier_code' => $supplier_code,
            'first_name' => $address['firstName'],
            'second_name' => $address['secondName'],
            'email' => $address['email'],
            'phone_1' => $address['phone1'],
            'phone_2' => $address['phone2'],
            'address' => $address['address'],
            'country' => $address['country'],
            'city' => $address['city'],
            'post_box' => $address['postBox'],
            // 'is_active' => $address['is_active'],
            //'company' =>$address['company'],
            'created_by' => getUserCode(),
            'created_at' => getDateTimeNow(),
            'updated_by' => getUserCode(),
            'updated_at' => getDateTimeNow(),
        ]);
    }
}
