<?php

namespace App\Http\Controllers\Supplier_Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Supplier_Models\SupplierBillingAddress;


class SupplierBillingAddressController extends Controller
{

    public function index()
    {
        try{
            // return response()->Json(supplier::get(),200);

             $supplierBills = SupplierBillingAddress::select('supplier_code','first_name','second_name','company_name','phone_1','phone_2','address','city','district','province','postcode','order_notes')
             ->where('is_active', '=', 1)
             ->get();
             return response()->json([
                 'status' => 200,
                 'supplier' =>  $supplierBills
             ]);


         }catch (\Exception $e) {
             return response()->json([
                 'status'=> 500,
                 'message'=> $e
             ],500);
         }
    }


    public function show($id)
    {
        try{

               $supplierBill = SupplierBillingAddress::select('supplier_code','first_name','second_name','company_name','phone_1','phone_2','address','city','district','province','postcode','order_notes')
               ->where( 'is_active', '=', 1)
               ->where('id', $id)->first();
               return response()->json([
                   'status' => 200,
                   'supplier' =>  $supplierBill
               ]);

           }catch (\Exception $e) {
               return response()->json([
                   'status'=> 500,
                   'message'=> $e
               ],500);
           }
    }


    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try{

            $supplierBill = SupplierBillingAddress::create([
            'supplier_code'=>$request->supplier_code,
            'first_name'=>$request->first_name  ,
            'second_name'=>$request->second_name  ,
            'company_name'=>$request->company_name  ,
            'phone_1'=>$request-> phone_1 ,
            'phone_2'=>$request->phone_2  ,
            'address'=>$request->address  ,
            'city'=>$request->city  ,
            'district'=>$request->district  ,
            'province'=>$request-> province ,
            'postcode'=>$request->postcode  ,
            'order_notes'=>$request->order_notes  ,
            'created_by' => getUserCode(),
            'created_at' => getDateTimeNow(),
            'updated_by' => getUserCode(),
            'updated_at' => getDateTimeNow(),

        ]);
        return response()->json([
            'status'=> 200,
            'message'=>'Supplier Billig - Created'
            ]);


        } catch (\Exception $e) {


            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function edit($id)
    {
        //
    }

     
    public function update(Request $request, $id)
    {
        try{

            $supplierBill= SupplierBillingAddress::findOrFail($id);
            $supplierBill->update([
                'supplier_code'=>$request->supplier_code,
                'first_name'=>$request->first_name  ,
                'second_name'=>$request->second_name  ,
                'company_name'=>$request->company_name  ,
                'phone_1'=>$request-> phone_1 ,
                'phone_2'=>$request->phone_2  ,
                'address'=>$request->address  ,
                'city'=>$request->city  ,
                'district'=>$request->district  ,
                'province'=>$request-> province ,
                'postcode'=>$request->postcode  ,
                'order_notes'=>$request->order_notes  ,
                'updated_by'=> getUserCode(),
                'updated_at'=> getDateTimeNow(),

            ]);
            return response()->json(['status'=> 200, 'message'=> 'Supplier Billing Address Updated']);

        } catch (\Exception $e) {


            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try{
            $supplierBill = SupplierBillingAddress::select('id','is_active')->findOrFail($id);
            $supplierBill->update([
                'is_active'=>0
            ]);
            return response()->json([
                'status'=> 204,
                'message'=>"Supplier Billing Address - Deleted"
                ]);


            }catch (\Exception $e) {
                return response()->json([
                    'status'=> 500,
                    'message'=> $e
                ],500);
            }
    }


}
