<?php

namespace App\Http\Controllers\Supplier_Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Supplier_Models\SupplierAddress;

class SupplierAddressController extends Controller
{


    public function index()
    {
        try{
             $suppliers  = SupplierAddress::select('supplier_code','first_name','second_name','email','phone_1','phone_2','address','country','city','post_box','company')
             ->where('is_active', '=', 1)
             ->get();
             return response()->json([
                 'status' => 200,
                 'suppliers' =>  $suppliers
             ]);


         }catch (\Exception $e) {
             return response()->json([
                 'status'=> 500,
                 'message'=> $e
             ],500);
         }


    }

    public function show($id)
    {
        try{
               $supplier = SupplierAddress::select('supplier_code','first_name','second_name','email','phone_1','phone_2','address','country','city','post_box','company','is_active')
               ->where( 'is_active', '=', 1)
               ->where('id', $id)->first();
               return response()->json([
                   'status' => 200,
                   'supplier' =>  $supplier
               ]);

           }catch (\Exception $e) {
               return response()->json([
                   'status'=> 500,
                   'message'=> $e
               ],500);
           }
    }

    /**
     *
     */
    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        try{
           // $current_date_time = Carbon::now()->toDateTimeString();
            $supplier = SupplierAddress::create([
            'supplier_code'=>$request->supplier_code,
            'first_name'=>$request->first_name,
            'second_name'=>$request->second_name,
            'email' =>$request->email,
            'phone_1' =>$request->phone_1,
            'phone_2'=>$request->phone_2,
            'address'=>$request->address,
            'country' =>$request->country,
            'city'=>$request->city,
            'post_box' =>$request->post_box,
            'company' =>$request->company,
            'created_by' => getUserCode(),
            'created_at' => getDateTimeNow(),
            'updated_by' => getUserCode(),
            'updated_at' => getDateTimeNow(),


        ]);
        return response()->json([
            'status'=> 200,
            'message'=>'Supplier Address - Created'
            ]);


        } catch (\Exception $e) {


            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }

    /**
     *
     */

    public function edit($id)
    {
        //
    }

    /**
    *
    *
     */
    public function update(Request $request, $id)
    {

        $supplier= SupplierAddress::findOrFail($id);
        $supplier->update([
            'first_name'=>$request->first_name,
            'second_name'=>$request->second_name,
            'email' =>$request->email,
            'phone_1' =>$request->phone_1,
            'phone_2'=>$request->phone_2,
            'address'=>$request->address,
            'country' =>$request->country,
            'city'=>$request->city,
            'post_box' =>$request->post_box,
            'company' =>$request->company,
            'updated_by'=> getUserCode(),
            'updated_at'=> getDateTimeNow(),
        ]);
        return response()->json(['status'=> 200, 'message'=> 'Supplier Address Updated']);

        // try{

        //     $supplier= SupplierAddress::findOrFail($id);
        //     $supplier->update([
        //         'first_name'=>$request->first_name,
        //         'second_name'=>$request->second_name,
        //         'email' =>$request->email,
        //         'phone_1' =>$request->phone_1,
        //         'phone_2'=>$request->phone_2,
        //         'address'=>$request->address,
        //         'country' =>$request->country,
        //         'city'=>$request->city,
        //         'post_box' =>$request->post_box,
        //         'company' =>$request->company,
        //         'updated_by'=>$request->updated_by,
        //         'updated_at'=>config('global.current_time')
        //     ]);
        //     return response()->json(['status'=> 200, 'message'=> 'Supplier Address Updated']);

        // } catch (\Exception $e) {


        //     return response()->json([
        //         'status'=> 500,
        //         'message'=> $e
        //     ],500);
        // }
    }


    public function destroy($id)
    {
        try{
            $supplier = SupplierAddress::select('id','is_active')->findOrFail($id);
            $supplier->update([
                'is_active'=>0
            ]);
            return response()->json([
                'status'=> 204,
                'message'=>"Supplier Address - Deleted"
                ]);


            }catch (\Exception $e) {
                return response()->json([
                    'status'=> 500,
                    'message'=> $e
                ],500);
            }
    }

}
