<?php

namespace App\Http\Controllers\Stock_Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Stock_Models\StockLocation;
use App\Enums\TransactionCode;
use Illuminate\Support\Facades\DB;

class StockLocationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try{
            $location  = StockLocation::select('code','name')->where('is_active', '=', 1)->get();
            return response()->json(['status' => 200, 'stockLocation' =>  $location ]);
        }catch (\Exception $e) {
            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }

    public function show($id)
    {
        try{
            $location  = StockLocation::select('code','name')->where('id',$id)->where('is_active', '=', 1)->first();
            return response()->json(['status' => 200, 'stockLocation' =>  $location ]);
        }catch (\Exception $e) {
            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

   
    public function store(Request $request)
    {
        try{

            $loc_code =TransactionCode::STOCK_LOCATION;
            $cus_code = StockLocation::max('code');
            $max_id= $cus_code==null ? config('global.code_value')+1 : substr("$cus_code",3)+1;

            $stockLocation = StockLocation::create([

                'code'=> $loc_code.$max_id,
                'name'=> $request->name,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),

            ]);
           // return response()->json(['status' => 200, 'Stock Location' =>  $stockLocation ]);
            return response()->json(['status' => 200, 'message'=>"Stock Location Created" ]);

        }catch (\Exception $e) {
            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }

   
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try{
            $stockLocation= StockLocation::findOrFail($id);
            $stockLocation->update([
                'name'=>$request->name,
                'updated_by'=> getUserCode(),
                'updated_at'=> getDateTimeNow()
            ]);
            return response()->json(['status'=> 200, 'message'=> 'Stock Location Updated']);
    
            } catch (\Exception $e) {
    
    
                return response()->json([
                    'status'=> 500,
                    'message'=> $e
                ],500);
            }
    }

    
    public function destroy($id)
    {
        try{
            $stockLocation = StockLocation::select('id','is_active')->findOrFail($id);
            $stockLocation->update([
                'is_active'=>0
            ]);
            return response()->json([
                'status'=> 204,
                'message'=>"stock Location - Deleted"
                ]);


            }catch (\Exception $e) {
                return response()->json([
                    'status'=> 500,
                    'message'=> $e
                ],500);
            }
    }
}
