<?php

namespace App\Http\Controllers\Stock_Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Stock_Models\StockHistoryExt;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Resources\Json;
use App\Enums\TransactionCode;

class StockHistoryExtController extends Controller
{
    
    //
    public function index()
    {
        try {

            $stockHistoryExt = StockHistoryExt::select('code', 'stock_history_code', 'source_code','pack_size', 'is_active', 'created_by', 'updated_by')
             
                ->where('is_active', '=', 1)
                ->get();
            return response()->Json(['status' => 200, 'stockHistoryExt' => $stockHistoryExt]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    public function show($id)
    {
        try {

            $stockHistoryExt = StockHistoryExt::select('code', 'stock_history_code', 'source_code','pack_size', 'is_active', 'created_by', 'updated_by')
    
            ->where('is_active', '=', 1)
                ->where('code', $id)
                ->first();
            return response()->Json(['status' => 200, 'stockHistoryExt' => $stockHistoryExt]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    public function store(Request $request)
    {


        try {

            DB::beginTransaction();
            $stock_history_ext_code = TransactionCode::STOCK_HISTORY_EXT;
            $cus_code = StockHistoryExt::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $stockHistoryExt = StockHistoryExt::create([
                'code' => $stock_history_ext_code . $max_id,
                'stock_history_code' => $request->item_code,
                'source_code' => $request->source_code,
                'pack_size' => $request->packSize,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);
            DB::commit();

            return response()->Json(['status' => 200, 'message' => "Stock History created"]);
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }


    public function edit($id)
    {
        //
    }


    public function update(Request $request, $id)
    {
        try {

            $stockHistoryExt = StockHistoryExt::where('id', $id);
            $stockHistoryExt->update([
                'stock_history_code' => $request->item_code,
                'source_code' => $request->source_code,
                'pack_size' => $request->packSize,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);

            return response()->Json(['status' => 200, 'message' => "StockHistory Updated"]);
        } catch (\Exception $e) {

            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }


    public function destroy($id)
    {
        try {

            $stockHistoryExt = StockHistoryExt::findOrFail($id);
            $stockHistoryExt->update(['is_active' => 0]);
            return response()->Json(['status' => 200, 'message' => "Stock History Deleted"]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

}
