<?php

namespace App\Http\Controllers\Stock_Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json;
use App\Models\Stock_Models\StockHistory;
use App\Enums\TransactionCode;
use Exception;
use Illuminate\Support\Facades\DB;

class StockHistoryController extends Controller
{

    public function index()
    {
        try {

            $stockHistory = StockHistory::select(
                'code',
                'item_code',
                'source_code',
                'source',
                'stock_code',
                'stock_location_code',
                'wholesale_price',
                'retail_price',
                'dealer_price',
                'least_price',
                'cost_price',
                'unit_sold_price',
                'quantity',
                'remaining_quantity',
                'discount_amount',
                'remaining_quantity',
                'total_amount',
                'expiry_date',
                'warranty_periods',
                'is_active',
                'created_by',
                'updated_by'
            )
                ->with([
                    'itemMaster' => function ($query) {
                        $query->select('code', 'name', 'barcode')->where('is_active', '=', 1);
                    },
                    'stockLocation' => function ($query) {
                        $query->select('code', 'name', )->where('is_active', '=', 1);
                    }
                ])
                ->where('is_active', '=', 1)
                ->get();
            return response()->Json(['status' => 200, 'stockHistory' => $stockHistory]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    public function indexPos()
    {
        try {

            $stockHistory = StockHistory::select('code', 'item_code', 'source_code', 'source', 'stock_code', 'stock_location_code', 'wholesale_price', 'retail_price', 'dealer_price', 'least_price', 'cost_price', 'unit_sold_price', 'quantity', 'remaining_quantity', 'discount_amount', 'remaining_quantity', 'total_amount', 'expiry_date', 'warranty_periods', 'is_active', 'created_by', 'updated_by')
                ->with([
                    'itemMaster' => function ($query) {
                        $query->select('code', 'name', 'barcode')
                            ->where('is_active', '=', 1);
                    },
                    'stockLocation' => function ($query) {
                        $query->select('code', 'name', )->where('is_active', '=', 1);
                    }
                ])
                ->where('is_active', '=', 1)
                ->get();
            return response()->Json(['status' => 200, 'stockHistory' => $stockHistory]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }


    public function show($id)
    {
        try {

            $stockHistory = StockHistory::select('code', 'item_code', 'source_code', 'source', 'stock_code', 'stock_location_code', 'wholesale_price', 'retail_price', 'dealer_price', 'least_price', 'cost_price', 'unit_sold_price', 'quantity', 'remaining_quantity', 'discount_amount', 'total_amount', 'expiry_date', 'warranty_periods', 'is_active', 'created_by', 'updated_by')
                ->with([
                    'itemMaster' => function ($query) {
                        $query->select('code', 'name', 'barcode')->where('is_active', '=', 1);
                    },
                    'stockLocation' => function ($query) {
                        $query->select('code', 'name', )->where('is_active', '=', 1);
                    }
                ])
                ->where('is_active', '=', 1)
                ->where('code', $id)
                ->first();
            return response()->Json(['status' => 200, 'stockHistory' => $stockHistory]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    public function create()
    {
    }


    public function store(Request $request)
    {


        try {

            DB::beginTransaction();
            $stock_history_code = TransactionCode::STOCK_HISTORY;
            $cus_code = StockHistory::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $stockHistory = StockHistory::create([
                'code' => $stock_history_code . $max_id,
                'item_code' => $request->item_code,
                'source_code' => $request->source_code,
                'source' => $request->source,
                'stock_location_code' => $request->stock_location_code,
                'wholesale_price' => $request->wholesale_price,
                'retail_price' => $request->retail_price,
                'dealer_price' => $request->dealer_price,
                'least_price' => $request->least_price,
                'cost_price' => $request->cost_price,
                'quantity' => $request->quantity,
                'remaining_quantity' => 0,
                'discount_amount' => $request->discountAmount,
                'total_amount' => $request->totalAmount,
                'expiry_date' => $request->expiry_date,
                'warranty_periods' => $request->warranty_periods,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);
            DB::commit();

            return response()->Json(['status' => 200, 'message' => "Stock History created"]);
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }





    public function edit($id)
    {
        //
    }


    public function update(Request $request, $id)
    {
        try {

            $stockHistory = StockHistory::where('id', $id);
            $stockHistory->update([
                'item_code' => $request->item_code,
                'source_code' => $request->source_code,
                'source' => $request->source,
                'stock_location_code' => $request->stock_location_code,
                'wholesale_price' => $request->wholesale_price,
                'retail_price' => $request->retail_price,
                'dealer_price' => $request->dealer_price,
                'least_price' => $request->least_price,
                'cost_price' => $request->cost_price,
                'quantity' => $request->quantity,
                'remaining_quantity' => 0,
                'discount_amount' => $request->discountAmount,
                'total_amount' => $request->totalAmount,
                'expiry_date' => $request->expiry_date,
                'warranty_periods' => $request->warranty_periods,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);

            return response()->Json(['status' => 200, 'message' => "StockHistory Updated"]);
        } catch (\Exception $e) {

            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }


    public function destroy($id)
    {
        try {

            $stockHistory = StockHistory::findOrFail($id);
            $stockHistory->update(['is_active' => 0]);
            return response()->Json(['status' => 200, 'message' => "Stock History Deleted"]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }
}