<?php

namespace App\Http\Controllers\Stock_Controllers;

use App\Enums\FreezeStatus;
use App\Enums\MultiPurposeStatus;
use App\Enums\TransactionCode;
use App\Http\Controllers\Controller;
use App\Models\Invoice_Models\Invoice;
use App\Models\Invoice_Models\SalesReturn;
use App\Models\Stock_Models\Grn;
use App\Models\Stock_Models\Stock;
use App\Models\Stock_Models\StockFreeze;
use App\Models\Stock_Models\StockHistory;
use App\Models\Supplier_Models\PurchaseReturn;
use Exception;
use Illuminate\Http\Request;

class StockController extends Controller
{
    public function index()
    {
        try {
            $stock = Stock::select('item_code', 'remaining_quantity', 'is_active')
                ->where('is_active', '=', 1)
                ->get();
            return response()->json(['status' => 200, 'stock' => $stock]);

        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    public function show($id)
    {
        try {
            $stock = Stock::select('item_code', 'remaining_quantity', 'is_active')
                ->where('is_active', '=', 1)
                ->where('id', $id)
                ->first();
            return response()->json(['status' => 200, 'items' => $stock]);

        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }


    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        try {
            $stock_code = TransactionCode::STOCK;
            $max_code = Stock::max('code');
            $max_id = $max_code == null ? config('global.code_value') + 1 : substr("$max_code", 3) + 1;
            $stock = Stock::create([
                'code' => $stock_code . $max_id,
                'item_code' => $request->item_code,
                'remaining_quantity' => $request->remaining_quantity,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);

            return response()->json(['status' => 200, 'message' => "Created"]);

        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }


    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            $stock = Stock::findOrFail($id);
            $stock->update([
                'item_code' => $request->item_code,
                'remaining_quantity' => $request->remaining_quantity,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);

            return response()->json(['status' => 200, 'message' => "Updated"]);

        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {
            $stock = Stock::findOrFail($id);
            $stock->update([
                'is_active' => 1
            ]);

            return response()->json(['status' => 200, 'message' => "Deleted"]);

        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }
    
    /**
     * stockFreeze
     * author: fathima sajana
     * version: 01
     * Date: 2023.12.18
     * Logic: if we select the date, before selected date stock data and stock history data also will be updated
     * @param  mixed $request
     * @return void
     */
    public function stockFreeze1(Request $request)
    {
        try {
            $stocks = Stock::where('created_at', '<=', date('Y-m-d H:i:s', strtotime($request->fromDate)))
                ->where('is_freeze', '=', 0)
                ->where('is_active', '=', 1)
                ->get();
    
            foreach ($stocks as $stock) {
                $stock->update([
                    'is_freeze' => FreezeStatus::FREEZED,
                ]);
            }

            $stockHistories = StockHistory::where('created_at', '<=', date('Y-m-d H:i:s', strtotime($request->fromDate)))
            ->where('is_freeze', '=', 0)
            ->where('is_active', '=', 1)
            ->get();         
    
            $stockFreeze = StockFreeze::create([
                'stock_location_code' => getCurrentLocationCode($request),
                'date_time' => getDateTimeNow(),
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);  

            return response()->json([
                'status' => 200,
                'stocks' => $stocks,
                'stockFreeze' => $stockFreeze,
                'message' => 'Stock has been frozen',
            ]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }
    
    public function stockFreezeWithReplicate(Request $request)
{
    try {
        $fromDate = date('Y-m-d H:i:s', strtotime($request->fromDate));

        // Replicate frozen stocks with remaining_quantity set to zero
        $frozenStocks = Stock::where('created_at', '<=',  [date('Y-m-d H:m:s', strtotime($request->fromDate))])
            ->where('is_freeze', '=', FreezeStatus::NON_FREEZED)
            ->where('is_active', '=',  MultiPurposeStatus::ACTIVE)
            ->get();

        foreach ($frozenStocks as $frozenStock) {
            
        // Update is_freeze for existing stocks
        Stock::where('code', '=', $frozenStock->code)
        ->update([
            'is_freeze' => FreezeStatus::FREEZED,
            'updated_by' => getUserCode(),
            'updated_at' => getDateTimeNow(),
        ]);

            $frozenStockCode = TransactionCode::STOCK;
            $maxCode = Stock::max('code');
            $maxId = $maxCode == null ? config('global.code_value') + 1 : substr("$maxCode", 3) + 1;
                                    
            Stock::create([
                'code' => $frozenStockCode . $maxId,
                'item_code' => $frozenStock->item_code,
                'stock_location_code' => $frozenStock->stock_location_code,
                'grn_code' => $frozenStock->grn_code,
                'batch' => $frozenStock->batch ?? null,
                'remaining_quantity' => 0,
                'order_quantity' => $frozenStock->order_quantity ?? null,
                'wholesale_price' => $frozenStock->wholesale_price ?? null,
                'retail_price' => $frozenStock->retail_price ?? null,
                'dealer_price' => $frozenStock->dealer_price?? null,
                'least_price' => $frozenStock->least_price ?? null,
                'cost_price' => $frozenStock->cost_price ?? null,
                'discount_price' => $frozenStock->discount_price ?? null,
                'discount' => $frozenStock->discount?? null,
                'is_freeze' => FreezeStatus::NON_FREEZED,
                'is_active' =>  MultiPurposeStatus::ACTIVE,
                'created_at' => getDateTimeNow(),
                'updated_at' => getDateTimeNow(),
                'created_by' => getUserCode(),
                'updated_by' => getUserCode(),

            ]);
        }

        // Update is_freeze for existing stock histories
        $StockHistory = StockHistory::where('created_at', '<=',  [date('Y-m-d H:m:s', strtotime($request->fromDate))])
            ->where('is_freeze', '=', FreezeStatus::NON_FREEZED)
            ->where('is_active', '=', MultiPurposeStatus::ACTIVE)
            ->update(['is_freeze' => FreezeStatus::FREEZED,
                        'updated_by' => getUserCode(),
                        'updated_at' => getDateTimeNow(),]);

        $invoice = Invoice::where('created_at', '<=',  [date('Y-m-d H:m:s', strtotime($request->fromDate))])
            ->where('is_freeze', '=', FreezeStatus::NON_FREEZED)
            ->where('is_active', '=', MultiPurposeStatus::ACTIVE)
            ->update(['is_freeze' => FreezeStatus::FREEZED,
                        'freeze_time' => getDateTimeNow(),
                        'updated_by' => getUserCode(),
                        'updated_at' => getDateTimeNow(),]);

        $invoice = SalesReturn::where('created_at', '<=',  [date('Y-m-d H:m:s', strtotime($request->fromDate))])
        ->where('is_freeze', '=', FreezeStatus::NON_FREEZED)
        ->where('is_active', '=', MultiPurposeStatus::ACTIVE)
        ->update(['is_freeze' => FreezeStatus::FREEZED,
                    'freeze_time' => getDateTimeNow(),
                    'updated_by' => getUserCode(),
                    'updated_at' => getDateTimeNow(),]);

        $invoice = PurchaseReturn::where('created_at', '<=',  [date('Y-m-d H:m:s', strtotime($request->fromDate))])
        ->where('is_freeze', '=', FreezeStatus::NON_FREEZED)
        ->where('is_active', '=', MultiPurposeStatus::ACTIVE)
        ->update(['is_freeze' => FreezeStatus::FREEZED,
                    'freeze_time' => getDateTimeNow(),
                    'updated_by' => getUserCode(),
                    'updated_at' => getDateTimeNow(),]);

        $grn = Grn::where('created_at', '<=',  [date('Y-m-d H:m:s', strtotime($request->fromDate))])
        ->where('is_freeze', '=', FreezeStatus::NON_FREEZED)
        ->where('is_active', '=', MultiPurposeStatus::ACTIVE)
        ->update(['is_freeze' => FreezeStatus::FREEZED,
                    'freeze_time' => getDateTimeNow(),
                    'updated_by' => getUserCode(),
                    'updated_at' => getDateTimeNow(),]);            
                        

        // Create StockFreeze record
        StockFreeze::create([
            'stock_location_code' => getCurrentLocationCode($request),
            'date_time' => getDateTimeNow(),
            'created_by' => getUserCode(),
            'created_at' => getDateTimeNow(),
            'updated_by' => getUserCode(),
            'updated_at' => getDateTimeNow(),
        ]);

        return response()->json([
            'status' => 200,
            'message' => 'Stock has been frozen',
            'StockHistory' => $StockHistory

        ]);
    } catch (\Exception $e) {
        throw new Exception($e);
    }
}

    

    /**
     * getStockDetailsByGrn
     * Author: Suhail Jamaldeen
     * Date: 21.12.2022
     * Version: 01
     * Logic: Get the stock details based on grn code
     * @param  mixed $key
     * @return void
     */
    public function getStockDetailsByGrn($key)
    {
        try {
            $stock = Stock::select(
                'code as stockCode',
                'item_code',
                'retail_price',
                'remaining_quantity',
                'is_active',
                'cost_price',
                'grn_code'
            )

                ->with([
                    'itemMaster' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'grn' => function ($query) {
                        $query->where('is_active', '=', 1);
                    },
                    'grn.stockHistories' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->where('is_active', '=', 1)
                ->where('stocks.grn_code', '=', $key)
                ->get();
            return response()->json(['status' => 200, 'stock' => $stock]);

        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }
}