<?php

namespace App\Http\Controllers\Stock_Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Stock_Models\StockBatch;

class StockBatchController extends Controller
{

    public function index()
    {
        try{
            $stockBatch= StockBatch::select('stock_history_code','quantity','remaining_quantity','expiry_date','is_active')
           ->where('is_active','=',1)
            ->get();
            return response()->json(['status'=> 200, 'stockBatch'=>$stockBatch]);

        }catch (\Exception $e) {
            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }

    public function show($id)
    {
        try{
            $stockBatch= StockBatch::select('stock_history_code','quantity','remaining_quantity','expiry_date','is_active')
           ->where('is_active','=',1)
           ->where('id',$id)
            ->first();
            return response()->json(['status'=> 200, 'items'=>$stockBatch]);

        }catch (\Exception $e) {
            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }


    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        try{
            $stockBatch = StockBatch::create([
                'stock_history_code'=>$request->stock_history_code,
                'quantity'=>$request->quantity,
                'remaining_quantity'=>$request->remaining_quantity,
                'expiry_date'=>$request->expiry_date,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);

            return response()->json(['status'=> 200, 'message'=>"Created"]);

        }catch (\Exception $e) {
            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }


    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try{
            $stockBatch = StockBatch::findOrFail($id);
            $stockBatch->update([
                'stock_history_code'=>$request->stock_history_code,
                'quantity'=>$request->quantity,
                'remaining_quantity'=>$request->remaining_quantity,
                'expiry_date'=>$request->expiry_date,
                'updated_by'=> getUserCode(),
                'updated_at'=> getDateTimeNow(),
            ]);

            return response()->json(['status'=> 200, 'message'=>"Updated"]);

        }catch (\Exception $e) {
            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try{
            $stockBatch = StockBatch::findOrFail($id);
            $stockBatch->update([
                'is_active'=>1
            ]);

            return response()->json(['status'=> 200, 'message'=>"Deleted"]);

        }catch (\Exception $e) {
            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }
}
