<?php

namespace App\Http\Controllers\Stock_Controllers;

use Exception;
use App\Models\User;
use App\Enums\UserRole;
use Illuminate\Http\Request;
use App\Enums\TransactionCode;
use App\Models\Stock_Models\Route;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\Stock_Models\SalesRep;
use App\Models\Customer_Models\Customer;
use App\Models\PaymentReceipt_Models\InvoicePaymentReceipt;


class SalesRepController extends Controller
{

    public function index()
{
    try {
        $salesRep = User::select('id','code','stock_location_code', 'custom_code','username','is_active','commission_percentage')
            ->with(['stockLocations' => function($query) {
                $query->where('stock_location_user_roles.role_id', UserRole::SALES_REP); // Filter stockLocations by role_id
            }])
            //->where('is_active', 1)
            ->whereHas('stockLocations', function($query) {
                $query->where('stock_location_user_roles.role_id', UserRole::SALES_REP); // Filter users by stockLocations having role_id = UserRole::SALES_REP
            })
            ->get();

        return response()->json(['status' => 200, 'salesRep' => $salesRep]);
    } catch (Exception $e) {
        throw new Exception($e);
    }
}


public function show($id)
{
    try {
        $salesRep = User::select('id','code','stock_location_code','custom_code', 'username','is_active','commission_percentage')
            ->with(['stockLocations' => function($query) {
                $query->where('stock_location_user_roles.role_id', UserRole::SALES_REP); // Filter stockLocations by role_id
            }])

            ->whereHas('stockLocations', function($query) {
                $query->where('stock_location_user_roles.role_id', UserRole::SALES_REP); // Filter users by stockLocations having role_id = 6
            })
            ->where('code', $id)
            ->first();

        return response()->json(['status' => 200, 'salesRep' => $salesRep]);
    } catch (Exception $e) {
        throw new Exception($e);
    }
}

public function store(Request $request)
{
    try {
        DB::beginTransaction();
        $user_code = TransactionCode::USER_CODE;
        $sb_code = User::max('code');
        $max_id = $sb_code == null ? config('global.code_value') + 1 : substr("$sb_code", 3) + 1;

        // Check if the username already exists in the database
        $existingRep = DB::select('SELECT * FROM users WHERE username = ?', [$request->username]);
        $existingCustomCode = DB::select('SELECT * FROM users WHERE custom_code = ?', [$request->customCode]);

        if ($existingCustomCode) {
            return response()->json([
                'status' => 200,
                'recordExiting' => true,
                'message' => "'{$request->customCode}' is already existing!",
            ], 200);
        }

        if ($existingRep) {
            return response()->json([
                'status' => 200,
                'recordExiting' => true,
                'message' => "'{$request->username}' is already existing!",
            ], 200);
        }



        // Insert user into users table
        DB::insert('INSERT INTO users (code,stock_location_code, custom_code, commission_percentage, username,  created_at, updated_at) VALUES (?, ?, ?, ?, ?, ?,?)', [
            $user_code . $max_id,
            getCurrentLocationCode($request),
            $request->customCode,
            $request->commissionPercentage,
            $request->username,
            getDateTimeNow(),
            getDateTimeNow()
        ]);


        // Get the user ID of the newly created user
        $userId = DB::getPdo()->lastInsertId();



        // Insert into stock_location_user_roles table
        DB::insert('INSERT INTO stock_location_user_roles (user_id, stock_location_code, role_id, created_by, updated_by, created_at, updated_at) VALUES (?, ?, ?, ?, ?, ?, ?)', [
            $userId,
            getCurrentLocationCode($request),
            UserRole::SALES_REP,
            getUserCode(),
            getUserCode(),
            getDateTimeNow(),
            getDateTimeNow()
        ]);

        DB::commit();
        return response()->json(['status' => 200, 'message' => "Sales boy created successfully"]);

    } catch (Exception $e) {
        DB::rollBack();
        return response()->json([
            'status' => 500,
            'message' => $e->getMessage()
        ], 500);
    }
}

public function salesRepSearch($key)
{
    try {
        $salesRep = User::select(
            'id',
            'code',
            'stock_location_code',
            'custom_code',
            'username',
            'is_active',
            'commission_percentage'
        )
        ->with([
            'stockLocations' => function($query) {
                $query->where('stock_location_user_roles.role_id', UserRole::SALES_REP); // Filter stockLocations by role_id
            },
            'routes' => function($query) {
                $query->where('is_active', 1); // Filter active routes
            },
            'routes.customers' => function($query) {
                $query->where('is_active', 1); // Filter active customers within routes
            }
        ])
        ->whereHas('stockLocations', function($query) {
            $query->where('stock_location_user_roles.role_id', UserRole::SALES_REP); // Filter users by stockLocations having role_id = UserRole::SALES_REP
        })
        ->where('is_active', 1)
        ->where(function ($query) use ($key) {
            $query->where('code', 'like', "%$key%")
                  ->orWhere('username', 'like', "%$key%");
        })
        ->get();

        return response()->json(['status' => 200, 'salesRep' => $salesRep]);
    } catch (Exception $e) {
        throw new Exception($e);
    }
}



public function update(Request $request, $id)
{

    try {
        DB::beginTransaction();

        $user = User::where('code', $id)->first();
        $user->update([
            'custom_code'=>$request->customCode,
            'commission_percentage'=>$request->commissionPercentage,
            'username' =>$request->username,
            'is_active'=>$request->isActive,
            'updated_at' => getDateTimeNow(),

        ]);

            DB::commit();
            return response()->json([
                'status' => 200,
                'message' => "Saleboy Updated",

            ], 200);

    } catch (Exception $e) {

        DB::rollBack();
        throw new Exception($e);
    }
}

}
