<?php

namespace App\Http\Controllers\Stock_Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Stock_Models\Route;
use App\Enums\TransactionCode;
use Illuminate\Support\Facades\DB;
use Exception;



class RouteController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //try {
            // use select query
            $routes = Route::select(
                'routes.code',
                'routes.stock_location_code',
                'routes.rep_code',
                'name',
                'effective_date_time',
                'expiry_data_time',
                'from',
                'to',
                'is_active')

                ->with([
                    'salesRep' => function ($query) {
                        $query->select(
                            'code',
                            'username'
                        )->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'customers' => function ($query) {
                         $query->select(
                            'route_code',
                            'code',
                            'first_name'
                        )->where('is_active', '=', 1);
                    }
                ])
                ->where('is_active', '=', 1)
                ->get();
            return response()->json([
                'status' => 200,
                'route' => $routes,
                'defaultLocation' => getCurrentLocationCode($request)
            ]);
        // } catch (\Exception $e) {
        //     return response()->json([
        //         'status' => 500,
        //         'message' => $e
        //     ], 500);
        // }
    }

    public function show($id)
    {
        try {
            // use select query
            $routes = Route::select('routes.code', 'routes.rep_code', 'name', 'effective_date_time', 'expiry_data_time', 'from', 'to', 'is_active')
                ->with([
                    'salesRep' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'customers' => function ($query) {
                         $query->select(
                            'route_code',
                            'code',
                            'first_name'
                        )->where('is_active', '=', 1);
                    }
                ])
                ->where('is_active', '=', 1)
                ->where('code', $id)
                ->first();
            return response()->json([
                'status' => 200,
                'Route' => $routes
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    public function routeSearch($key)
    {
        try {

            $routes = Route::select('code','stock_location_code', 'name')
                ->where('is_active', '=', 1)
                ->where(function ($query) use ($key) {
                    $query->Where('code', 'like', "%$key%")
                        ->orWhere('name', 'like', "%$key%");
                })->get();

            return response()->json([
                'status' => 200,
                'Route' => $routes
            ]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        try {
            DB::transaction(function () {
            });

            $routes = TransactionCode::ROUTE;
            $bixz_code = Route::max('code');
            $max_id = $bixz_code == null ? config('global.code_value') + 1 : substr("$bixz_code", 3) + 1;
            DB::beginTransaction();


            Route::create([
                'code' => $routes . $max_id,
                'stock_location_code'=> getCurrentLocationCode($request),
                'rep_code' => $request['salesRep']['code'],
                'name' => $request->name,
                'effective_date_time' => $request->effective_date_time,
                'expiry_data_time' => $request->expiry_data_time,
                'from' => $request->from,
                'to' => $request->to,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),

            ]);
            DB::commit();
            return response()->json([
                'status' => 200,
                'message' => "Route Created"
            ], 200);

        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }


    public function edit($id)
    {
        //
    }


    public function update(Request $request, $id)
    {
        try {
            DB::transaction(function () {
            });

            DB::beginTransaction();

            $route = Route::where('code', $id)->first();
            $route->update([
                'rep_code' => $request['salesRep']['code'],
                'name' => $request->name,
                'effective_date_time' => $request->effective_date_time,
                'expiry_data_time' => $request->expiry_data_time,
                'from' => $request->from,
                'to' => $request->to,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),

            ]);
            DB::commit();
            return response()->json([
                'status' => 200,
                'message' => "Route Updated"
            ], 200);

        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {

            $route = Route::select('is_active')->findOrFail($id);
            $route->update([
                'is_active' => 0

            ]);
            return response()->json(['status' => 200, 'message' => "Route Delete"]);

        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }
}
