<?php

namespace App\Http\Controllers\Stock_Controllers;

use App\Http\Controllers\Controller;
use App\Models\Stock_Models\MatureStock;
use App\Models\Stock_Models\Stock;
use Illuminate\Http\Request;

class MatureStockController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //

        try {
            $matureStocks = Stock::select('code','item_code', 'remaining_quantity', 'retail_price', 'wholesale_price', 'cost_price' ,'least_price',  'is_active')
            ->with([
                'itemMaster' => function ($query) {
                    $query->where('is_active', '=', 1);
                }
            ])    
            ->where('is_active', '=', 1)
            ->where('remaining_quantity', '=', 0)
            ->get();
            return response()->json([
            'status' => 200, 
            'matureStocks' => $matureStocks]);

        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }


    public function show($id)
    {
        try {
            $matureStock = Stock::select('code','item_code', 'remaining_quantity', 'retail_price', 'wholesale_price', 'cost_price' ,'least_price', 'is_active')
            ->with([
                'itemMaster' => function ($query) {
                    $query->where('is_active', '=', 1);
                }
            ])     
            ->where('is_active', '=', 1)
            ->where('code', $id)
            ->where('remaining_quantity', '=', 0)
            ->first();
            return response()->json(['status' => 200, 'matureStock' => $matureStock]);

        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Stock_Models\MatureStock  $matureStock
     * @return \Illuminate\Http\Response
     */


    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Stock_Models\MatureStock  $matureStock
     * @return \Illuminate\Http\Response
     */
    public function edit(MatureStock $matureStock)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Stock_Models\MatureStock  $matureStock
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, MatureStock $matureStock)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Stock_Models\MatureStock  $matureStock
     * @return \Illuminate\Http\Response
     */
    public function destroy(MatureStock $matureStock)
    {
        //
    }
}
