<?php

namespace App\Http\Controllers\StockIssue_Controllers;

use App\Http\Controllers\Controller;
use App\Models\StockIssue_Models\StockIssueType;
use Illuminate\Http\Request;

class StockIssueTypeController extends Controller
{

    public function index()
    {
        try {
            $stockIssueType  = StockIssueType::select('code', 'name')->where('is_active', '=', 1)->get();

            return response()->json(
                ['status' => 200, 'stockIssueType' =>
                $stockIssueType]
            );
        } catch (\Exception $e) {

            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    public function show($id)
    {
        try {
            $stockIssueType  = StockIssueType::select('code', 'name')
                ->where('is_active', '=', 1)
                ->where('code', '=', $id)->get();
            return response()->json(
                [
                    'status' => 200,
                    'stockIssueType' =>  $stockIssueType
                ]
            );
        } catch (\Exception $e) {

            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
