<?php

namespace App\Http\Controllers\Report_Location_Based_Controller;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Exception;
use App\Models\Stock_Models\Grn;
use Illuminate\Support\Facades\DB;

class PurchaseLocationReportController extends Controller
{
    /**
     * dailyLocationPurchases
     * logic: daily and periodic purchase location based
     * Author: Fathima Sajana
     * Date : 2023.03.02
     * version : 01
     * @param  mixed $request
     * @return void
     */
    public function dailyLocationPurchases(Request $request)
    {

        try {
        $grn = Grn::select('grns.code', 'stock_location_code', 'invoice_date', 'grn_date', 'supplier_code', 'sub_total_amount','total_amount', 'paid_status', 'invoice_code')
            ->with(['stockLocation' => function ($query) {
                $query->select('code', 'name')->where('is_active', '=', 1);
            }])

            ->with(['purchaseReturns' => function ($query) {
                $query->select('code', 'grn_code')->where('is_active', '=', 1);
            }])
            ->with(['supplier' => function ($query) {
                $query->select('code', 'name',)->where('is_active', '=', 1);
            }])
            ->whereBetween('invoice_date', [date('Y-m-d H:m:s', strtotime($request->fromDate)-1), date('Y-m-d H:m:s', strtotime($request->toDate))])
            ->where('stock_location_code', '=', getCurrentLocationCode($request))
            ->get();

        return response()->json(['status' => 200, 'dailyPurchase' => $grn], 200);

    } catch (\Exception $e) {
        throw new Exception($e);
    }
    }


    /**
     * detailsPurchasesLocationBased
     * logic: details purchase location based
     * author : fathima sajana
     * version: 1
     * date: 2023.03.07
     * @param  mixed $request
     * @return void
     */
    public function detailsPurchasesLocationBased(Request $request)
    {
        try {
            $grn = Grn::select('grns.code', 'stock_location_code', 'invoice_date', 'grn_date', 'supplier_code', 'sub_total_amount', 'total_amount', 'paid_status')
            ->with(['stockLocation' => function ($query) {
                $query->select('code', 'name')->where('is_active', '=', 1);
            }])
            ->with(['supplier' => function ($query) {
                $query->select('code', 'name', 'contact_name', 'phone_1')
                ->where('is_active', '=', 1);
            }])
            ->with(['stockHistories' => function($query){
                $query->where('is_active', '=', 1);
            }])
            ->with(['stockHistories.itemMaster' => function($query){
                $query->select('code', 'name')
                ->where('is_active', '=', 1);
            }])
           // stockHistory
            ->whereBetween('invoice_date', [date('Y-m-d H:m:s', strtotime($request->fromDate)), date('Y-m-d H:m:s', strtotime($request->toDate))])
            ->where('stock_location_code', '=', getCurrentLocationCode($request))
            ->get();

        return response()->json(['status' => 200, 'detailsPurchase' => $grn], 200);

    } catch (\Exception $e) {
        throw new Exception($e);
    }

    }

    /**
     * monthlyPurchases
     * author : fathima sajana
     * date: 2023.03.29
     * version: 01
     * logic :monthly purchase current location based
     * @param  mixed $request
     * @return void
     */
    public function monthlyPurchasesLocationBased(Request $request)
{
    $month = $request->month;
    $year = $request->year;
    $stockLocationCode = getCurrentLocationCode($request);

    try {
        $sql = "SELECT supplier_code, suppliers.name, sum(total_amount) as grn_total
         FROM grns
         INNER JOIN suppliers on suppliers.code = grns.supplier_code
         WHERE MONTH(grns.invoice_date) = $month AND YEAR(grns.invoice_date) = $year AND grns.stock_location_code = $stockLocationCode
         GROUP BY supplier_code
         ORDER BY supplier_code";

        $results = DB::select($sql);

        return response()->Json(['status' => 200, 'monthlyPurchase' => $results]);


        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
}
}
