<?php

namespace App\Http\Controllers\Report_Location_Based_Controller;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\PaymentVoucher_Models\GrnPaymentVoucher;
use Exception;

class PaymentVoucherLocationReportController extends Controller
{
      /**
     * dailyPaymentVoucherLocationBased
     * logic: periodic payment receipt location based 
     * version : 1
     * Date : 2023.11.04
     * Author: Aasif Saneeth
     * @param  mixed $request
     * @return void
     */

     public function dailyPaymentVoucherLocationBased(Request $request)
     {
         try {
                 $grnVoucherDetails = GrnPaymentVoucher::select(
                     'code',
                     'grn_total',
                     'paid_amount',
                     'outstanding',
                     'payment_voucher_code',
                     'grn_code'
                 )
                    //  ->with([
                    //      'invoice' => function ($query) {
                    //          $query
                    //         // ->where('status', '<>', 5)
                    //          ->where('is_active', '=', 1);
                    //      }
                    //  ])
                     ->with([
                         'paymentVoucher' => function ($query) {
                             $query
                             ->where('status', '<>', 5)
                             ->where('is_active', '=', 1);
                         }
                     ])
 
                     ->with([
                         'paymentVoucher.stockLocation' => function ($query) {
                             $query->select('code', 'name')
                             ->where('is_active', '=', 1);
                         }
                     ])
 
                     ->with([
                         'paymentVoucher.supplier' => function ($query) {
                             $query->select('code', 'name')
                             ->where('is_active', '=', 1);
                         }
                     ])
                    //  ->with([
                    //      'paymentVoucher.modeOfPayments' => function ($query) {
                    //          $query->select('code', 'payment_voucher_code','amount')
                    //          ->where('status', '<>', 5)
                    //          ->where('is_active', '=', 1);
                    //      }
                    //  ])
                     ->whereBetween('created_at', [date('Y-m-d H:m:s', strtotime($request->fromDate)-1), date('Y-m-d H:m:s', strtotime($request->toDate))], )        
                      ->whereHas('paymentVoucher.stockLocation', function ( $query) use ($request)
                      {$query
                      ->where('code', '=', getCurrentLocationCode($request));})
                     ->where('status', '<>', 5)
                     ->where('is_active', '=', 1)
                     ->get();
 
         return response()->json(['status' => 200,
         'grnVoucherDetails' => $grnVoucherDetails
     ],
         200);
  
      } catch (\Exception $e) {
      throw new Exception($e);
      }
      }

       /**
     * dailyPaymentVoucherLocationBasedByPaymentType
     * Author: Aasif Saneeth
     * Date :82023.11.04
     * Version: 01
     * Logic : daily payment Voucher with payment types(cash , cheque, bank, card, return, over , online)
     * @param  mixed $request
     * @return void
     */
    public function dailyPaymentVoucherLocationBasedByPaymentType(Request $request)
    {

    try {
        $grnVoucherDetails = GrnPaymentVoucher::select(
            'code',
            'grn_total',
            'paid_amount',
            'outstanding',
            'payment_voucher_code',
            'grn_code'
        )
            ->with([
                'grn' => function ($query) {
                    $query->where('is_active', '=', 1);
                }
            ])
            ->with([
                'paymentVoucher.stockLocation' => function ($query) {
                    $query->select('code', 'name')->where('is_active', '=', 1);
                }
            ])

            ->with([
                'paymentVoucher.supplier' => function ($query) {
                    $query->select('code', 'name')
                    ->where('is_active', '=', 1);
                }
            ])
            ->with([
                'paymentVoucher.supplierModeOfPayments' => function ($query) {
                    $query->select('code', 'payment_voucher_code','amount', 'payment_type_code')
                    ->where('status', '<>', 5)
                    ->where('is_active', '=', 1);
                }
            ])
            ->whereBetween('date_time', [date('Y-m-d H:m:s', strtotime($request->fromDate)-1), date('Y-m-d H:m:s', strtotime($request->toDate))], )
   
            ->whereHas('paymentVoucher.stockLocation', function ( $query) use ($request)
            {$query
            ->where('code', '=', getCurrentLocationCode($request));})
            ->where('status', '<>', 5)
            ->where('is_active', '=', 1)
            ->get();

            return response()->json(['status' => 200,
            'grnVoucherDetails' => $grnVoucherDetails
            ],
            200);

        }
         catch (\Exception $e) {
        throw new Exception($e);
        }
    }

}
