<?php

namespace App\Http\Controllers\Report_Location_Based_Controller;

use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\Invoice_Models\Invoice;
use App\Models\PaymentReceipt_Models\PaymentReceipt;
use App\Models\PaymentReceipt_Models\InvoicePaymentReceipt;

class PaymentReceiptLocationReportController extends Controller
{
    /**
     * dailyPaymentReceiptLocationBased
     * logic: daily and periodic payment receipt location based
     * version : 1
     * Date : 2023.03.03
     * Author: Fathima Sajana
     * @param  mixed $request
     * @return void
     */

    public function dailyPaymentReceiptLocationBased(Request $request)
    {
        try {

                $stockLocationCode = getCurrentLocationCode($request);
                $invoiceReceiptDetails = InvoicePaymentReceipt::select(
                    'code',
                    'invoice_total',
                    'paid_amount',
                    'outstanding',
                    'payment_receipt_code',
                    'invoice_code'
                )
                    ->with([
                        'invoice' => function ($query) {
                            $query
                                ->where('is_active', '=', 1);
                        }
                    ])
                    ->with([
                        'paymentReceipt' => function ($query) {
                            $query
                                ->where('status', '<>', 5)
                                ->where('is_active', '=', 1);
                        }
                    ])
                    ->with([
                        'paymentReceipt.stockLocation' => function ($query) {
                            $query->select('code', 'name')
                                ->where('is_active', '=', 1);
                        }
                    ])
                    ->with([
                        'paymentReceipt.customer' => function ($query) {
                            $query->select('code', 'first_name')
                                ->where('is_active', '=', 1);
                        }
                    ])
                    ->with([
                        'paymentReceipt.modeOfPayments' => function ($query) {
                            $query->select('code','payment_type_code', 'payment_receipt_code','amount')
                                ->where('status', '<>', 5)
                                ->where('is_active', '=', 1);
                        }
                    ])
                    ->whereBetween('date_time', [date('Y-m-d H:m:s', strtotime($request->fromDate)-1), date('Y-m-d H:m:s', strtotime($request->toDate))])
                    ->whereHas('paymentReceipt.stockLocation', function ($query) use ($stockLocationCode) {
                        $query->where('code', '=', $stockLocationCode);
                    })
                    ->where('status', '<>', 5)
                    ->where('is_active', '=', 1)
                    ->get();


        return response()->json(['status' => 200,
        'invoiceReceiptDetails' => $invoiceReceiptDetails
    ],
        200);

     } catch (\Exception $e) {
     throw new Exception($e);
     }
     }


    /**
     * dailyPaymentReceiptLocationBasedByPaymentType
     * Author: fathima sajana
     * Date :2023.03.08
     * Version: 01
     * Logic : daily payment receipt with payment types(cash , cheque, bank, card, return, over)
     * @param  mixed $request
     * @return void
     *
     */

    // $sql= 'SELECT payment_receipts.code, payment_receipts.total_amount,
    //   payment_receipts.settled_amount,mode_of_payments.amount AS 'SUM' ,
    //    mode_of_payments.payment_type_code FROM payment_receipts
    //    INNER JOIN mode_of_payments ON payment_receipts.code = mode_of_payments.payment_receipt_code
    //    WHERE payment_receipts.code = 222011000095
    //     GROUP BY mode_of_payments.payment_type_code
    //     ORDER BY payment_receipts.Id DESC';
    public function dailyPaymentReceiptLocationBasedByPaymentType(Request $request)
    {

    try {

        $repCode = $request->salesRepCode;
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;

        $ReceiptDetails = PaymentReceipt::select(
            'code',
            'total_amount',
            'settled_amount',
            'customer_code',
            'stock_location_code',
        )

            ->with([
                'modeOfPayments' => function ($query) {
                    $query->select( 'payment_receipt_code',
                    DB::raw('SUM(amount) AS amount'),
                     'payment_type_code')
                     ->where('status', '<>', 5)
                     ->groupBy('payment_type_code')
                     ->groupBy('payment_receipt_code')
                    ->where('is_active', '=', 1);
                }
            ])
            ->with([
                'customer' => function ($query) {
                    $query->select('code', 'first_name')
                    ->where('is_active', '=', 1);
                }
            ])

            // ->whereBetween('payment_date_time', [date('Y-m-d H:m:s', strtotime($request->fromDate)-1), date('Y-m-d H:m:s', strtotime($request->toDate))], )
            ->where('stock_location_code', '=', getCurrentLocationCode($request))
            ->where('status', '<>', 5)
            ->where('is_active', '=', 1)

            ->when($fromDate && $toDate, function ($query) use ($fromDate, $toDate) {
                $query->whereBetween('payment_date_time', [$fromDate, $toDate]);
            })
            ->when($repCode, function ($query) use ($repCode) {
                $query->whereHas('customer.route', function ($query) use ($repCode) {
                    $query->where('rep_code', '=', $repCode);
                });
            })
            ->get();

            return response()->json(['status' => 200,
            'invoiceReceiptDetails' => $ReceiptDetails
            ],
            200);

        } catch (\Exception $e) {
        throw new Exception($e);
        }
    }


  /**
     * Author: Suhail Jamaldeen
     * Date: 24.10.2023
     * Version: 01
     * Logic:
     * Summary of dailyPaymentReceiptLocationBasedByPaymentType
     * @param \Illuminate\Http\Request $request
     * @throws \Exception
     * @return \Illuminate\Http\JsonResponse|mixed
     */
    public function DailySalesWithPayment(Request $request)
    {

         try {

            $sql = 'select code, total_amount, settled_amount,
        customer_code, stock_location_code FROM payment_receipts';
            $ReceiptDetails = PaymentReceipt::select(
                'code',
                'total_amount',
                'settled_amount',
                'customer_code',
                'stock_location_code',
                //'is_sales_page'
            )->with([
                        'modeOfPayments' => function ($query) {
                            $query->select(
                                'payment_receipt_code',
                                DB::raw('SUM(amount) AS amount'),
                                'payment_type_code'
                            )
                                ->where('status', '<>', 5)
                                ->groupBy('payment_type_code')
                                ->groupBy('payment_receipt_code')
                                ->where('is_active', '=', 1);
                        }
                    ])
                ->with([
                    'invoices' => function ($query) {
                        $query->select('invoices.code', 'invoices.discount_total')
                            ->where('invoices.is_active', '=', 1);
                        //->first();
                    }
                ])
                ->with([
                    'customer' => function ($query) {
                        $query->select('code', 'first_name')
                            ->where('is_active', '=', 1);
                    }
                ])
                ->whereBetween('created_at', [date('Y-m-d H:m:s', strtotime($request->fromDate) - 1), date('Y-m-d H:m:s', strtotime($request->toDate))], )
                ->where('stock_location_code', '=', getCurrentLocationCode($request))
                ->where('status', '<>', 5)
                ->where('is_active', '=', 1)
                //->where('is_sales_page', '=', 1)
                ->get();

            $creditInvoice = Invoice::select()
                ->with([
                    'customer' => function ($query) {
                        $query->select('code', 'first_name')
                            ->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'paymentReceipts' => function ($query) {
                        $query->select('code', 'first_name')
                            ->where('is_active', '=', 1);
                    }
                ])->with([
                        'paymentReceipts.modeOfPayments' => function ($query) {
                            $query->select(
                                'payment_receipt_code',
                                DB::raw('SUM(amount) AS amount'),
                                'payment_type_code'
                            )
                                ->where('status', '<>', 5)
                                ->groupBy('payment_type_code')
                                ->groupBy('payment_receipt_code')
                                ->where('is_active', '=', 1);
                        }
                    ])
                ->whereBetween('created_at', [date('Y-m-d H:m:s', strtotime($request->fromDate) - 1), date('Y-m-d H:m:s', strtotime($request->toDate))], )
                ->where('stock_location_code', '=', getCurrentLocationCode($request))
                ->where('is_active', '=', 1)
                ->get();

            return response()->json(
                [
                    'status' => 200,
                    'invoiceReceiptDetails' => $ReceiptDetails,
                    'invoice' => $creditInvoice
                ],
                200
            );

        }
        catch (\Exception $e) {
            throw new Exception($e);
        }
    }

}
