<?php

namespace App\Http\Controllers\Report_Location_Based_Controller;

use App\Enums\MultiPurposeStatus;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Exception;
use App\Models\Expense_Models\Expense;
use Illuminate\Support\Facades\DB;

class ExpenseLocationReportController extends Controller
{
    /**
     * dailyExpensesLocationBased
     * logic: dialy and periodic expenses location wise
     * version :01
     * date: 2023.03.07
     * author: fathima sajana
     * @param  mixed $request
     * @return void
     */
    public function dailyExpensesLocationBased(Request $request)
    {
        try {
            $categoryCode = $request->categoryCode;
            $typeCode = $request->typeCode;

            if($categoryCode &&  $typeCode)
                {
                    $expenses  = Expense::select('code', 'expense_type_code', 'expense_category_code', 'total_amount', 'description')
                    ->with([
                        'expenseCategory' => function ($query) use ($categoryCode) {
                            $query->where('code', '=', $categoryCode)
                                ->where('is_active', '=', 1);
                        }
                    ])
                    ->with([
                        'expenseType' => function ($query) use ($typeCode) {
                            $query->where('code', '=', $typeCode)
                            ->where('is_active', '=', 1);
                        }
                    ])
                    // ->with([
                    //     'expenseBankPayments' => function ($query) {
                    //         $query->select('code', 'amount')
                    //         ->where('is_active', '=', 1);
                    //     }
                    // ])
                    // ->with([
                    //     'expenseCardPayments' => function ($query) {
                    //         $query->select('code', 'amount')
                    //         ->where('is_active', '=', 1);
                    //     }
                    // ])
                    // ->with([
                    //     'expenseCashPayments' => function ($query) {
                    //         $query->select('code', 'amount')
                    //         ->where('is_active', '=', 1);
                    //     }
                    // ])
                    // ->with([
                    //     'expenseChequePayments' => function ($query) {
                    //         $query->select('code', 'amount')
                    //         ->where('is_active', '=', 1);
                    //     }
                    // ])
                    // ->with([
                    //     'expenseOnlinePayments' => function ($query) {
                    //         $query->select('code', 'amount')
                    //         ->where('is_active', '=', 1);
                    //     }
                    // ])
                    // ->with([
                    //     'expenseModeOfPayments' => function ($query) {
                    //         $query->where('is_active', '=', 1);
                    //     }
                    // ])
                    ->where('expenses.is_active', '=', 1)
                    ->where('status', '<>', MultiPurposeStatus::REVERSED)
                    ->where('expense_category_code', '=', $categoryCode)
                    ->where('expense_type_code', '=', $typeCode)
                    ->whereBetween('date_time', [date('Y-m-d H:m:s', strtotime($request->fromDate)-1), date('Y-m-d H:m:s', strtotime($request->toDate))])
                    ->where('stock_location_code', '=', getCurrentLocationCode($request))
                    ->get();
                            return response()->json(['status' => 200, 'Expenses' =>  $expenses]);
                    }
                    else if($categoryCode &&  !$typeCode){
                        $expenses  = Expense::select('code', 'expense_type_code', 'expense_category_code', 'total_amount', 'description')
                    ->with([
                        'expenseCategory' => function ($query) use ($categoryCode) {
                            $query->where('code', '=', $categoryCode)
                                ->where('is_active', '=', 1);
                        }
                    ])
                    ->with([
                        'expenseType' => function ($query) use ($typeCode) {
                            $query->where('code', '=', $typeCode)
                            ->where('is_active', '=', 1);
                        }
                    ])
                    // ->with([
                    //     'expenseBankPayments' => function ($query) {
                    //         $query->select('code', 'amount')
                    //         ->where('is_active', '=', 1);
                    //     }
                    // ])
                    // ->with([
                    //     'expenseCardPayments' => function ($query) {
                    //         $query->select('code', 'amount')
                    //         ->where('is_active', '=', 1);
                    //     }
                    // ])
                    // ->with([
                    //     'expenseCashPayments' => function ($query) {
                    //         $query->select('code', 'amount')
                    //         ->where('is_active', '=', 1);
                    //     }
                    // ])
                    // ->with([
                    //     'expenseChequePayments' => function ($query) {
                    //         $query->select('code', 'amount')
                    //         ->where('is_active', '=', 1);
                    //     }
                    // ])
                    // ->with([
                    //     'expenseOnlinePayments' => function ($query) {
                    //         $query->select('code', 'amount')
                    //         ->where('is_active', '=', 1);
                    //     }
                    // ])
                    // ->with([
                    //     'expenseModeOfPayments' => function ($query) {
                    //         $query->where('is_active', '=', 1);
                    //     }
                    // ])
                    ->where('expenses.is_active', '=', 1)
                    ->where('status', '<>', MultiPurposeStatus::REVERSED)
                    ->where('expense_category_code', '=', $categoryCode)
                    ->whereBetween('date_time', [date('Y-m-d H:m:s', strtotime($request->fromDate)-1), date('Y-m-d H:m:s', strtotime($request->toDate))])
                    ->where('stock_location_code', '=', getCurrentLocationCode($request))
                    ->get();
                            return response()->json(['status' => 200, 'Expenses' =>  $expenses]);
                    }

            else
            {
                $expenses  = Expense::select('code', 'expense_type_code', 'expense_category_code', 'total_amount', 'description')
                ->with([
                    'expenseCategory' => function ($query)  {
                        $query ->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'expenseType' => function ($query)  {
                        $query ->where('is_active', '=', 1);
                    }
                ])->with([
                    'expenseModeOfPayments' => function ($query)  {
                        $query ->where('is_active', '=', 1);
                    }
                ])


                // ->with([
                //     'expenseBankPayments' => function ($query) {
                //         $query->select('code', 'amount')
                //         ->where('is_active', '=', 1);
                //     }
                // ])
                // ->with([
                //     'expenseCardPayments' => function ($query) {
                //         $query->select('code', 'amount')
                //         ->where('is_active', '=', 1);
                //     }
                // ])
                // ->with([
                //     'expenseCashPayments' => function ($query) {
                //         $query->select('code', 'amount')
                //         ->where('is_active', '=', 1);
                //     }
                // ])
                // ->with([
                //     'expenseChequePayments' => function ($query) {
                //         $query->select('code', 'amount')
                //         ->where('is_active', '=', 1);
                //     }
                // ])
                // ->with([
                //     'expenseOnlinePayments' => function ($query) {
                //         $query->select('code', 'amount')
                //         ->where('is_active', '=', 1);
                //     }
                // ])
                // ->with([
                //     'expenseModeOfPayments' => function ($query) {
                //         $query->where('is_active', '=', 1);
                //     }
                // ])
                ->where('expenses.is_active', '=', 1)
                ->where('status', '<>', MultiPurposeStatus::REVERSED)
                ->whereBetween('date_time', [date('Y-m-d H:m:s', strtotime($request->fromDate)-1), date('Y-m-d H:m:s', strtotime($request->toDate))])
                ->where('stock_location_code', '=', getCurrentLocationCode($request))
                ->get();
                        return response()->json(['status' => 200,
                                                 'Expenses' =>  $expenses
                                                                                                ]);
            }

        }

     catch (\Exception $e) {
         throw new Exception($e);
     }
    }


        /**
     * monthlyExpenses
     * auhtor: fathima Sajana
     * version: 01
     * Date :2023.04.02
     * logic: monthly baserd expenses (Ex: petty cash, wages, salry......)
     * @param  mixed $request
     * @return void
     */
    public function monthlyExpensesLocationBased(Request $request)
    {
        $month = $request->month;
        $year = $request->year;
        $stockLocationCode = getCurrentLocationCode($request);

        try {
            $sql ="SELECT STR_TO_DATE(date_time, '%Y-%m-%d')  AS Date , SUM(total_amount)AS expenses_total
            FROM expenses WHERE MONTH(date_time)=$month AND YEAR(date_time)=$year AND stock_location_code = $stockLocationCode

            GROUP BY STR_TO_DATE(date_time, '%Y-%m-%d')
            ORDER BY STR_TO_DATE(date_time, '%Y-%m-%d')";

            $results = DB::select($sql);
            return response()->json(['status' => 200, 'monthlyExpenses' => $results], 200);
         }
         catch (\Exception $e) {
             throw new Exception($e);
         }

    }
}
