<?php

namespace App\Http\Controllers\Report_Controllers;

use App\Http\Controllers\Controller;
use App\Models\PaymentVoucher_Models\SupplierBankPayment;
use App\Models\PaymentVoucher_Models\SupplierCardPayment;
use App\Models\PaymentVoucher_Models\SupplierCashPayment;
use App\Models\PaymentVoucher_Models\SupplierChequePayment;
use App\Models\PaymentVoucher_Models\SupplierReturnAmount;
use App\Models\Stock_Models\Grn;
use App\Models\Supplier_Models\PurchaseReturn;
use App\Models\Supplier_Models\Supplier;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Exception;

class SupplierReportController extends Controller
{


    public function supplierList(Request $request)
    {

        try {
            $code = $request->code;

            if($code){
                $sql = 'SELECT suppliers.code, suppliers.name, suppliers.contact_name, suppliers.phone_1, suppliers.phone_2, suppliers.address_1
                FROM suppliers
                WHERE  suppliers.code = ' . $code ;
    
                $results = DB::select($sql);
            }else {
                 $sql = 'SELECT suppliers.code, suppliers.name, suppliers.contact_name, suppliers.phone_1, suppliers.phone_2, suppliers.address_1
                FROM suppliers
                WHERE  is_active = ' . 1 ;
    
                $results = DB::select($sql);
            }
            
            return response()->json(['status' => 200, 'supplierlist' => $results],
             200);
            } catch (\Exception $e) {
                throw new Exception($e);
            }
    }
  
    //    try {
        
//               supplier = "SELECT grns.supplier_code, suppliers.name, phone_1, phone_2, address_1, sum(grns.total_amount) as grn_total
    //           FROM titum_bizx_pos.grns
    //           WHERE grms.supplier_code = $request->code
    //           inner join suppliers on suppliers.code = grns.supplier_code
    //           group by grns.supplier_code order by grns.supplier_code";
    //           $supplierList = DB::select($supplier);
        
    //        return response()->Json(['status' => 200, 'supplierList' => $supplierList]);

    //     } catch (\Exception $e) {
    //         return response()->json([
    //             'status' => 500,
    //             'message' => $e
    //         ], 500);
    //     }
   

    public function debitStatement(Request $request)
    {

        try {
            $code = $request->code;
        if($code)
            {
                $sql = 'SELECT suppliers.code, suppliers.name, suppliers.contact_name,  suppliers.debit_amount, suppliers.received_amount, suppliers.over_payment,
                (SELECT sum(grns.total_amount) FROM grns WHERE grns.supplier_code = suppliers.code ) AS grn_total,
                (SELECT sum(purchase_returns.total_amount) FROM purchase_returns WHERE purchase_returns.supplier_code = suppliers.code) AS return_amount,
                (SELECT sum(payment_vouchers.total_amount) FROM payment_vouchers WHERE payment_vouchers.supplier_code = suppliers.code) AS payment_amount 
                FROM suppliers
                WHERE  suppliers.code = ' . $code ;

            $results = DB::select($sql);
            }
        else
            {
                $sql = 'SELECT suppliers.code, suppliers.name, suppliers.contact_name,  suppliers.debit_amount, suppliers.received_amount, suppliers.over_payment,
                    (SELECT sum(grns.total_amount) FROM grns WHERE grns.supplier_code = suppliers.code ) AS grn_total,
                    (SELECT sum(purchase_returns.total_amount) FROM purchase_returns WHERE purchase_returns.supplier_code = suppliers.code) AS return_amount,
                    (SELECT sum(payment_vouchers.total_amount) FROM payment_vouchers WHERE payment_vouchers.supplier_code = suppliers.code) AS payment_amount 
                    FROM suppliers';

                $results = DB::select($sql);
            }
        

            return response()->json(['status' => 200, 'debitStatement' => $results],
             200);
            } catch (\Exception $e) {
                throw new Exception($e);
            }
    }

    public function getSupplierDebit(Request $request)
    {
        try {
        $sql = "SELECT grns.supplier_code, grns.paid_amount ,grns.total_amount,
        (SELECT IFNULL(sum(grn_payment_vouchers.paid_amount),0) FROM grn_payment_vouchers WHERE grn_payment_vouchers.grn_code = grns.code) AS grn_payment_vouchers_amount,
        grn_total - (SELECT IFNULL(sum(grn_payment_vouchers.paid_amount),0) FROM grn_payment_vouchers WHERE grn_payment_vouchers.grn_code = grns.code)  AS supplier_debit
        FROM grns 
        WHERE grns.supplier_code = $request -> code  AND grns.total_amount - (SELECT IFNULL(sum(grn_payment_vouchers.paid_amount),0) FROM grn_payment_vouchers WHERE grn_payment_vouchers.grn_code = grns.code) >0)  ";
    
        $results = DB::select($sql);

            return response()->json(['status' => 200, 'supplier' => $results], 200);
        } catch (\Exception $e) {
            return response()->json(['status' => 500, 'message' => $e], 500);
        }
        
    }
       
    /**
     * supplierSummary
     * Author: fathima sajana
     * version: 01
     * date:2023.11.08
     * logic : suplier summary for periodic date
     * @param  mixed $request
     * @return void
     */
    public function supplierSummary(Request $request)
    {
        try {

            $code = $request->code;
            $fromDate = $request->fromDate;
            $toDate = $request->toDate;

            $supplier = Supplier::select('code', 'debit_amount', 'return_amount', 'over_payment', 'cheque_return_amount')
            ->where('suppliers.code', '=', $code)
            //->whereBetween('suppliers.created_at', [date('Y-m-d H:i:s', strtotime($fromDate)), date('Y-m-d H:i:s', strtotime($toDate))])
            ->get();

            $sql = 'SELECT code, created_at, supplier_code, grns.total_amount AS amount, remarks, "GRN" AS source FROM grns
            WHERE ( supplier_code = ' . $code . ' AND( created_at BETWEEN "' . $fromDate . '" AND "' . $toDate . '" ))
            UNION SELECT  purchase_returns.code, created_at, purchase_returns.supplier_code, purchase_returns.total_amount AS amount, remarks, "RTN" AS source FROM  purchase_returns
            WHERE  (  supplier_code = ' . $code . ' AND purchase_returns.status <> 5 AND( created_at BETWEEN "' . $fromDate . '" AND "' . $toDate . '" ) )
            UNION SELECT payment_vouchers.code , created_at, payment_vouchers.supplier_code, payment_vouchers.settled_amount, remarks, "PMT" AS source  FROM payment_vouchers
            WHERE  ( supplier_code = ' . $code . ' AND payment_vouchers.status <> 5 AND( created_at BETWEEN "' . $fromDate . '" AND "' . $toDate . '"))
            ORDER BY created_at ASC';

            $cash = SupplierCashPayment::select('amount AS cash_total', 'supplier_code')
            ->where('supplier_code', '=', $code)
            ->where('status', '<>', 5)
            ->whereBetween('supplier_cash_payments.created_at', [date('Y-m-d H:i:s', strtotime($fromDate)), date('Y-m-d H:i:s', strtotime($toDate))])
            ->get();

            $cheque = SupplierChequePayment::select('amount AS cheque_total', 'supplier_code')
            ->where('supplier_code', '=', $code)
            ->where('status', '<>', 5)
            ->whereBetween('supplier_cheque_payments.created_at', [date('Y-m-d H:i:s', strtotime($fromDate)), date('Y-m-d H:i:s', strtotime($toDate))])
            ->get();

            $bank = SupplierBankPayment::select('amount AS bank_total', 'supplier_code')
            ->where('supplier_code', '=', $code)
            ->where('status', '<>', 5)
            ->whereBetween('supplier_bank_payments.created_at', [date('Y-m-d H:i:s', strtotime($fromDate)-1), date('Y-m-d H:i:s', strtotime($toDate))])
            ->get();

            $card = SupplierCardPayment::select('amount AS card_total', 'supplier_code')
            ->where('supplier_code', '=', $code)
            ->where('status', '<>', 5)
            ->whereBetween('supplier_card_payments.created_at', [date('Y-m-d H:i:s', strtotime($fromDate)-1), date('Y-m-d H:i:s', strtotime($toDate))])
            ->get();

            $return = SupplierReturnAmount::select('amount AS return_total', 'supplier_code')
            ->where('supplier_code', '=', $code)
            ->where('status', '<>', 5)
            ->whereBetween('supplier_return_amounts.created_at', [date('Y-m-d H:i:s', strtotime($fromDate)-1), date('Y-m-d H:i:s', strtotime($toDate))])
            ->get();

            $purchaseReturn = PurchaseReturn::select('total_amount AS purchase_return_total', 'supplier_code')
            ->where('supplier_code', '=', $code)
            ->where('status', '<>', 5)
            ->whereBetween('purchase_returns.created_at', [date('Y-m-d H:i:s', strtotime($fromDate)-1), date('Y-m-d H:i:s', strtotime($toDate))])
            ->get();

            $results = DB::select($sql);

            return response()->json([
                'status' => 200,
                'supplier' => $supplier,
                'supplierSummary' => $results,
                'cash_payment' => $cash,
                'cheque_payment' => $cheque,
                'card_payment' => $card,
                'bank_payment' => $bank,
                'return_amount' => $return,
                'purchase_return_amount' => $purchaseReturn,
        

            ], 200);

        } catch (\Exception $e) {

            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
       }
    }

    public function supplierSummary1(Request $request)
    {
        try {

            $code = $request->code;
            $fromDate = $request->fromDate;
            $toDate = $request->toDate;

            $previousDataGrn = "SELECT SUM(total_amount)AS grnTotal
            FROM grns
            WHERE STR_TO_DATE(grns.invoice_date, '%Y-%m-%d') > '. $fromDate . ' 
            AND grns.supplier_code = '.$code.'
            AND  grns.status <> '5'";

            $previousDataPayment = "SELECT SUM(total_amount)AS paymentTotal 
            FROM payment_vouchers
            WHERE STR_TO_DATE(payment_vouchers.payment_date_time, '%Y-%m-%d') > '. $fromDate . ' 
            AND payment_vouchers.supplier_code = '.$code.'
            AND  payment_vouchers.status <> '5'";

            $previousDataReturn = "SELECT SUM(total_amount)AS returnTotal
            FROM purchase_returns
            WHERE STR_TO_DATE(purchase_returns.return_date_time, '%Y-%m-%d') > '. $fromDate . ' AND purchase_returns.supplier_code = '.$code.'";

            $sql = 'SELECT code, created_at, supplier_code, grns.total_amount AS amount, "GRN" AS SOURCE FROM grns
            WHERE ( supplier_code = ' . $code . ' AND( invoice_date BETWEEN "' . $fromDate . '" AND "' . $toDate . '" ))
            UNION SELECT   purchase_returns.code, created_at, purchase_returns.supplier_code, purchase_returns.total_amount AS amount, "RTN" AS SOURCE FROM  purchase_returns
            WHERE  (  supplier_code = ' . $code . ' AND( return_date_time BETWEEN "' . $fromDate . '" AND "' . $toDate . '" ) )
            UNION SELECT payment_vouchers.code , created_at, payment_vouchers.supplier_code, payment_vouchers.total_amount, "PMT" AS SOURCE  FROM payment_vouchers
            WHERE  ( supplier_code = ' . $code . ' AND payment_vouchers.status <> 5 AND( payment_date_time BETWEEN "' . $fromDate . '" AND "' . $toDate . '"))
            ORDER BY created_at ASC';

            $cash_payment = 'SELECT IFNULL(sum(supplier_cash_payments.amount),0)AS cash_total, payment_vouchers.supplier_code FROM payment_vouchers 
            JOIN supplier_cash_payments on supplier_cash_payments.voucher_code = payment_vouchers.code
            WHERE  ( supplier_code = ' . $code . ' AND supplier_cash_payments.status <> 5  AND ( STR_TO_DATE(supplier_cash_payments.date_time, "%Y-%m-%d")  BETWEEN "'. $fromDate . '" AND "' . $toDate . '"))';
        
            $cheque_payment = 'SELECT IFNULL(sum(supplier_cheque_payments.amount),0)AS cheque_total, payment_vouchers.supplier_code FROM payment_vouchers 
            JOIN supplier_cheque_payments on supplier_cheque_payments.voucher_code = payment_vouchers.code
            WHERE  ( supplier_code = ' . $code . ' AND supplier_cheque_payments.status <> 5  AND ( STR_TO_DATE(supplier_cheque_payments.date_time, "%Y-%m-%d")  BETWEEN "'. $fromDate . '" AND "' . $toDate . '"))';
        
            $card_payment = 'SELECT IFNULL(sum(supplier_card_payments.amount),0)AS card_total, payment_vouchers.supplier_code FROM payment_vouchers 
            JOIN supplier_card_payments on supplier_card_payments.voucher_code = payment_vouchers.code
            WHERE  ( supplier_code = ' . $code . ' AND supplier_card_payments.status <> 5  AND ( STR_TO_DATE(supplier_card_payments.date_time, "%Y-%m-%d")  BETWEEN "'. $fromDate . '" AND "' . $toDate . '"))';
        
            $bank_payment = 'SELECT IFNULL(sum(supplier_bank_payments.amount),0)AS bank_total, payment_vouchers.supplier_code FROM payment_vouchers 
            JOIN supplier_bank_payments on supplier_bank_payments.voucher_code = payment_vouchers.code
            WHERE  ( supplier_code = ' . $code . ' AND supplier_bank_payments.status <> 5  AND ( STR_TO_DATE(supplier_bank_payments.date_time, "%Y-%m-%d")  BETWEEN "'. $fromDate . '" AND "' . $toDate . '"))';
            
            $return_amount = 'SELECT IFNULL(sum(supplier_return_amounts.amount),0)AS return_total, payment_vouchers.supplier_code FROM payment_vouchers 
            JOIN supplier_return_amounts on supplier_return_amounts.voucher_code = payment_vouchers.code
            WHERE  ( supplier_code = ' . $code . ' AND supplier_return_amounts.status <> 5  AND ( STR_TO_DATE(supplier_return_amounts.date_time, "%Y-%m-%d")  BETWEEN "'. $fromDate . '" AND "' . $toDate . '"))';
        

            $results = DB::select($sql);
             $cash_payment = DB::select($cash_payment);           
             $cheque_payment = DB::select($cheque_payment);           
             $card_payment = DB::select($card_payment);           
             $bank_payment = DB::select($bank_payment);           
             $return_amount = DB::select($return_amount);           
             $previousDataGrn = DB::select($previousDataGrn);
             $previousDataPay = DB::select($previousDataPayment);
             $previousDataRet = DB::select($previousDataReturn);

            return response()->json([
                'status' => 200,
                 'supplierSummary' => $results,
                 'GrnTotal' => $previousDataGrn,
                 'previousDataPay' => $previousDataPay,
                 'previousDataRet' => $previousDataRet,
                 'cash_payment' => $cash_payment,
                 'cheque_payment'=>$cheque_payment,
                 'card_payment'=>$card_payment,
                 'bank_payment'=>$bank_payment,
                 'return_amount'=>$return_amount

            ], 200);

        } catch (\Exception $e) {

            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }
}
