<?php

namespace App\Http\Controllers\Report_Controllers;

use App\Http\Controllers\Controller;
use App\Models\AccountTransaction_Models\AccTransaction;
use App\Models\Expense_Models\Expense;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Invoice_Models\Invoice;

class SummaryReportController extends Controller
{
    public function dailySummary(Request $request)
    {
        $date = $request->date;
        try {

       $daily_summary =  'SELECT  invoices.code, created_at, total_amount AS amount, "INVOICE" AS source FROM invoices WHERE ( STR_TO_DATE(created_at, "%Y-%m-%d")  = '.$date.')
       union SELECT sales_returns.code, created_at,  sales_returns.total_amount AS amount, "SALES_RETURN" AS source FROM sales_returns WHERE  (  STR_TO_DATE(created_at, "%Y-%m-%d")  =  '.$date.' )
       union SELECT payment_receipts.code , created_at, total_amount AS amount, "PAYMENT" AS source FROM payment_receipts WHERE  (  STR_TO_DATE(created_at, "%Y-%m-%d")  = '.$date.')
       union SELECT grns.code, created_at, total_amount AS amount, "GRN" AS source FROM grns WHERE  (  STR_TO_DATE(created_at, "%Y-%m-%d")  = '.$date.')
       union SELECT expenses.code, created_at, total_amount AS amount , "EXPENSE" AS source FROM expenses WHERE  (  STR_TO_DATE(created_at, "%Y-%m-%d")  = '.$date.')
       ORDER BY STR_TO_DATE(created_at, "%Y-%m-%d")  ASC';

       $dailySummary = DB::select($daily_summary);

           return response()->json(['status' => 200, 'dailySummary' => $dailySummary], 200);
        } catch (\Exception $e)
        {
          return response()->json(['status' => 500, 'message' => $e],500);
        }
    }



    public function monthlySummary(Request $request)
    {
        $month = $request->month;
        $year = $request->year;
        $locationCode = getCurrentLocationCode($request);

        try {
        // $invoice_Total =  "SELECT STR_TO_DATE(invoices.date_time, '%Y-%m-%d')  AS InvoiceDate , SUM(invoices.total_amount)AS invoice_total,
        // (select sum(invoice_payments.paid_amount) from invoice_payments where(invoice_payments.invoice_code = invoices.code)) AS bill_total
        // FROM invoices WHERE MONTH(invoices.date_time)=$month AND YEAR(invoices.date_time)=$year
        // GROUP BY STR_TO_DATE(invoices.date_time, '%Y-%m-%d')
        // ORDER BY STR_TO_DATE(invoices.date_time, '%Y-%m-%d')";
        $invoice_Total = "SELECT IFNULL(sum(total_amount),0)AS invoice_total,stock_location_code
        FROM invoices WHERE MONTH(invoices.date_time)=$month AND YEAR(invoices.date_time)=$year AND stock_location_code = '". $locationCode . "'";

        $return_Total = "SELECT IFNULL(sum(total_amount),0)AS return_total,stock_location_code
        FROM sales_returns WHERE MONTH(return_date_time)=$month AND YEAR(return_date_time)=$year AND stock_location_code = '". $locationCode . "'";

        $purchase_return_Total = "SELECT IFNULL(sum(total_amount),0)AS return_total,stock_location_code
        FROM purchase_returns WHERE MONTH(return_date_time)=$month AND YEAR(return_date_time)=$year AND stock_location_code = '". $locationCode . "'";

        $grn_Total = "SELECT IFNULL(sum(total_amount),0)AS Grn_Total,stock_location_code
        FROM grns WHERE MONTH(grn_date)=$month AND YEAR(grn_date)=$year AND stock_location_code = '". $locationCode . "'";

        $expenses_Total = "SELECT IFNULL(sum(total_amount),0)AS expenses_total,stock_location_code
        FROM expenses WHERE MONTH(created_at)=$month AND YEAR(created_at)=$year AND stock_location_code = '". $locationCode . "'";

        $payment_total = "SELECT IFNULL(sum(total_amount),0)AS payment_total,stock_location_code
        FROM payment_receipts WHERE MONTH(created_at)=$month AND YEAR(created_at)=$year AND stock_location_code = '". $locationCode . "'";

        $voucher_payment_total = "SELECT IFNULL(sum(total_amount),0)AS payment_total,stock_location_code
        FROM payment_vouchers WHERE MONTH(created_at)=$month AND YEAR(created_at)=$year AND stock_location_code = '". $locationCode . "'";


        $invoice = DB::select($invoice_Total);
        $return = DB::select($return_Total);
        $purchaseReturn = DB::select($purchase_return_Total);
        $grn = DB::select($grn_Total);
        $expenses = DB::select($expenses_Total);
        $payment = DB::select($payment_total);
        $voucherPayment = DB::select($voucher_payment_total);

            return response()->json(['status' => 200,
            'invoice'=>$invoice,
            'return'=>$return,
            'purchaseReturn'=>$purchaseReturn,
            'grn'=>$grn,
            'expenses'=>$expenses,
            'payment'=>$payment,
            'voucherPayment'=>$voucherPayment
        ], 200);

        } catch (\Exception $e)
        {
           return response()->json(['status' => 500, 'message' => $e],500);
        }
    }

    public function periodicSummary(Request $request)
    {
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;
        $locationCode = getCurrentLocationCode($request);
        try {

            $periodic_summary =  'SELECT  invoices.code,stock_location_code, date_time, created_at, total_amount AS amount, "INVOICE" AS source FROM invoices WHERE ( STR_TO_DATE(date_time, "%Y-%m-%d")  BETWEEN "'. $fromDate . '" AND "' . $toDate . '") AND stock_location_code = "'. $locationCode . '"
            union SELECT sales_returns.code,stock_location_code, return_date_time, created_at, sales_returns.total_amount AS amount, "SALES_RETURN" AS source FROM sales_returns WHERE (  STR_TO_DATE(return_date_time, "%Y-%m-%d")  BETWEEN "'. $fromDate . '" AND "' . $toDate . '" ) AND stock_location_code = "'. $locationCode . '"
            union SELECT purchase_returns.code,stock_location_code, return_date_time, created_at, purchase_returns.total_amount AS amount, "PURCHASE_RETURN" AS source FROM purchase_returns WHERE (  STR_TO_DATE(return_date_time, "%Y-%m-%d")  BETWEEN "'. $fromDate . '" AND "' . $toDate . '" ) AND stock_location_code = "'. $locationCode . '"
            union SELECT payment_vouchers.code,stock_location_code, payment_date_time, created_at, payment_vouchers.total_amount AS amount, "VOUCHER_PAYMENT" AS source FROM payment_vouchers WHERE (  STR_TO_DATE(payment_date_time, "%Y-%m-%d")  BETWEEN "'. $fromDate . '" AND "' . $toDate . '" ) AND stock_location_code = "'. $locationCode . '"
            union SELECT payment_receipts.code,stock_location_code, payment_date_time, created_at, total_amount AS amount, "RECEIPT_PAYMENT" AS source FROM payment_receipts WHERE  (  STR_TO_DATE(payment_date_time, "%Y-%m-%d")  BETWEEN "'. $fromDate . '" AND "' . $toDate . '") AND stock_location_code = "'. $locationCode . '"
            union SELECT grns.code,stock_location_code, invoice_date, created_at, total_amount AS amount, "GRN" AS source FROM grns WHERE  (  STR_TO_DATE(invoice_date, "%Y-%m-%d")  BETWEEN "'. $fromDate . '" AND "' . $toDate . '") AND stock_location_code = "'. $locationCode . '"
            union SELECT expenses.code,stock_location_code, date_time, created_at, total_amount AS amount, "EXPENSE" AS source FROM expenses WHERE  (  STR_TO_DATE(date_time, "%Y-%m-%d") BETWEEN "'. $fromDate . '" AND "' . $toDate . '") AND stock_location_code = "'. $locationCode . '"
            ORDER BY STR_TO_DATE(created_at, "%Y-%m-%d")  ASC';

        $periodicSummary = DB::select($periodic_summary);

            return response()->json(['status' => 200, 'periodicSummary' => $periodicSummary], 200);
        } catch (\Exception $e)
        {
           return response()->json(['status' => 500, 'message' => $e],500);
        }
    }

    public function dayEndSummary(Request $request)
    {
        $date =$request->date;
        try
        {
            // $invoices = Invoice::select('total_amount')
            // -> WHERE Date(date) = Date("'.$date.'")-> get;
            $invoices = 'SELECT IFNULL(sum(total_amount),0) AS invoice_total From invoices WHERE Date(date_time)= Date("'.$date.'")';
            $grns = 'SELECT IFNULL(sum(total_amount),0) AS grn_total FROM grns  WHERE Date(grn_date)= Date("'.$date.'")';
            $sales_returns = 'SELECT IFNULL(sum(total_amount),0) AS return_total From sales_returns  WHERE Date(return_date_time)= Date("'.$date.'")';
            $purchase_returns = 'SELECT IFNULL(sum(total_amount),0) AS return_total From purchase_returns  WHERE Date(return_date_time)= Date("'.$date.'")';
            $payment_receipts = 'SELECT IFNULL(sum(total_amount),0)AS payment_total FROM payment_receipts WHERE Date(payment_date_time)= Date("'.$date.'")';
            $payment_vouchers = 'SELECT IFNULL(sum(total_amount),0)AS payment_total FROM payment_vouchers WHERE Date(payment_date_time)= Date("'.$date.'")';
            $expenses = 'SELECT IFNULL(sum(total_amount),0)AS expense_amount FROM expenses WHERE Date(date_time)= Date("'.$date.'")';
            $stocks = 'SELECT IFNULL(sum(remaining_quantity * retail_price),0)AS stock_total  FROM stocks WHERE Date(created_at)= Date("'.$date.'")';


            $invoice_total = DB::select($invoices);
            $grn_total = DB::select($grns);
            $return_total = DB::select($sales_returns);
            $purchase_return_total = DB::select($purchase_returns);
            $payment_total = DB::select($payment_receipts);
            $voucher_payment_total = DB::select($payment_vouchers);
            $expense_total = DB::select($expenses);
            $stocks_total = DB::select($stocks);


            return response()->json(['status' => 200,
            'invoice_total' => $invoice_total,
            'grn_total'=>$grn_total,
            'return_total'=>$return_total,
            'purchase_return_total'=>$purchase_return_total,
            'payment_total'=>$payment_total,
            'voucher_payment_total'=>$voucher_payment_total,
            'expense_total'=>$expense_total,
            'stocks_total'=>$stocks_total
        ], 200);
        } catch (\Exception $e) {
            return response()->json(['status' => 500, 'message' => $e],500);
        }
    }

    /**
     * dayBookByCashAndChequeSummary
     * author: fathima sajana
     * version : 01
     * logic: day book summary by cash and cheque ( receipt(cash, cheque, card, over, return), expenses, voucher, sales return, purchase return)
     * date: 2023.03.28
     * @param  mixed $request
     * @return void
     */
    public function dayBookByCashAndChequeSummary(Request $request)
    {
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;
        try
        {
        $payment_receipts = 'SELECT IFNULL(sum(total_amount),0)AS payment_receipt_total FROM payment_receipts WHERE ( STR_TO_DATE(created_at, "%Y-%m-%d")  BETWEEN "'. $fromDate . '" AND "' . $toDate . '")';

        $cash_payment = 'SELECT IFNULL(sum(amount),0)AS cash_total FROM cash_payments WHERE ( STR_TO_DATE(created_at, "%Y-%m-%d")  BETWEEN "'. $fromDate . '" AND "' . $toDate . '")';

        $card_payment = 'SELECT IFNULL(sum(amount),0)AS card_total FROM card_payments WHERE ( STR_TO_DATE(created_at, "%Y-%m-%d")  BETWEEN "'. $fromDate . '" AND "' . $toDate . '")';

        $cheque_payment = 'SELECT IFNULL(sum(amount),0)AS cheque_total FROM cheque_payments WHERE ( STR_TO_DATE(created_at, "%Y-%m-%d")  BETWEEN "'. $fromDate . '" AND "' . $toDate . '")';

        $return_amount = 'SELECT IFNULL(sum(amount),0)AS return_amount FROM return_amounts WHERE ( STR_TO_DATE(created_at, "%Y-%m-%d")  BETWEEN "'. $fromDate . '" AND "' . $toDate . '")';

        $over_payment = 'SELECT IFNULL(sum(amount),0)AS over_payment FROM over_payments WHERE ( STR_TO_DATE(created_at, "%Y-%m-%d")  BETWEEN "'. $fromDate . '" AND "' . $toDate . '")';

        $expense_amount = Expense::select('expenses.code',
        'total_amount', 'expense_types.name AS expense_type', 'expense_categories.name AS expense_category')
          ->join('expense_types', 'expense_types.code', '=', 'expenses.expense_type_code')
          ->join('expense_categories', 'expense_categories.code', '=', 'expenses.expense_category_code')
          ->where('expenses.is_active', '=', 1)
          ->whereBetween('expenses.date_time', [date('Y-m-d H:m:s', strtotime($fromDate)-1), date('Y-m-d H:m:s', strtotime($toDate))])
          ->get();

        $account_transaction = AccTransaction::select('acc_transactions.code',
        'amount', 'acc_transaction_types.name AS acc_transaction_type')
          ->where('acc_transactions.is_active', '=', 1)
          ->whereBetween('acc_transactions.date_time', [date('Y-m-d H:m:s', strtotime($fromDate)-1), date('Y-m-d H:m:s', strtotime($toDate))])
          ->get();

        $payment_vouchers = 'SELECT IFNULL(sum(total_amount),0)AS payment_voucher_total FROM payment_vouchers WHERE ( STR_TO_DATE(created_at, "%Y-%m-%d")  BETWEEN "'. $fromDate . '" AND "' . $toDate . '")';

        $supplier_cash_payment = 'SELECT IFNULL(sum(amount),0)AS supplier_cash_total FROM supplier_cash_payments WHERE ( STR_TO_DATE(created_at, "%Y-%m-%d")  BETWEEN "'. $fromDate . '" AND "' . $toDate . '")';

        $supplier_card_payment = 'SELECT IFNULL(sum(amount),0)AS supplier_card_total FROM supplier_card_payments WHERE ( STR_TO_DATE(created_at, "%Y-%m-%d")  BETWEEN "'. $fromDate . '" AND "' . $toDate . '")';

        $supplier_cheque_payment = 'SELECT IFNULL(sum(amount),0)AS supplier_cheque_total FROM supplier_cheque_payments WHERE ( STR_TO_DATE(created_at, "%Y-%m-%d")  BETWEEN "'. $fromDate . '" AND "' . $toDate . '")';

        $purchase_return = 'SELECT IFNULL(sum(total_amount),0)AS purchase_return_total FROM purchase_returns WHERE ( STR_TO_DATE(created_at, "%Y-%m-%d")  BETWEEN "'. $fromDate . '" AND "' . $toDate . '")';

        $sales_return = 'SELECT IFNULL(sum(total_amount),0)AS sales_return_total FROM sales_returns WHERE ( STR_TO_DATE(created_at, "%Y-%m-%d")  BETWEEN "'. $fromDate . '" AND "' . $toDate . '")';

        $payment_receipt_total = DB::select($payment_receipts);
        $cash_payment = DB::select($cash_payment);
        $card_payment = DB::select($card_payment);
        $cheque_payment = DB::select($cheque_payment);
        $return_amount = DB::select($return_amount);
        $over_payment = DB::select($over_payment);

        $payment_voucher_total = DB::select($payment_vouchers);
        $supplier_cash_payment = DB::select($supplier_cash_payment);
        $supplier_card_payment = DB::select($supplier_card_payment);
        $supplier_cheque_payment = DB::select($supplier_cheque_payment);
        $purchase_return = DB::select($purchase_return);
        $sales_return = DB::select($sales_return);

        return response()->json(['status' => 200,
        'payment_receipt_total'=>$payment_receipt_total,
        'cash_payment'=>$cash_payment,
        'card_payment'=>$card_payment,
        'cheque_payment'=>$cheque_payment,
        'return_amount'=>$return_amount,
        'over_payment'=>$over_payment,
        'expense_amount'=>$expense_amount,
        'account_transaction'=>$account_transaction,

        'payment_voucher_total'=>$payment_voucher_total,
        'supplier_cash_payment'=>$supplier_cash_payment,
        'supplier_card_payment'=>$supplier_card_payment,
        'supplier_cheque_payment'=>$supplier_cheque_payment,
        'purchase_return'=>$purchase_return,
        'sales_return'=>$sales_return,

    ], 200);
    } catch (\Exception $e) {
        return response()->json(['status' => 500, 'message' => $e],500);
    }
    }

}
