<?php

namespace App\Http\Controllers\Report_Controllers;

use App\Http\Controllers\Controller;
use App\Models\Invoice_Models\Invoice;
use App\Models\Invoice_Models\SalesReturn;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class SalesReportController extends Controller
{
    public function salesReport(Request $request)
    {
        try {
        $invoice = Invoice::select('code', 'series_code' ,'invoice_number',  'date', 'customer_code', 'discount_percentage', 'bill_discount', 'discount_amount', 'discount_total', 'paid_amount', 'sub_total_amount', 'total_amount', 'paid_status')
            ->with(['customer' => function ($query) {
                $query->select('code', 'first_name', 'second_name', 'phone_1')->where('is_active', '=', 1);
            }
            ])
            ->with(['stockHistories' => function ($query) {
                $query->select('code', 'source_code', 'source',)->where('is_active', '=', 1);
            }
            ])
            // ->with(['vehicleMaster' => function ($query) {
            //     $query->where('is_active', '=', 1);
            // }
            //])
            ->whereBetween('date', [date('Y-m-d H:m:s', strtotime($request->fromDate)-1), date('Y-m-d H:m:s', strtotime($request->toDate))], )
            ->get();

        return response()->json(['status' => 200, 'salesReport' => $invoice], 200);

    }
    catch (\Exception $e) {
        throw new Exception($e);
    }
    }


    public function detailsSalesReport(Request $request)
    {
        try {
            $invoice = Invoice::select('code', 'series_code' ,'invoice_number',  'date', 'customer_code', 'discount_percentage', 'bill_discount', 'discount_amount', 'discount_total', 'paid_amount', 'sub_total_amount', 'total_amount', 'paid_status')
            ->with(['customer' => function ($query) {
                $query->select('code', 'first_name', 'second_name', 'phone_1')
                ->where('is_active', '=', 1);
            }
            ])
            ->with(['stockHistories' => function($query){
                $query->where('is_active', '=', 1);
            }
            ])
            ->with(['stockHistories.itemMaster' => function($query){
                $query->where('is_active', '=', 1);
            }
            ])
           // stockHistory
            ->whereBetween('date', [date('Y-m-d H:m:s', strtotime($request->fromDate)), date('Y-m-d H:m:s', strtotime($request->toDate))])
            ->get();

        return response()->json(['status' => 200, 'salesReport' => $invoice], 200);

    }
    catch (\Exception $e) {
        throw new Exception($e);
    }

    }

    public function monthlySales(Request $request)
    {
        $month = $request->month;
        $year = $request->year;
        try {
            $sql ="SELECT STR_TO_DATE(invoices.date_time, '%Y-%m-%d')  AS Date , SUM(invoices.total_amount)AS invoice_total
            FROM invoices WHERE MONTH(invoices.date_time)=$month AND YEAR(invoices.date_time)=$year
            GROUP BY STR_TO_DATE(invoices.date_time, '%Y-%m-%d')
            ORDER BY STR_TO_DATE(invoices.date_time, '%Y-%m-%d')";

            $results = DB::select($sql);
            return response()->json(['status' => 200, 'monthlySales' => $results], 200);
        }
        catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    public function dailySalesReturn(Request $request)
    {
        try {
        $salesReturnReport = SalesReturn::select('code', 'customer_code',  'invoice_code', 'total_amount' )
            ->with(['customer' => function ($query) {
                $query->select('code', 'first_name')->where('is_active', '=', 1);
            }
            ])

            ->with(['stockHistories.itemMaster' => function($query){
            $query->select('code', 'name')
            ->where('is_active', '=', 1);
            }
            ])

            ->whereBetween('created_at', [date('Y-m-d H:m:s', strtotime($request->fromDate)-1), date('Y-m-d H:m:s', strtotime($request->toDate))], )
            ->get();

        return response()->json(['status' => 200,
        'salesReturnReport' => $salesReturnReport], 200);

    }
    catch (\Exception $e) {
        throw new Exception($e);
    }
    }
}
