<?php

namespace App\Http\Controllers\Report_Controllers;

use App\Http\Controllers\Controller;
use App\Models\Stock_Models\Grn;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Supplier_Models\PurchaseReturn;
use Exception;

class PurchaseReportController extends Controller
{
    public function purchaseList(Request $request)
    {
        try {
            $grn = Grn::select('grns.code',  'grn_date', 'supplier_code', 'sub_total_amount', 'total_amount', 'paid_status')
                ->with(['supplier' => function ($query) {
                    $query->select('code', 'name',)->where('is_active', '=', 1);
                }
                ])
                ->where('supplier_code', $request->supplierCode)
                ->get();

            return response()->json(['status' => 200, 'purchaseList' => $grn], 200);

        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }


    public function dailyPurchases(Request $request)
    {

        try {
        $grn = Grn::select('grns.code',  'grn_date', 'supplier_code', 'sub_total_amount','total_amount', 'paid_status')
            ->with(['supplier' => function ($query) {
                $query->select('code', 'name',)->where('is_active', '=', 1);
            }
            ])
            ->whereBetween('grn_date', [date('Y-m-d H:m:s', strtotime($request->fromDate)-1), date('Y-m-d H:m:s', strtotime($request->toDate))])
            ->get();

        return response()->json(['status' => 200, 'dailyPurchase' => $grn], 200);

    } catch (\Exception $e) {
        throw new Exception($e);
    }
    }


    public function monthlyPurchases(Request $request)
    {
        $month = $request->month;
        $year = $request->year;
        try {
                     $sql = "SELECT supplier_code, suppliers.name, sum(total_amount) as grn_total
                          FROM grns
                          INNER JOIN suppliers on suppliers.code = grns.supplier_code
                          WHERE MONTH(grn_date) = $month AND YEAR(grn_date) = $year

                          group by (supplier_code)
                          order by (supplier_code)";

                          $results = DB::select($sql);

                       return response()->Json(['status' => 200, 'monthlyPurchase' => $results]);

                    } catch (\Exception $e) {
                        return response()->json([
                            'status' => 500,
                            'message' => $e
                        ], 500);
                    }
    }

//hold it

    public function detailsPurchases(Request $request)
    {
        try {
            $grn = Grn::select('grns.code', 'grn_date', 'supplier_code', 'sub_total_amount', 'total_amount', 'paid_status')
            ->with(['supplier' => function ($query) {
                $query->select('code', 'name', 'contact_name', 'phone_1')
                ->where('is_active', '=', 1);
            }
            ])
            ->with(['stockHistories' => function($query){
                $query->where('is_active', '=', 1);
            }
            ])
            ->with(['stockHistories.itemMaster' => function($query){
                $query->select('code', 'name')->where('is_active', '=', 1);
            }
            ])
           // stockHistory
            ->whereBetween('grn_date', [date('Y-m-d H:m:s', strtotime($request->fromDate)), date('Y-m-d H:m:s', strtotime($request->toDate))])
            ->get();

        return response()->json(['status' => 200, 'detailsPurchase' => $grn], 200);

    } catch (\Exception $e) {
        throw new Exception($e);
    }

    }

    public function purchasesReturn(Request $request)
    {
        try {
            $purchasesReturn = PurchaseReturn::select('code',  'supplier_code',  'total_amount', 'return_type', 'grn_code' )
            ->with(['supplier' => function ($query) {
                $query->select('code', 'name', 'contact_name', 'phone_1')
                ->where('is_active', '=', 1);
            }
            ])


            // ->with(['stockHistories' => function($query){
            //     $query->where('is_active', '=', 1);
            // }
            // ])
            // ->with(['stockHistories.itemMaster' => function($query){
            //     $query->select('code', 'name')->where('is_active', '=', 1);
            // }
            // ])
           // stockHistory
            ->whereBetween('return_date_time', [date('Y-m-d H:m:s', strtotime($request->fromDate)), date('Y-m-d H:m:s', strtotime($request->toDate))])
            ->get();

        return response()->json(['status' => 200, 'purchasesReturn' => $purchasesReturn], 200);

    } catch (\Exception $e) {
        throw new Exception($e);
    }

    }
}
