<?php

namespace App\Http\Controllers\Report_Controllers;

use App\Http\Controllers\Controller;
use App\Models\PaymentReceipt_Models\PaymentReceipt;
use App\Models\PaymentReceipt_Models\InvoicePaymentReceipt;
use Exception;
use Illuminate\Http\Request;

class PaymentReceiptReportController extends Controller
{
    /**
     * dailyPaymentReceipt
     *author : sajana
     *date: 2023.02.01
     *purpose : get the receipt with their invoices , customer and what are mode of payments used to pay, searching through particular date
     * @param  mixed $request
     * @return void
     */
    public function dailyPaymentReceipt(Request $request)
    {
        try {
                $invoiceReceiptDetails = InvoicePaymentReceipt::select(
                    'code',
                    'invoice_total',
                    'paid_amount',
                    'outstanding',
                    'payment_receipt_code',
                    'invoice_code'
                )
                    ->with([
                        'invoice' => function ($query) {
                            $query->where('is_active', '=', 1);
                        }
                    ])

                    ->with([
                        'paymentReceipt.customer' => function ($query) {
                            $query->select('code', 'first_name')
                            ->where('is_active', '=', 1);
                        }
                    ])
                    ->with([
                        'paymentReceipt.modeOfPayments' => function ($query) {
                            $query->select('code', 'payment_receipt_code','amount')
                            ->where('is_active', '=', 1);
                        }
                    ])
                    ->whereBetween('created_at', [date('Y-m-d H:m:s', strtotime($request->fromDate)-1), date('Y-m-d H:m:s', strtotime($request->toDate))], )

                    ->where('is_active', '=', 1)
                    ->get();

        return response()->json(['status' => 200,
        'invoiceReceiptDetails' => $invoiceReceiptDetails
    ],
        200);

    } catch (\Exception $e) {
    throw new Exception($e);
    }
    }


    /**
     * dailyPaymentReceiptByRoute
     * author : fathima sajana
     * date : 2023.02.01
     * purpose : get all receipts using route
     * version : 1
     * @param  mixed $request
     * @return void
     */
    public function dailyPaymentReceiptByRoute(Request $request)
    {
        try {
                $key = $request->key;

                $invoiceReceiptDetailsByRoute = InvoicePaymentReceipt::select(
                    'code',
                    'invoice_total',
                    'paid_amount',
                    'outstanding',
                    'payment_receipt_code',
                    'invoice_code'
                )
                    ->with([
                        'invoice' => function ($query) {
                            $query->where('is_active', '=', 1);
                        }
                    ])
                    ->with([
                        'paymentReceipt.modeOfPayments' => function ($query) {
                            $query->select('code', 'payment_receipt_code','amount')
                            ->where('is_active', '=', 1);
                        }
                    ]) 
                    ->with([
                        'paymentReceipt.customer' => function ($query) {
                            $query->select('code', 'first_name')
                            ->where('is_active', '=', 1);
                        }
                    ])
                    ->whereHas('paymentReceipt.customer.route', function ( $query) use ($key)
                        {$query
                            ->where('name', 'LIKE', '%' . $key . '%');})

                    ->orwhereHas('paymentReceipt.customer.route', function ( $query) use ($key)
                        {$query
                            ->where('code', 'LIKE', '%' . $key . '%');})

                    // ->where('is_active', '=', 1)
                    ->where('status', '<>', 5)
                    ->get();

        return response()->json(['status' => 200,
        'invoiceReceiptDetailsByRoute' => $invoiceReceiptDetailsByRoute
    ],
        200);

    } catch (\Exception $e) {
    throw new Exception($e);
    }
    }


    /**
     * dailyPaymentReceiptByRep
     * author : fathima sajana
     * purpose : get all receipt using rep
     * version : 1
     * date : 2023.02.01
     * @param  mixed $request
     * @return void
     */
    public function dailyPaymentReceiptByRep(Request $request)
    {
        try {
            $key = $request->key;
            $fromDate = $request->fromDate;
            $toDate = $request->toDate;
    
            $invoiceReceiptDetailsByRep = InvoicePaymentReceipt::select(
                'code',
                'invoice_total',
                'paid_amount',
                'outstanding',
                'payment_receipt_code',
                'invoice_code'
            )
                ->with([
                    'invoice' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'paymentReceipt.modeOfPayments' => function ($query) {
                        $query->select('code', 'payment_receipt_code', 'amount')
                              ->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'paymentReceipt.customer' => function ($query) {
                        $query->select('code', 'first_name')
                              ->where('is_active', '=', 1);
                    }
                ])
                
                // Filter by salesRep with additional date filter if applicable
                ->whereHas('paymentReceipt.customer.route.salesRep', function ($query) use ($key, $fromDate, $toDate) {
                    $query->where('code', '=', $key);
                })
                // Apply date filtering directly on `paymentReceipt`
                ->whereHas('paymentReceipt', function ($query) use ($fromDate, $toDate) {
                    $query->whereBetween('payment_date_time', [$fromDate, $toDate])
                          ->where('is_active', '=', 1);
                })
                ->where('status', '<>', 5)
                ->get();
    
            return response()->json([
                'status' => 200,
                'invoiceReceiptDetailsByRep' => $invoiceReceiptDetailsByRep
            ], 200);
    
        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e->getMessage()
            ], 500);
        }
    }
    


    /**
     * dailyPaymentReceiptByLocation
     * author : fathima sajana
     * date: 2023.02.01
     * purpose : location wise get all receipts
     * version : 01
     * @param  mixed $request
     * @return void
     */
    public function dailyPaymentReceiptByLocation(Request $request)
    {
        try {
                $key = $request->key;

                $invoiceReceiptDetailsByRep = InvoicePaymentReceipt::select(
                    'code',
                    'invoice_total',
                    'paid_amount',
                    'outstanding',
                    'payment_receipt_code',
                    'invoice_code'
                )  ->with(['invoice.stockLocation' => function ($query) {
                            $query->select('code', 'name')
                            ->where('is_active', '=', 1);
                        }
                    ])
                    ->with([
                        'paymentReceipt.customer' => function ($query) {
                            $query->select('code', 'first_name')
                            ->where('is_active', '=', 1);
                        }
                    ])
                    ->with([
                        'paymentReceipt.modeOfPayments' => function ($query) {
                            $query->select('code', 'payment_receipt_code','amount')
                            ->where('is_active', '=', 1);
                        }
                    ])

                    ->whereHas('invoice.stockLocation', function ( $query) use ($key)
                        {$query->select('code', 'name')
                            ->where('name', 'LIKE', '%' . $key . '%');})

                    ->orwhereHas('invoice.stockLocation', function ( $query) use ($key)
                        {$query->select('code', 'name')
                            ->where('code', 'LIKE', '%' . $key . '%');})
                    // ->where('is_active', '=', 1)
                    ->where('status', '<>', 5)
                    ->get();

        return response()->json(['status' => 200,
        'invoiceReceiptDetailsByRep' => $invoiceReceiptDetailsByRep
    ],
        200);

    } catch (\Exception $e) {
    throw new Exception($e);
    }
    }
}
