<?php

namespace App\Http\Controllers\Report_Controllers;

use App\Http\Controllers\Controller;
use App\Models\Expense_Models\Expense;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Exception;

class ExpenseReportController extends Controller
{
   public function periodicExpenses(Request $request)
   {
       try {
           $expenses  = Expense::select('expenses.code', 'stock_location_code', 'expense_category_code', 'bank_code', 'expenses.created_at',
            'payment_type_code', 'cheque_date', 'cheque_number', 'ref_number', 'total_amount', 'expenses.description',
            'expense_types.name AS expense_type', 'expense_categories.name AS expense_category')
               ->join('expense_types', 'expense_types.code', '=', 'expenses.expense_type_code')
               ->join('expense_categories', 'expense_categories.code', '=', 'expenses.expense_category_code')
               ->with(['stockLocation' => function ($query) {
                $query->select('code', 'name')->where('is_active', '=', 1);
                }
            ])
            ->where('expenses.is_active', '=', 1)
            //    ->whereBetween('payment_date', [date('Y-m-d H:m:s', strtotime('2022-05-30')), date('Y-m-d H:m:s', strtotime('2022-05-31'))])
               
              ->whereBetween('payment_date', [date('Y-m-d H:m:s', strtotime($request->fromDate)-1), date('Y-m-d H:m:s', strtotime($request->toDate))])
               ->get();
           return response()->json(['status' => 200, 'Expenses' =>  $expenses]);
       } 

    catch (\Exception $e) {
        throw new Exception($e);
    }       
   }


   public function monthlyExpenses(Request $request)
   {
       $month = $request->month;
       $year = $request->year;
       try {
           $sql ="SELECT STR_TO_DATE(payment_date, '%Y-%m-%d')  AS Date , SUM(total_amount)AS expenses_total
           FROM expenses WHERE MONTH(payment_date)=$month AND YEAR(payment_date)=$year
           GROUP BY STR_TO_DATE(payment_date, '%Y-%m-%d') 
           ORDER BY STR_TO_DATE(payment_date, '%Y-%m-%d')";

           $results = DB::select($sql);
           return response()->json(['status' => 200, 'monthlyExpenses' => $results], 200);
        }
        catch (\Exception $e) {
            throw new Exception($e);
        }

   }
}


