<?php

namespace App\Http\Controllers\Report_Controllers;

use App\Enums\UserRole;
use App\Http\Controllers\Controller;
use App\Models\Customer_Models\Customer;
use App\Models\Invoice_Models\Invoice;
use App\Models\Invoice_Models\SalesReturn;
use App\Models\PaymentReceipt_Models\BankPayment;
use App\Models\PaymentReceipt_Models\CardPayment;
use App\Models\PaymentReceipt_Models\CashPayment;
use App\Models\PaymentReceipt_Models\ChequePayment;
use App\Models\PaymentReceipt_Models\PaymentReceipt;
use App\Models\PaymentReceipt_Models\ReturnAmount;
use App\Models\Stock_Models\SalesRep;
use App\Models\Stock_Models\Route;
use App\Models\User;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Carbon;
use Illuminate\Http\Request;
use stdClass;

class CustomerReportController extends Controller
{
    public function customerList(Request $request)
    {

        try {
            $code = $request->code;
            if ($code) {

            $sql = 'SELECT customers.code, customers.first_name, customers.second_name, customer_addresses.phone_1 AS adrsPhone1, customer_addresses.phone_2 AS adrsPhone2, customers.phone_1, customers.phone_2, customers.is_active, customers.credit_days
            FROM customers
            join customer_addresses on customer_addresses.customer_code = customers.code
            WHERE  customers.code = ' . $code;
            }

            else
            {
            $sql = 'SELECT customers.code, customers.first_name, customers.second_name, customer_addresses.phone_1 AS adrsPhone1, customer_addresses.phone_2 AS adrsPhone2, customers.phone_1, customers.phone_2, customers.is_active, customers.credit_days
            FROM customers
            join customer_addresses on customer_addresses.customer_code = customers.code
            WHERE  customers.is_active = ' . 1;
            }

            $results = DB::select($sql);

            return response()->json(
                ['status' => 200, 'customerlist' => $results],
                200
            );
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }


    public function customerSummary(Request $request)
    {
        try {

            $code = $request->code;
            $fromDate = $request->fromDate;
            $toDate = $request->toDate;

            $customer = Customer::select('code', 'credit_amount', 'return_amount', 'over_payment', 'cheque_return_amount')
            ->where('customers.code', '=', $code)
            //->whereBetween('customers.created_at', [date('Y-m-d H:m:s', strtotime($fromDate)), date('Y-m-d H:m:s', strtotime($toDate))])
            ->get();

            // $previousDataInvoice = "SELECT SUM(total_amount)AS invoiceTotal
            // FROM invoices
            // WHERE STR_TO_DATE(invoices.created_at, '%Y-%m-%d') > '. $fromDate . ' AND invoices.customer_code = '.$code.'
            // AND  invoices.status <> '5'";

            // $previousDataPayment = "SELECT SUM(total_amount)AS paymentTotal,  SUM(cheque_payments.amount)AS chequeTotal , SUM(cash_payments.amount)AS cashTotal ,  SUM(card_payments.amount)AS cardTotal ,  SUM(bank_payments.amount)AS bankTotal
            // FROM payment_receipts
            // LEFT JOIN cheque_payments on cheque_payments.receipt_code = payment_receipts.code
            // LEFT JOIN cash_payments on cash_payments.receipt_code = payment_receipts.code
            // LEFT JOIN card_payments on card_payments.receipt_code = payment_receipts.code
            // LEFT JOIN bank_payments on bank_payments.receipt_code = payment_receipts.code
            // WHERE STR_TO_DATE(payment_receipts.created_at, '%Y-%m-%d') > '. $fromDate . '
            // AND payment_receipts.customer_code = '.$code.'
            // AND  payment_receipts.status <> '5'";

            // $receiptTotalwithOverPayment = "SELECT (total_amount)AS receiptTotal, over_payments.amount as OverPayment
            // FROM payment_receipts
            // LEFT JOIN over_payments on over_payments.receipt_code = payment_receipts.code
            // WHERE STR_TO_DATE(payment_receipts.created_at, '%Y-%m-%d') > '. $fromDate . '
            // AND payment_receipts.customer_code = '.$code.'
            // AND  payment_receipts.status <> '5'";

            // $previousDataReturn = "SELECT SUM(total_amount)AS returnTotal
            // FROM sales_returns
            // WHERE (sales_returns.created_at) > '. $fromDate . ' AND sales_returns.customer_code = '.$code.'";

            $sql = 'SELECT code, created_at, customer_code, invoices.total_amount AS amount, remarks, "INV" AS source FROM invoices
            WHERE ( customer_code = ' . $code . ' AND invoices.status <> 5 AND ( created_at BETWEEN "' . $fromDate . '" AND "' . $toDate . '" ))
            UNION SELECT   sales_returns.code, created_at, sales_returns.customer_code, sales_returns.total_amount AS amount, remarks, "RTN" AS source FROM  sales_returns
            WHERE  (  customer_code = ' . $code . ' AND sales_returns.status <> 5 AND( created_at BETWEEN "' . $fromDate . '" AND "' . $toDate . '" ) )
            UNION SELECT payment_receipts.code , created_at, payment_receipts.customer_code, payment_receipts.settled_amount, remarks, "PMT" AS source  FROM payment_receipts
            WHERE  ( customer_code = ' . $code . ' AND payment_receipts.status <> 5 AND( created_at BETWEEN "' . $fromDate . '" AND "' . $toDate . '"))
            ORDER BY created_at ASC';

            $cash = CashPayment::select('amount AS cash_total', 'customer_code')
            ->where('customer_code', '=', $code)
            ->where('status', '<>', 5)
            ->whereBetween('cash_payments.date_time', [date('Y-m-d H:m:s', strtotime($fromDate)), date('Y-m-d H:m:s', strtotime($toDate))])
            ->get();

            $cheque = ChequePayment::select('amount AS cheque_total', 'customer_code')
            ->where('customer_code', '=', $code)
            ->where('status', '<>', 5)
            ->whereBetween('cheque_payments.date_time', [date('Y-m-d H:m:s', strtotime($fromDate)), date('Y-m-d H:m:s', strtotime($toDate))])
            ->get();

            $bank = BankPayment::select('amount AS bank_total', 'customer_code')
            ->where('customer_code', '=', $code)
            ->where('status', '<>', 5)
            ->whereBetween('bank_payments.date_time', [date('Y-m-d H:m:s', strtotime($fromDate)-1), date('Y-m-d H:m:s', strtotime($toDate))])
            ->get();

            $card = CardPayment::select('amount AS card_total', 'customer_code')
            ->where('customer_code', '=', $code)
            ->where('status', '<>', 5)
            ->whereBetween('card_payments.date_time', [date('Y-m-d H:m:s', strtotime($fromDate)-1), date('Y-m-d H:m:s', strtotime($toDate))])
            ->get();

            $return = ReturnAmount::select('amount AS return_total', 'customer_code')
            ->where('customer_code', '=', $code)
            ->where('status', '<>', 5)
            ->whereBetween('return_amounts.date_time', [date('Y-m-d H:m:s', strtotime($fromDate)-1), date('Y-m-d H:m:s', strtotime($toDate))])
            ->get();

            $salesReturn = SalesReturn::select('total_amount AS sales_return_total', 'customer_code')
            ->where('customer_code', '=', $code)
            ->where('status', '<>', 5)
            ->whereBetween('sales_returns.return_date_time', [date('Y-m-d H:m:s', strtotime($fromDate)-1), date('Y-m-d H:m:s', strtotime($toDate))])
            ->get();

            $cash_payment = 'SELECT IFNULL(sum(cash_payments.amount),0)AS cash_total, payment_receipts.customer_code FROM payment_receipts
            JOIN cash_payments on cash_payments.receipt_code = payment_receipts.code
            WHERE  ( customer_code = ' . $code . ' AND cash_payments.status <> 5  AND ( STR_TO_DATE(cash_payments.created_at, "%Y-%m-%d")  BETWEEN "'. $fromDate . '" AND "' . $toDate . '"))';

            $cheque_payment = 'SELECT IFNULL(sum(cheque_payments.amount),0)AS cheque_total, payment_receipts.customer_code FROM payment_receipts
            JOIN cheque_payments on cheque_payments.receipt_code = payment_receipts.code
            WHERE  ( customer_code = ' . $code . ' AND cheque_payments.status <> 5  AND ( STR_TO_DATE(cheque_payments.created_at, "%Y-%m-%d")  BETWEEN "'. $fromDate . '" AND "' . $toDate . '"))';

            $card_payment = 'SELECT IFNULL(sum(card_payments.amount),0)AS card_total, payment_receipts.customer_code FROM payment_receipts
            JOIN card_payments on card_payments.receipt_code = payment_receipts.code
            WHERE  ( customer_code = ' . $code . ' AND card_payments.status <> 5  AND ( STR_TO_DATE(card_payments.created_at, "%Y-%m-%d")  BETWEEN "'. $fromDate . '" AND "' . $toDate . '"))';

            $bank_payment = 'SELECT IFNULL(sum(bank_payments.amount),0)AS bank_total, payment_receipts.customer_code FROM payment_receipts
            JOIN bank_payments on bank_payments.receipt_code = payment_receipts.code
            WHERE  ( customer_code = ' . $code . ' AND bank_payments.status <> 5  AND ( STR_TO_DATE(bank_payments.created_at, "%Y-%m-%d")  BETWEEN "'. $fromDate . '" AND "' . $toDate . '"))';

            $return_amount = 'SELECT IFNULL(sum(return_amounts.amount),0)AS return_total, payment_receipts.customer_code FROM payment_receipts
            JOIN return_amounts on return_amounts.receipt_code = payment_receipts.code
            WHERE  ( customer_code = ' . $code . ' AND return_amounts.status <> 5  AND ( STR_TO_DATE(return_amounts.created_at, "%Y-%m-%d")  BETWEEN "'. $fromDate . '" AND "' . $toDate . '"))';


            $results = DB::select($sql);
            //$cash_payment = DB::select($cash_payment);
            //$cheque_payment = DB::select($cheque_payment);
            //$card_payment = DB::select($card_payment);
            //$bank_payment = DB::select($bank_payment);
            //$return_amount = DB::select($return_amount);

            //$previousDataInv = DB::select($previousDataInvoice);
            //$previousDataPay = DB::select($receiptTotalwithOverPayment);
            //$previousDataRet = DB::select($previousDataReturn);

            return response()->json([
                'status' => 200,
                'customer' => $customer,
                'customerSummary' => $results,
                //'previousDataRet' => $previousDataRet,
                'cash_payment' => $cash,
                'cheque_payment' => $cheque,
                'card_payment' => $card,
                'bank_payment' => $bank,
                'return_amount' => $return,
                'sales_return_amount' => $salesReturn,

                //'previousDataInv' => $previousDataInv,
                //'receiptTotalwithoverPayment' => $previousDataPay,
                //'cash_payment'=>$cash_payment,
                //'cheque_payment'=>$cheque_payment,
                //'card_payment'=>$card_payment,
                //'bank_payment'=>$bank_payment,
                //'return_amount'=>$return_amount

            ], 200);

        } catch (\Exception $e) {

            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    public function customerSummaryWithoutModeOfPayments(Request $request)
    {
        try {
            $code = $request->code;
            $fromDate = $request->fromDate;
            $toDate = $request->toDate;

            $previousDataInvoice = "SELECT SUM(total_amount)AS invoiceTotal
            FROM invoices
            WHERE STR_TO_DATE(invoices.created_at, '%Y-%m-%d') > '. $fromDate . ' AND invoices.customer_code = '.$code.'
            AND  invoices.status <> '5'";

            $previousDataPayment = "SELECT SUM(total_amount)AS paymentTotal
            FROM payment_receipts
            WHERE STR_TO_DATE(payment_receipts.created_at, '%Y-%m-%d') > '. $fromDate . ' AND payment_receipts.customer_code = '.$code.'
            AND  payment_receipts.status <> '5'";

            $previousDataReturn = "SELECT SUM(total_amount)AS returnTotal
            FROM sales_returns
            WHERE STR_TO_DATE(sales_returns.created_at, '%Y-%m-%d') > '. $fromDate . ' AND sales_returns.customer_code = '.$code.'";

            $sql = 'SELECT code, created_at, customer_code, invoices.total_amount AS amount, "INV" AS source FROM invoices
            WHERE ( customer_code = ' . $code . ' AND( created_at BETWEEN "' . $fromDate . '" AND "' . $toDate . '" ))
            UNION SELECT   sales_returns.code, created_at, sales_returns.customer_code, sales_returns.total_amount AS amount, "RTN" AS source FROM  sales_returns
            WHERE  (  customer_code = ' . $code . ' AND( created_at BETWEEN "' . $fromDate . '" AND "' . $toDate . '" ) )
            UNION SELECT payment_receipts.code , created_at, payment_receipts.customer_code, payment_receipts.settled_amount, "PMT" AS source  FROM payment_receipts
            WHERE  ( customer_code = ' . $code . ' AND payment_receipts.status <> 5 AND( created_at BETWEEN "' . $fromDate . '" AND "' . $toDate . '"))
            ORDER BY created_at ASC';

            $results = DB::select($sql);
            $previousDataInv = DB::select($previousDataInvoice);
            $previousDataPay = DB::select($previousDataPayment);
            $previousDataRet = DB::select($previousDataReturn);

            return response()->json([
                'status' => 200,
                'customerSummary' => $results,
                'previousDataInv' => $previousDataInv,
                'previousDataPay' => $previousDataPay,
                'previousDataRet' => $previousDataRet
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }



    /**
     * Author: ALA. Saneeth
     * Date: 24.10.2023
     * Version: 01
     * Logic:
     * Credit statement by filter customer code and customer type code. Ger Data ascending order by Custome code
*/

public function creditStatement(Request $request)
{
    try {
        $code = $request->code;
        $customerTyeCode = $request->customerTyeCode;
        $customer = null;
        if ($customerTyeCode) {
            $customer = Customer::select(
                'code',
                'custom_code',
                'route_code',
                'company_name',
                'first_name',
                'second_name',
                'phone_1',
                'phone_2',
                'email',
                'website',
                'credit_limit',
                'credit_amount',
                'over_payment',
                'cheque_return_amount',
                'return_amount',
                'credit_days',
                'passport_number',
                'nic_number',
                'rating',
                'notes',
                'is_active',
                'is_verified'
            )
                ->where('is_active', '=', 1)
                ->where('credit_amount', '>', 0)
                ->where('customer_type_code', $customerTyeCode)
                ->orderBy('custom_code', 'ASC')
                ->get();


        } elseif ($code) {
            $customer = Customer::select(
                'code',
                'custom_code',
                'route_code',
                'company_name',
                'first_name',
                'second_name',
                'phone_1',
                'phone_2',
                'email',
                'website',
                'credit_limit',
                'credit_amount',
                'over_payment',
                'cheque_return_amount',
                'return_amount',
                'credit_days',
                'passport_number',
                'nic_number',
                'rating',
                'notes',
                'is_active',
                'is_verified'
            )
                ->where('is_active', '=', 1)
                ->where('credit_amount', '>', 0)
                ->where('code', $code)
                ->orderBy('custom_code', 'ASC')
                ->get();
        }

        else {
            $customer = Customer::select(
                'code',
                'custom_code',
                'route_code',
                'company_name',
                'first_name',
                'second_name',
                'phone_1',
                'phone_2',
                'email',
                'website',
                'credit_limit',
                'credit_amount',
                'over_payment',
                'cheque_return_amount',
                'return_amount',
                'credit_days',
                'passport_number',
                'nic_number',
                'rating',
                'notes',
                'is_active',
                'is_verified'
            )
                ->where('is_active', '=', 1)
                ->where('credit_amount', '>', 0)
                ->orderBy('custom_code', 'ASC')
                ->get();

        }
        return response()->json(
            [
                'status' => 200,
                'customer' => $customer
            ],
            200
        );
    } catch (\Exception $e) {
        throw new Exception($e);
    }
}



    /**
     * creditStatementByRoute
     * Author: Suhail Jamaldeen
     * Date: 28.01.2023
     * Logic: Get the credit statment for route
     * @param  mixed $request
     * @return void
     */
    public function creditStatementByRoute(Request $request)
    {
        try {
            $code = $request->code;

            $route = Route::select(
                'code',
                'name',
                'rep_code'
            )
            ->with([
                'salesRep' => function ($query) {
                    $query->select(
                        'code',
                        'username'
                    )
                    ->where('is_active', '=', 1);
                }
            ])
            ->with([
                'customers' => function ($query) use ($code) {
                    $query->select(
                        'route_code',
                        'code',
                        'first_name',
                        'cheque_return_amount',
                        'credit_amount',
                        'over_payment',
                        'return_amount'
                    )
                    ->where('credit_amount', '>', 0)
                    ->where('is_active', '=', 1);

                    if ($code) {
                        $query->where('route_code', '=', $code);
                    }
                }
            ]);

            if ($code) {
                $route = $route->where('code', '=', $code);
            }

            $route = $route->get();

            return response()->json(
                [
                    'status' => 200,
                    'routes' => $route
                ],
                200);


        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }


    public function creditStatementByRep(Request $request)
    {
        try {
            $code = $request->code;

             $salesRep = User::select('id','code','stock_location_code', 'custom_code','username','is_active')
             ->with(['stockLocations' => function($query) {
                 $query->where('stock_location_user_roles.role_id', UserRole::SALES_REP); // Filter stockLocations by role_id
             }])
             //->where('is_active', 1)
             ->whereHas('stockLocations', function($query) {
                 $query->where('stock_location_user_roles.role_id', UserRole::SALES_REP); // Filter users by stockLocations having role_id = UserRole::SALES_REP
             })->with([
                'routes' => function ($query) {
                    $query->select(
                        'code',
                        'rep_code',
                        'name',
                        'from',
                        'to'
                    )->where('is_active', '=', 1);
                }, 'routes.customers' => function ($query) {
                    $query->where('is_active', '=', 1)
                    ->where('credit_amount' ,'>',0);
                },

            ])
            ->where('code','=',$code  )
             ->first();

            return response()->json(
                [
                    'status' => 200,
                    'salesRep' => $salesRep
                ],
                200
            );
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }


    public function getCustomerCredit(Request $request)
    {
        try {
            $sql = "SELECT invoices.customer_code, invoices.paid_amount ,invoices.total_amount,
         (SELECT IFNULL(sum(invoice_payment_receipts.paid_amount),0) FROM invoice_payment_receipts WHERE invoice_payment_receipts.invoice_code = invoices.code) AS invoice_payment_receipts_amount,
        invoices.total_amount - (SELECT IFNULL(sum(invoice_payment_receipts.paid_amount),0) FROM invoice_payment_receipts WHERE invoice_payment_receipts.invoice_code = invoices.code)  AS customer_credit
        FROM invoices
        WHERE (invoices.customer_code=$request->code AND  invoices.total_amount - (SELECT IFNULL(sum(invoice_payment_receipts.paid_amount),0) FROM invoice_payment_receipts WHERE invoice_payment_receipts.invoice_code = invoices.code) >0)  ";

            $results = DB::select($sql);

            return response()->json(['status' => 200, 'customer' => $results], 200);
        } catch (\Exception $e) {
            return response()->json(['status' => 500, 'message' => $e], 500);
        }
    }


    public function customerAgingSummary(Request $request)
    {
        $code = $request->code;

        $sql = "SELECT code, first_name, second_name, phone_1, phone_2 FROM customers WHERE code LIKE '%$code%'";

        $results = DB::select($sql);

        $response = array();

        foreach ($results as $result) {
            $aging7Days = "SELECT
                            IFNULL((SUM(total_amount) - SUM(paid_amount)),0) AS outstanding
                            FROM invoices
                            WHERE ABS(DATEDIFF(DATE(date_time), DATE(NOW()))) <= 7 AND ABS(DATEDIFF(DATE(date_time),
                                    DATE(NOW()))) >= 0 AND invoices.customer_code = '$result->code'";

            $aging15Days = "SELECT
                            IFNULL((SUM(total_amount) - SUM(paid_amount)),0) AS outstanding
                            FROM invoices
                            WHERE ABS(DATEDIFF(DATE(date_time), DATE(NOW()))) <= 15 AND ABS(DATEDIFF(DATE(date_time), DATE(NOW()))) >= 8 AND invoices.customer_code = '$result->code'";

            $aging30Days = "SELECT
                            IFNULL((SUM(total_amount) - SUM(paid_amount)),0) AS outstanding
                            FROM invoices
                            WHERE ABS(DATEDIFF(DATE(date_time), DATE(NOW()))) <= 30 AND ABS(DATEDIFF(DATE(date_time), DATE(NOW()))) >= 16 AND invoices.customer_code = '$result->code'";

            $aging60Days = "SELECT
                            IFNULL((SUM(total_amount) - SUM(paid_amount)),0) AS outstanding
                            FROM invoices
                            WHERE ABS(DATEDIFF(DATE(date_time), DATE(NOW()))) <= 60 AND ABS(DATEDIFF(DATE(date_time), DATE(NOW()))) >= 31 AND invoices.customer_code = '$result->code'";

            $over60Days = "SELECT
                            IFNULL((SUM(total_amount)- SUM(paid_amount)),0) AS outstanding
                            FROM invoices
                            WHERE ABS(DATEDIFF(DATE(date_time), DATE(NOW()))) >= 61 AND invoices.customer_code = '$result->code'";

            $result7 = DB::select($aging7Days);
            $result15 = DB::select($aging15Days);
            $result30 = DB::select($aging30Days);
            $result60 = DB::select($aging60Days);
            $over60 = DB::select($over60Days);

            $obj = new stdClass;
            $obj->day7 = $result7;
            $obj->day15 = $result15;
            $obj->day30 = $result30;
            $obj->day60 = $result60;
            $obj->over60 = $over60;
            $obj->customer = $result;
            array_push($response, $obj);
        }

        return response()->json(['status' => 200, 'customer' => $response], 200);
    }
}
