<?php

namespace App\Http\Controllers\Report_Controllers;

use App\Http\Controllers\Controller;
use App\Models\PaymentVoucher_Models\SupplierChequePayment;
use Illuminate\Http\Request;

class ChequeVoucherReportController extends Controller
{
    //

    public function chequeBySupplier(Request $request)
    {
        try {
            //$code = $request->code;
            $key = $request->key;

            $chequeBySupplier  = SupplierChequePayment::select('supplier_cheque_payments.code', 'supplier_cheque_payments.supplier_mode_of_payment_code', 'supplier_cheque_payments.deposit_date', 'supplier_cheque_payments.bank_code', 'supplier_cheque_payments.number', 'supplier_cheque_payments.created_at', 'supplier_cheque_payments.amount')
                ->with([
                    'bank' => function ($query) {
                        $query->select('code', 'name')
                            ->where('is_active', '=', 1);
                    },
                ])
                ->with([
                    'supplierModeOfPayment' => function ($query) {
                        $query->select('code', 'payment_voucher_code')
                            ->where('is_active', '=', 1);
                    },
                    'supplierModeOfPayment.paymentVoucher' => function ($query) {
                        $query->select('code', 'supplier_code')
                            ->where('is_active', '=', 1);
                    },
                    'supplierModeOfPayment.paymentVoucher.supplier' => function ($query) use ($key) {
                        $query->select('code', 'name')
                        ->orWhere('name', 'like', "%$key%")
                        ->orWhere('code', 'like', "%$key%");
                        // ->where('is_active', '=', 1);
                    }
                ])
                //->where('supplier_cheque_payments.code', $code)
                // ->where('supplier_cheque_payments.status', '=', 6)
                ->get();

            return response()->json([
                'status' => 200,
                'chequeBySupplier' => $chequeBySupplier
            ]);
        } catch (\Exception $e) {
            return response()->json(['status' => 500, 'message' => $e]);
        }
    }

    
    /**
     * voucherChequeInHand
     * Author: Fathima Sajana
     * Date: 2023.02.01
     * Version: 01
     * Logic: Get cheques in hands received via vouchers. 
     * 
     * version :02
     * date : 2023.04.02
     * Logic: location based cheques in hands received via vouchers. 
     * @param  mixed $request
     * @return void
     */
    public function periodicCheque(Request $request)
    {
        try {
            $periodicCheque  = SupplierChequePayment::select(
                'supplier_cheque_payments.code', 
                'supplier_cheque_payments.supplier_mode_of_payment_code', 
                'supplier_cheque_payments.deposit_date', 
                'supplier_cheque_payments.bank_code', 
                'supplier_cheque_payments.number', 
                'supplier_cheque_payments.created_at', 
                'supplier_cheque_payments.amount'
                )
                ->with([
                    'bank' => function ($query) {
                        $query->select('code', 'name')
                            ->where('is_active', '=', 1);
                    },
                ])
                ->with([
                    'supplierModeOfPayment.paymentVoucher.supplier' => function ($query) {
                        $query->select('code', 'name')
                            ->where('is_active', '=', 1);
                    },
                ])

                ->whereBetween('supplier_cheque_payments.created_at', [date('Y-m-d H:m:s', strtotime($request->fromDate)-1), date('Y-m-d H:m:s', strtotime($request->toDate))])
                ->whereHas('supplierModeOfPayment.paymentVoucher.stockLocation', function ( $query) use ($request)
                {$query
                ->where('code', '=', getCurrentLocationCode($request));})
                ->get();


            return response()->json([
                'status' => 200,
                'voucherChequeInHand' => $periodicCheque
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

}
