<?php

namespace App\Http\Controllers\Payment_Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\PaymentReceipt_Models\PaymentType;
use App\Enums\TransactionCode;
use Exception;

class PaymentTypeController extends Controller
{
    public function index()
    {
        try{
            $paymentTypes  = PaymentType::select('code','name')->where('is_active', '=', 1)->get();
            return response()->json(['status' => 200, 'paymentTypes' =>  $paymentTypes ]);
        }catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    public function show($id)
    {
        try{
            $paymentTypes  = PaymentType::select('code','name')->where('code',$id)->where('is_active', '=', 1)->first();
            return response()->json(['status' => 200, 'paymentTypes' =>  $paymentTypes ]);
        }catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        try{

            $payment_code =TransactionCode::PAYMENT_TYPE_CODE;
            $cus_code = PaymentType::max('code');
            $max_id= $cus_code==null ? config('global.code_value')+1 : substr("$cus_code",3)+1;

            $paymentType = PaymentType::create([

                'code'=> $payment_code.$max_id,
                'name'=> $request->name,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),

            ]);

            return response()->json(['status' => 200, 'message'=>"Payment Types created" ]);
        }catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    public function edit($id)
    {
        //
    }


    public function update(Request $request, $id)
    {
        try{
        $paymentType= PaymentType::where('code', $id)->first();
        $paymentType->update([
            'name'=> $request->name,
            'updated_by'=> getUserCode(),
            'updated_at'=> getDateTimeNow(),
        ]);
        return response()->json(['status'=> 200, 'message'=> "Payment Types updated"]);

        } catch (\Exception $e) {


            throw new Exception($e);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try{
            $paymentType = PaymentType::select('id','is_active')->where('code', $id)->where('is_active', '=', 1)->first();
            $paymentType->update([
                'is_active'=>0
            ]);
            return response()->json([
                'status'=> 204,
                'message'=>"Payment Types - Deleted"
                ]);


            }catch (\Exception $e) {
                throw new Exception($e);
            }
    }

}
