<?php

namespace App\Http\Controllers\Payment_Controllers;

use App\Enums\DefaultValues;
use App\Enums\PaymentStatus;
use App\Enums\PaymentTypeCode;
use App\Enums\MultiPurposeStatus;
use App\Enums\TransactionCode;
use App\Enums\ChequeStatusCode;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Function_Controllers\SmsFunction;
use Illuminate\Support\Collection;
use App\Models\Customer_Models\Customer;
use App\Models\Invoice_Models\Invoice;
use App\Models\PaymentReceipt_Models\BankPayment;
use App\Models\PaymentReceipt_Models\CardPayment;
use App\Models\PaymentReceipt_Models\CashPayment;
use App\Models\PaymentReceipt_Models\OverPayment;
use App\Models\PaymentReceipt_Models\ReturnAmount;
use App\Models\PaymentReceipt_Models\ChequePayment;
use App\Models\PaymentReceipt_Models\InvoicePaymentReceipt;
use App\Models\PaymentReceipt_Models\ModeOfPayment;
use App\Models\PaymentReceipt_Models\OnlineTransferPayment;
use App\Models\PaymentReceipt_Models\PaymentReceipt;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Enums\LockedStatus;


class PaymentReceiptController extends Controller
{
    private $sms_function;

    public function __construct()
    {

        $this->sms_function = new SmsFunction();

    }
    /**
     * index
     * Author: Suhail Jamaldeen
     * Date: 17.01.2023
     * Version: 01
     * Logic: Select all but pagination for 10 is added.
     * @param  mixed $request
     * @return void
     */
    public function index(Request $request)
    {
        try {
            $paymentReceipts = PaymentReceipt::query()
                ->with([
                    'customer' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'modeOfPayments' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'user' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'stockLocation' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->where('is_active', '=', 1)
                ->where('stock_location_code', '=', getCurrentLocationCode($request))
                ->orderBy('created_at', 'DESC')
                ->cursorPaginate(DefaultValues::PAGINATION_VALUE);

            return response()->json([
                'status' => 200,
                'paymentReceipts' => $paymentReceipts
            ]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }
    /**
     * show
     * Author : fathima sajana
     * Date : 2022.10.11
     * Version : 2
     * Logic : showing payment receipt  with selected invoicedetails
     *
     * @param  mixed $id
     * @return void
     */

     public function show($id)
     {
         try {
             $paymentReceipt = PaymentReceipt::select(
                 'code',
                 'customer_code',
                 'total_amount',
                 'settled_amount',
                 'over_payment',
                 'status',
                 'payment_date_time',
                 'is_pay_off_only',
                 'remarks',
                 'created_by'
             )
                 ->with([
                     'customer' => function ($query) {
                         $query->where('is_active', '=', 1);
                     }
                 ])
                 ->with([
                     'modeOfPayments' => function ($query) {
                         $query->where('is_active', '=', 1);
                     }
                 ])
                 ->with([
                     'user' => function ($query) {
                         $query->where('is_active', '=', 1);
                     }
                 ])
                 ->with([
                     'stockLocation' => function ($query) {
                         $query->where('is_active', '=', 1);
                     }
                 ])
                 ->where('code', $id)
                 ->where('is_active', '=', 1)
                 ->first();

             if ($paymentReceipt) {
                 $cash = CashPayment::select('amount')
                     ->where('receipt_code', $paymentReceipt->code)
                     ->where('is_active', '=', 1)
                     ->get();

                 $overPay = OverPayment::select('amount')
                     ->where('receipt_code', $paymentReceipt->code)
                     ->where('is_active', '=', 1)
                     ->get();

                 $returnAmnt = ReturnAmount::select('amount')
                     ->where('receipt_code', $paymentReceipt->code)
                     ->where('is_active', '=', 1)
                     ->get();

                 $cheque = ChequePayment::select('number', 'bank_code', 'branch_code', 'deposit_date', 'amount')
                     ->with([
                         'bank' => function ($query) {
                             $query->select('code', 'name')
                                 ->where('is_active', '=', 1);
                         }
                     ])
                     ->where('receipt_code', $paymentReceipt->code)
                     ->where('is_active', '=', 1)
                     ->get();

                 $bank = BankPayment::select('bank_code', 'reference_number', 'date', 'amount')
                     ->with([
                         'bank' => function ($query) {
                             $query->select('code', 'name')
                                 ->where('is_active', '=', 1);
                         }
                     ])
                     ->where('receipt_code', $paymentReceipt->code)
                     ->where('is_active', '=', 1)
                     ->get();

                 $onlineTransfer = OnlineTransferPayment::select('bank_code', 'transfer_id', 'transfer_date', 'amount')
                     ->with([
                         'bank' => function ($query) {
                             $query->select('code', 'name')
                                 ->where('is_active', '=', 1);
                         }
                     ])
                     ->where('receipt_code', $paymentReceipt->code)
                     ->where('is_active', '=', 1)
                     ->get();

                 $card = CardPayment::select('bank_code', 'card_number', 'amount')
                     ->with([
                         'bank' => function ($query) {
                             $query->select('code', 'name')
                                 ->where('is_active', '=', 1);
                         }
                     ])
                     ->where('receipt_code', $paymentReceipt->code)
                     ->where('is_active', '=', 1)
                     ->get();

                 $invoiceDetails = InvoicePaymentReceipt::select(
                     'code',
                     'invoice_total',
                     'paid_amount',
                     'outstanding',
                     'payment_receipt_code',
                     'pay_off',
                     'invoice_code'
                 )
                     ->with([
                         'invoice' => function ($query) {
                             $query->where('is_active', '=', 1);
                         }
                     ])->with([
                        'paymentReceipt.modeOfPayments' => function ($query) {
                            $query->where('is_active', '=', 1);
                        }
                    ])->with([
                        'paymentReceipt.customer' => function ($query) {
                            $query->where('is_active', '=', 1);
                        }
                    ])
                     ->where('payment_receipt_code', $paymentReceipt->code)
                     ->where('is_active', '=', 1)
                     ->get();


                $overPaymentReceip = InvoicePaymentReceipt::select(
                    'code',
                    'invoice_total',
                    'paid_amount',
                    'outstanding',
                    'payment_receipt_code',
                    'pay_off',
                    'invoice_code'
                )
                    ->with([
                        'invoice' => function ($query) {
                            $query->where('is_active', '=', 1);
                        }
                    ])->with([
                       'paymentReceipt.modeOfPayments' => function ($query) {
                           $query->where('is_active', '=', 1);
                       }
                   ])->with([
                       'paymentReceipt.customer' => function ($query) {
                           $query->where('is_active', '=', 1);
                       }
                   ])
                    ->where('is_active', '=', 1)
                    ->get();



                 return response()->json([
                     'status' => 200,
                     'paymentReceipt' => $paymentReceipt,
                     'cashPayment' => $cash,
                     'overPayment' => $overPay,
                     'returnAmount' => $returnAmnt,
                     'chequePayment' => $cheque,
                     'bankPayment' => $bank,
                     'onlineTransferPayment' => $onlineTransfer,
                     'cardPayment' => $card,
                     'invoiceDetails' => $invoiceDetails,
                     'overPaymentReceip' =>   $overPaymentReceip,
                 ]);
             } else {
                 return response()->json([
                     'status' => 204,
                     'message' => 'Payment receipt code ' . $id . ' not found',
                 ]);
             }
         } catch (\Exception $e) {
             throw new Exception($e);
             // return response(['status' => 500, 'message' => $e]);
         }
     }

    public function paymentReceiptLock(Request $request)
    {
        try {
            $code = $request->code;
            $paymentReceipt = PaymentReceipt::where('code', '=', $code)
                ->where('is_locked', '=', 0)
                ->where('is_active', '=', 1)
                ->first();

            $paymentReceipt->update([
                'is_locked' => LockedStatus::LOCKED,
            ]);

            return response()->json(
                [
                    'status' => 200,
                    'paymentReceipt' => $paymentReceipt,
                    'message' => 'Payment Receipt has locked',
                ]
            );
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }


    public function create()
    {
        //
    }

    /**
     * store
     * Author : Suhail Jamaldeen
     * Date : 2022.12.02
     * Version : 2
     * Logic : Store the invoicedetails
     *
     * @param  mixed $request
     * @return void
     */

     public function store(Request $request)
     {
         try {
             DB::beginTransaction();
             $payment_code = TransactionCode::PAYMENT_RECEIPT_CODE;

             $stockLocationCode = getCurrentLocationCode($request);
             $locationPrefix = substr("$stockLocationCode", -2);
             $max_code = PaymentReceipt::select('code')
                 ->where('stock_location_code', '=', $stockLocationCode)
                 ->max('code');

             $max_id = $max_code == null || $max_code == '' ? config('global.code_value') + 1 : substr("$max_code", 5) + 1;

             $paymentReceipt = PaymentReceipt::create([
                 'code' => $payment_code . $locationPrefix . $max_id,
                 'customer_code' => $request['customer']['code'] ?? null,
                 'stock_location_code' => getCurrentLocationCode($request),
                 'total_amount' => $request->totalAmount ?? 0,
                 'settled_amount' => $request->settledAmount ?? 0,
                 'over_payment' => ($request->totalAmount - $request->settledAmount),
                 'status' => $request->payment['paidStatus'],
                 'remarks' => $request->remarks,
                 'payment_date_time' => $request->paymentDateTime,
                 'created_by' => getUserCode(),
                 'created_at' => getDateTimeNow(),
                 'updated_by' => getUserCode(),
                 'updated_at' => getDateTimeNow()
             ]);

             $modeOfPayments = $request->modeOfPayments;
             $customer = $request->customer;
             $selectedInvoices = $request->invoices;
             $paidByOverPayment = 0;
             $paidByReturnPayment = 0;
             $payOffStatus = $request->payOffStatus;

             if ($paymentReceipt) {
                 if (count($modeOfPayments) > 0) {
                     foreach ($modeOfPayments as $mode_of_payment) {
                         $modePayment_code = TransactionCode::MODE_OF_PAYMENT;
                         $max_code = ModeOfPayment::max('code');
                         $max_id = $max_code == null ? config('global.code_value') + 1 : substr("$max_code", 3) + 1;

                         $modeOfPayment = ModeOfPayment::create([
                             'code' => $modePayment_code . $max_id,
                             'payment_receipt_code' => $paymentReceipt->code,
                             'payment_type_code' => $mode_of_payment['paymentType'],
                             'amount' => $mode_of_payment['amount'],
                             'date_time' => $paymentReceipt['payment_date_time'],
                             'created_by' => getUserCode(),
                             'created_at' => getDateTimeNow(),
                             'updated_by' => getUserCode(),
                             'updated_at' => getDateTimeNow()
                         ]);

                         if ($modeOfPayment) {
                             if ($modeOfPayment->payment_type_code == PaymentTypeCode::CASH_PAYMENT_CODE) {
                                 $this->addCashPayment($mode_of_payment, $modeOfPayment->code, $paymentReceipt, $customer);
                             } else if ($modeOfPayment->payment_type_code == PaymentTypeCode::OVER_PAYMENT_CODE) {
                                 $paidByOverPayment = $paidByOverPayment + $modeOfPayment['amount'];
                                 $this->addOverPayment($mode_of_payment, $modeOfPayment->code, $paymentReceipt, $customer);
                             } else if ($modeOfPayment->payment_type_code == PaymentTypeCode::RETURN_AMOUNT_CODE) {
                                 $paidByReturnPayment = $paidByReturnPayment + $modeOfPayment['amount'];
                                 $this->addReturnAmount($mode_of_payment, $modeOfPayment->code, $paymentReceipt, $customer);
                             } else if ($modeOfPayment->payment_type_code == PaymentTypeCode::CHEQUE_PAYMENT_CODE) {
                                 $this->addChequePayment($mode_of_payment, $modeOfPayment->code, $paymentReceipt, $customer);
                             } elseif ($modeOfPayment->payment_type_code == PaymentTypeCode::BANK_PAYMENT_CODE) {
                                 $this->addBankPayment($mode_of_payment, $modeOfPayment->code, $paymentReceipt, $customer);
                             } elseif ($modeOfPayment->payment_type_code == PaymentTypeCode::CARD_PAYMENT_CODE) {
                                 $this->addCardPayment($mode_of_payment, $modeOfPayment->code, $paymentReceipt, $customer);
                             } elseif ($modeOfPayment->payment_type_code == PaymentTypeCode::ONLINE_TRANSFER_PAYMENT_CODE) {
                                 $this->addOnlineTransferPayment($mode_of_payment, $modeOfPayment->code, $paymentReceipt, $customer);
                             }
                         }
                     }

                     $customer = Customer::where('code', $paymentReceipt->customer_code)->first();
                     if ($customer) {
                         $customer->update([
                             'invoice_total' => $customer['invoice_total'],
                             'received_amount' => ($customer['received_amount'] + $paymentReceipt['total_amount']) - $paidByOverPayment,
                             'over_payment' => $customer['over_payment'] + ($request->totalAmount - ($request->settledAmount + $paidByOverPayment)),
                             'return_amount' => $customer['return_amount'] - $paidByReturnPayment,
                             'credit_amount' => $customer['credit_amount'] - $request->settledAmount -  $request['totalPayOff'],
                             'updated_by' => getUserCode(),
                             'updated_at' => getDateTimeNow()
                         ]);
                     }
                 }

                 foreach ($selectedInvoices as $selectedInvoice) {
                     $existingInvoice = Invoice::where('code', $selectedInvoice['code'])->first();
                     $this->addInvoicePaymentForPaymentReceipt($paymentReceipt, $selectedInvoice, $existingInvoice);

                     if ($existingInvoice) {
                         $paidStatus = PaymentStatus::PAYMENT_PARTIAL;
                         $payOff = $selectedInvoice['payOff'] ?? 0;
                         $totalPaidAmount = $existingInvoice['paid_amount'] + $selectedInvoice['paymentAmount'] +  $payOff;
                         if ($totalPaidAmount >= $existingInvoice['total_amount']) {
                             $paidStatus = PaymentStatus::PAYMENT_COMPLETED;
                         }
                         $existingInvoice->update([
                             'pay_off'=>  $existingInvoice['pay_off'] +  $payOff,
                             'paid_amount' => $totalPaidAmount,
                             'paid_status' => $paidStatus,
                             'updated_by' => getUserCode(),
                             'updated_at' => getDateTimeNow(),
                         ]);
                     }
                 }
                 $this->sms_function->PaymentReceiptSms($customer, $paymentReceipt);
             }

             DB::commit();
             return response()->json([
                 'status' => 200,
                 'message' => 'paymentReceipt Created',
                 'costomer' => $paymentReceipt,
                 'der' => $customer,
             ]);
         } catch (\Exception $e) {
             DB::rollBack();
             throw new Exception($e);
         }
     }

     public function payoffOnly(Request $request)
     {
         //try {
             DB::beginTransaction();
             $payment_code = TransactionCode::PAYMENT_RECEIPT_CODE;

             $stockLocationCode = getCurrentLocationCode($request);
             $locationPrefix = substr("$stockLocationCode", -2);
             $max_code = PaymentReceipt::select('code')
                 ->where('stock_location_code', '=', $stockLocationCode)
                 ->max('code');

             $max_id = $max_code == null || $max_code == '' ? config('global.code_value') + 1 : substr("$max_code", 5) + 1;



             $paymentReceipt = PaymentReceipt::create([
                 'code' => $payment_code . $locationPrefix . $max_id,
                 'customer_code' => $request['customer']['code'] ?? null,
                 'stock_location_code' => getCurrentLocationCode($request),
                 'total_amount' => $request->totalAmount ?? 0,
                 'settled_amount' => $request->settledAmount ?? 0,
                 'over_payment' => ($request->totalAmount - $request->settledAmount),
                 'status' => $request->payment['paidStatus'],
                 'is_pay_off_only'=>true,
                 'remarks' => $request->remarks,
                 'payment_date_time' => $request->paymentDateTime,
                 'created_by' => getUserCode(),
                 'created_at' => getDateTimeNow(),
                 'updated_by' => getUserCode(),
                 'updated_at' => getDateTimeNow()
             ]);

             $customer = $request->customer;
             $selectedInvoices = $request->invoices;
             $paidByOverPayment = 0;
             $paidByReturnPayment = 0;
             $payOffStatus = $request->payOffStatus;

             if ($paymentReceipt) {
                     $customer = Customer::where('code', $paymentReceipt->customer_code)->first();
                     if ($customer) {
                         $customer->update([
                             'invoice_total' => $customer['invoice_total'],
                             'received_amount' => ($customer['received_amount'] + $paymentReceipt['total_amount']) - $paidByOverPayment,
                             'over_payment' => $customer['over_payment'] + ($request->totalAmount - ($request->settledAmount + $paidByOverPayment)),
                             'return_amount' => $customer['return_amount'] - $paidByReturnPayment,
                             'credit_amount' => $customer['credit_amount'] - $request->settledAmount -  $request['totalPayOff'],
                             'updated_by' => getUserCode(),
                             'updated_at' => getDateTimeNow()
                         ]);
                     }
                 }

                 foreach ($selectedInvoices as $selectedInvoice) {
                     $existingInvoice = Invoice::where('code', $selectedInvoice['code'])->first();
                     $this->addInvoicePaymentForPaymentReceipt($paymentReceipt, $selectedInvoice, $existingInvoice);

                     if ($existingInvoice) {
                         $paidStatus = PaymentStatus::PAYMENT_PARTIAL;
                         $payOff = $selectedInvoice['payOff'] ?? 0;
                         $totalPaidAmount = $existingInvoice['paid_amount'] + $selectedInvoice['paymentAmount'] +  $payOff;
                         if ($totalPaidAmount >= $existingInvoice['total_amount']) {
                             $paidStatus = PaymentStatus::PAYMENT_COMPLETED;
                         }
                         $existingInvoice->update([
                             'pay_off'=>  $existingInvoice['pay_off'] +  $payOff,
                             'paid_amount' => $totalPaidAmount,
                             'paid_status' => $paidStatus,
                             'updated_by' => getUserCode(),
                             'updated_at' => getDateTimeNow(),
                         ]);
                     }
                 }


             DB::commit();
             return response()->json([
                 'status' => 200,
                 'message' => 'paymentReceipt Created',
                 'costomer' => $paymentReceipt,
                 'der' => $customer,
             ]);
        //  } catch (\Exception $e) {
        //      DB::rollBack();
        //      throw new Exception($e);
        //  }
     }

    /**
     * reversal
     * Author : fathima sajana
     * Date : 2022.11.01
     * Version : 1
     * Logic
     * Author : Suhail Jamaldeen
     * Date : 2022.11.09
     * Version : 2
     * Logic: Payment Receipt Reversal.
     * @return void
     */
    public function reversal(Request $request)
    {

        try {
            $paymentReceiptCode = $request->transactionCode;

            $paymentReceipt = PaymentReceipt::where('code', '=', $paymentReceiptCode)
                ->where('status', '<>', MultiPurposeStatus::REVERSED)
                ->where('is_active', '=', 1)->first();


            if (!$paymentReceipt) {
                return response()->json([
                    'status' => 200,
                    'message' => 'Payment Receipt Code - ' . $paymentReceiptCode . ' Not Found'
                ]);
            }



            //If payment Receipt found in the table

            DB::beginTransaction();

            $invoicePaymentReceipt = InvoicePaymentReceipt::where('payment_receipt_code', '=', $paymentReceipt->code)
            ->where('is_active', '=', 1)->get();

            $totalPayOff = $invoicePaymentReceipt->sum('pay_off');


            $paymentReceipt->update([
                'status' => MultiPurposeStatus::REVERSED,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);


            $modeOfPayment = ModeOfPayment::where('payment_receipt_code', '=', $paymentReceiptCode)
                ->where('is_active', '=', 1)->get();
            $return = 0;
            $over = 0;

            // return response()->json([
            //     'status' => 200,
            //     'message' => $modeOfPayment
            // ]);


            if (count($modeOfPayment) > 0) {
                foreach ($modeOfPayment as $mode_of_payment) {
                    $mode_of_payment->update([
                        'status' => MultiPurposeStatus::REVERSED,
                        'updated_by' => getUserCode(),
                        'updated_at' => getDateTimeNow()
                    ]);

                    $paymentType = $mode_of_payment->payment_type_code;
                    switch ($paymentType) {
                        case PaymentTypeCode::CASH_PAYMENT_CODE:
                            CashPayment::where('mode_of_payment_code', $mode_of_payment->code)
                                ->update([
                                    'status' => MultiPurposeStatus::REVERSED,
                                    'updated_by' => getUserCode(),
                                    'updated_at' => getDateTimeNow(),
                                ]);
                            break;

                        case PaymentTypeCode::OVER_PAYMENT_CODE:
                            OverPayment::where('mode_of_payment_code', $mode_of_payment->code)
                                ->update([
                                    'amount' => $mode_of_payment['amount'],
                                    'status' => MultiPurposeStatus::REVERSED,
                                    'updated_by' => getUserCode(),
                                    'updated_at' => getDateTimeNow(),
                                ]);
                            $overPmnt = OverPayment::where('mode_of_payment_code', $mode_of_payment->code)
                                ->first();
                            $over = $over + $overPmnt['amount'];
                            break;

                        case PaymentTypeCode::RETURN_AMOUNT_CODE:
                            ReturnAmount::where('mode_of_payment_code', $mode_of_payment->code)
                                ->update([
                                    'amount' => $mode_of_payment['amount'],
                                    'status' => MultiPurposeStatus::REVERSED,
                                    'updated_by' => getUserCode(),
                                    'updated_at' => getDateTimeNow(),
                                ]);
                            $returnAmnt = ReturnAmount::where('mode_of_payment_code', $mode_of_payment->code)
                                ->first();
                            $return = $return + $returnAmnt['amount'];
                            break;

                        case PaymentTypeCode::CARD_PAYMENT_CODE:
                            CardPayment::where('mode_of_payment_code', $mode_of_payment->code)
                                ->update([
                                    'status' => MultiPurposeStatus::REVERSED,
                                    'updated_by' => getUserCode(),
                                    'updated_at' => getDateTimeNow(),
                                ]);
                            break;

                        case PaymentTypeCode::CHEQUE_PAYMENT_CODE:
                            ChequePayment::where('mode_of_payment_code', $mode_of_payment->code)
                                ->update([
                                    'status' => MultiPurposeStatus::REVERSED,
                                    'updated_by' => getUserCode(),
                                    'updated_at' => getDateTimeNow(),
                                ]);
                            break;

                        case PaymentTypeCode::BANK_PAYMENT_CODE:
                            BankPayment::where('mode_of_payment_code', $mode_of_payment->code)
                                ->update([
                                    'status' => MultiPurposeStatus::REVERSED,
                                    'updated_by' => getUserCode(),
                                    'updated_at' => getDateTimeNow(),
                                ]);
                            break;

                        case PaymentTypeCode::ONLINE_TRANSFER_PAYMENT_CODE:
                            OnlineTransferPayment::where('mode_of_payment_code', $mode_of_payment->code)
                                ->update([
                                    'status' => MultiPurposeStatus::REVERSED,
                                    'updated_by' => getUserCode(),
                                    'updated_at' => getDateTimeNow(),
                                ]);
                            break;
                        default:
                            # code...
                            break;
                    }
                }


                $customer = Customer::where('code', $paymentReceipt->customer_code, $mode_of_payment->payment_receipt_code)->first();
                if ($customer) {
                    $customer->update([
                        'credit_amount' => $customer['credit_amount'] + $paymentReceipt->settled_amount +  $totalPayOff,
                        'received_amount' => ($over + $return) == 0 ? $customer['received_amount'] - $paymentReceipt['total_amount'] : $customer['received_amount'] - ($paymentReceipt->total_amount),
                        //'received_amount' => ($over + $return) == 0 ? $customer['received_amount'] - $paymentReceipt['total_amount'] : $customer['received_amount'] - ($paymentReceipt->total_amount - ($over + $return)),
                        'over_payment' => $customer['over_payment'] ? ($customer['over_payment'] + $over) - $paymentReceipt->over_payment : $customer['over_payment'] - $paymentReceipt->over_payment,
                        'return_amount' => $customer['return_amount'] + $return,
                        //'received_amount' => $customer['received_amount'] - $paymentReceipt->settled_amount,
                        'updated_by' => getUserCode(),
                        'updated_at' => getDateTimeNow()
                    ]);
                }
            }

            $invoicePaymentReceipt = InvoicePaymentReceipt::where('payment_receipt_code', '=', $paymentReceipt->code)
                ->where('is_active', '=', 1)->get();

            foreach ($invoicePaymentReceipt as $invoice_payment_receipt) {

                $invoice = Invoice::where('code', $invoice_payment_receipt['invoice_code'])->first();

                if ($invoice) {
                    $totalPaidAmount = $invoice['paid_amount'] - $invoice_payment_receipt['paid_amount'] -  $invoice_payment_receipt['pay_off'];
                    $payOff = $invoice['pay_off'] - $invoice_payment_receipt['pay_off'];
                    //Status cannot be changed to reversed, because the invoice may has paid by another receipt.
                    $invoice->update([
                        'paid_amount' => $totalPaidAmount,
                        'pay_off'=>$payOff,
                        'paid_status' => $totalPaidAmount == 0 ? PaymentStatus::PAYMENT_NOT_DONE : PaymentStatus::PAYMENT_PARTIAL,
                        'updated_by' => getUserCode(),
                        'updated_at' => getDateTimeNow(),
                    ]);
                }
                $invoice_payment_receipt->update([
                    'status' => MultiPurposeStatus::REVERSED,
                    'updated_by' => getUserCode(),
                    'updated_at' => getDateTimeNow(),

                ]);
                // return response()->json([
                //     'status' => 200,
                //     'message' => $invoice
                // ]);
            }

            //  $cheques = $request->selected;

            //  foreach ($cheques as $cheque) {
            //      $chequePayment = ChequePayment::select('id', 'is_active')->where('code', $cheque)
            //      ->where('is_active', '=', 1)->first();

            //      $chequePayment->update([
            //          'status' =>$status,
            //      ]);
            //      if($status===0){
            //          $customer = Customer::where('code', $chequePayment->customer_code)->first();
            //          $customer->update([
            //              'credit_amount' => $customer['credit_amount'] - ($chequePayment->amount),
            //          ]);
            //      }
            //  }



            DB::commit();
            return response()->json([
                'status' => 200,
                'message' => $paymentReceipt
            ]);

        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    public function reversalOnlyPayOff(Request $request)
    {

        try {
            $paymentReceiptCode = $request->transactionCode;

            $paymentReceipt = PaymentReceipt::where('code', '=', $paymentReceiptCode)
                ->where('status', '<>', MultiPurposeStatus::REVERSED)
                ->where('is_active', '=', 1)->first();

            if (!$paymentReceipt) {
                return response()->json([
                    'status' => 200,
                    'message' => 'Payment Receipt Code - ' . $paymentReceiptCode . ' Not Found'
                ]);
            }

            //If payment Receipt found in the table

            DB::beginTransaction();

            $paymentReceipt->update([
                'status' => MultiPurposeStatus::REVERSED,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);

            $invoicePaymentReceipt = InvoicePaymentReceipt::where('payment_receipt_code', '=', $paymentReceipt->code)
            ->where('is_active', '=', 1)->get();

            $totalPayOff = $invoicePaymentReceipt->sum('pay_off');

            foreach ($invoicePaymentReceipt as $invoice_payment_receipt) {

                $invoice = Invoice::where('code', $invoice_payment_receipt['invoice_code'])->first();
                $payOff = $invoice_payment_receipt['pay_off'];

                if ($invoice) {
                    $totalPaidAmount = $invoice['paid_amount'] - $invoice_payment_receipt['paid_amount'] - $payOff;

                    //Status cannot be changed to reversed, because the invoice may has paid by another receipt.
                    $invoice->update([
                        'paid_amount' => $totalPaidAmount,
                        'pay_off' => $invoice['pay_off'] -  $payOff,
                        'paid_status' => $totalPaidAmount == 0 ? PaymentStatus::PAYMENT_NOT_DONE : PaymentStatus::PAYMENT_PARTIAL,
                        'updated_by' => getUserCode(),
                        'updated_at' => getDateTimeNow(),
                    ]);
                }
                $invoice_payment_receipt->update([
                    'status' => MultiPurposeStatus::REVERSED,
                    'updated_by' => getUserCode(),
                    'updated_at' => getDateTimeNow(),

                ]);

            }

            $customer = Customer::where('code', $paymentReceipt->customer_code)->first();
            if ($customer) {
                $customer->update([
                    'credit_amount' => $customer['credit_amount'] + $paymentReceipt->settled_amount + $totalPayOff,
                    'updated_by' => getUserCode(),
                    'updated_at' => getDateTimeNow()
                ]);
            }


            DB::commit();
            return response()->json([
                'status' => 200,
                'message' => $paymentReceipt
            ]);

        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }


    public function addInvoicePaymentForPaymentReceipt($paymentReceipt, $selectedInvoice, $existingInvoice)
    {
        try {
            DB::beginTransaction();

            $payment_code = TransactionCode::INVOICE_PAYMENT_CODE;
            $cus_code = InvoicePaymentReceipt::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $payOff = $selectedInvoice['payOff'] ?? 0;

            $invoicePaymentReceipt = InvoicePaymentReceipt::create([
                'code' => $payment_code . $max_id,
                'payment_receipt_code' => $paymentReceipt->code,
                'invoice_code' => $selectedInvoice['code'],
                'pay_off'=> $payOff,
                'paid_amount' => $selectedInvoice['paymentAmount'],
                'date_time' => $paymentReceipt['payment_date_time'],
                'invoice_total' => $selectedInvoice['totalAmount'],
                'outstanding' => $selectedInvoice ? ($selectedInvoice['totalAmount'] - ($existingInvoice['paid_amount'] + $selectedInvoice['paymentAmount'] + $payOff)) : ($selectedInvoice['totalAmount']),
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);

            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    public function addCashPayment($modeOfPayment, $modeOfPaymentCode, $paymentReceipt, $customer)
    {
        try {
            DB::beginTransaction();

            $payment_code = TransactionCode::CASH_PAYMENT_CODE;
            $cus_code = CashPayment::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $cashPayment = CashPayment::create([
                'code' => $payment_code . $max_id,
                'receipt_code' => $paymentReceipt['code'],
                'mode_of_payment_code' => $modeOfPaymentCode,
                'customer_code' => $customer['code'] ?? null,
                'amount' => $modeOfPayment['amount'],
                'date_time' => $paymentReceipt['payment_date_time'],
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),

            ]);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    public function addOverPayment($modeOfPayment, $modeOfPaymentCode, $paymentReceipt, $customer)
    {
        try {
            DB::beginTransaction();

            $payment_code = TransactionCode::OVER_PAYMENT_CODE;
            $cus_code = OverPayment::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $overPayment = OverPayment::create([
                'code' => $payment_code . $max_id,
                'receipt_code' => $paymentReceipt['code'],
                'mode_of_payment_code' => $modeOfPaymentCode,
                'customer_code' => $customer['code'] ?? null,
                'amount' => $modeOfPayment['amount'],
                'customer_code' => $customer['code'] ?? 'sajaan',
                'date_time' => $paymentReceipt['payment_date_time'],
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),

            ]);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    public function addReturnAmount($modeOfPayment, $modeOfPaymentCode, $paymentReceipt, $customer)
    {
        try {
            DB::beginTransaction();

            $payment_code = TransactionCode::RETURN_AMOUNT_CODE;
            $cus_code = ReturnAmount::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $returnAmount = ReturnAmount::create([
                'code' => $payment_code . $max_id,
                'receipt_code' => $paymentReceipt['code'],
                'mode_of_payment_code' => $modeOfPaymentCode,
                'customer_code' => $customer['code'] ?? null,
                'amount' => $modeOfPayment['amount'],
                'customer_code' => $customer['code'] ?? null,
                'date_time' => $paymentReceipt['payment_date_time'],
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),

            ]);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    public function addChequePayment($modeOfPayment, $modeOfPaymentCode, $paymentReceipt, $customer)
    {
        try {
            DB::beginTransaction();

            $payment_code = TransactionCode::CHEQUE_PAYMENT_CODE;
            $cus_code = ChequePayment::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;


            $cheque_Payment = ChequePayment::create([
                'code' => $payment_code . $max_id,
                'receipt_code' => $paymentReceipt['code'],
                'mode_of_payment_code' => $modeOfPaymentCode,
                'bank_code' => $modeOfPayment['chequePayment']['bank'],
                'branch_code' => $modeOfPayment['chequePayment']['branchCode'],
                'customer_code' => $customer['code'] ?? null,
                'number' => $modeOfPayment['chequePayment']['chequeNumber'],
                'deposit_date' => $modeOfPayment['chequePayment']['chequeDate'],
                'amount' => $modeOfPayment['amount'],
                'date_time' => $paymentReceipt['payment_date_time'],
                'remarks' => $modeOfPayment['chequePayment']['remarks'] ?? null,
                'status' => ChequeStatusCode::CHEQUE_IN_HAND,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    public function addBankPayment($modeOfPayment, $modeOfPaymentCode, $paymentReceipt, $customer)
    {
        try {
            DB::beginTransaction();

            $payment_code = TransactionCode::BANK_PAYMENT_CODE;
            $cus_code = BankPayment::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $bankPayment = BankPayment::create([
                'code' => $payment_code . $max_id,
                'receipt_code' => $paymentReceipt['code'],
                'mode_of_payment_code' => $modeOfPaymentCode,
                'bank_code' => $modeOfPayment['chequePayment']['bank'],
                //$modeOfPayment['bank']['code'],
                'customer_code' => $customer['code'] ?? null,
                'reference_number' => $modeOfPayment['bankDeposit']['refNumber'],
                'amount' => $modeOfPayment['amount'],
                'date_time' => $paymentReceipt['payment_date_time'],
                'date' => $modeOfPayment['bankDeposit']['date'],
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);
            DB::commit();
            return response()->Json(['status' => 200, 'message' => 'Bank Payment Updated']);
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    public function addOnlineTransferPayment($modeOfPayment, $modeOfPaymentCode, $paymentReceipt, $customer)
    {
        try {
            DB::beginTransaction();

            $payment_code = TransactionCode::ONLINE_TRANSFER_PAYMENT_CODE;
            $cus_code = OnlineTransferPayment::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $onlineTransferPayment = OnlineTransferPayment::create([
                'code' => $payment_code . $max_id,
                'receipt_code' => $paymentReceipt['code'],
                'mode_of_payment_code' => $modeOfPaymentCode,
                'bank_code' => $modeOfPayment['onlineTransfer']['bank'],
                //$modeOfPayment['bank']['code'],
                'customer_code' => $customer['code'] ?? null,
                'transfer_id' => $modeOfPayment['onlineTransfer']['transferId'],
                'amount' => $modeOfPayment['amount'],
                'date_time' => $paymentReceipt['payment_date_time'],
                'remarks' => $modeOfPayment['remarks'] ?? null,
                'transfer_date' => $modeOfPayment['onlineTransfer']['transferDate'] ?? null,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);
            DB::commit();
            return response()->Json(['status' => 200, 'message' => 'Bank Payment Updated']);
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    public function addCardPayment($modeOfPayment, $modeOfPaymentCode, $paymentReceipt, $customer)
    {
        try {
            DB::beginTransaction();

            $payment_code = TransactionCode::CARD_PAYMENT_CODE;
            $cus_code = CardPayment::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $CardPayment = CardPayment::create([
                'code' => $payment_code . $max_id,
                'receipt_code' => $paymentReceipt['code'],
                'mode_of_payment_code' => $modeOfPaymentCode,
                'bank_code' => $modeOfPayment['chequePayment']['bank'],
                'customer_code' => $customer['code'] ?? null,
                'card_number' => $modeOfPayment['cardPayment']['cardNumber'],
                'amount' => $modeOfPayment['amount'],
                'date_time' => $paymentReceipt['payment_date_time'],
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),

            ]);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }




    public function edit($id)
    {
        //
    }


    public function update(Request $request, $id)
    {
        try {

            DB::beginTransaction();

            $paymentReceipt = $request->paymentReceipt;
            $paymentReceipt = PaymentReceipt::where('code', $id)->where('is_active', '=', 1)->first();

            $paymentReceipt->update([
                'customer_code' => $paymentReceipt['customer']['code'],
                'total_amount' => $paymentReceipt['amount'],
                'status' => $paymentReceipt['status'],
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow()
            ]);

            DB::commit();
            return response(['status' => 200, 'message' => 'paymentReceipt updated']);
        } catch (\Exception $e) {
            DB::rollback();
            throw new Exception($e);
        }
    }


    public function destroy($id)
    {
        //
    }
}
