<?php

namespace App\Http\Controllers\Payment_Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Enums\TransactionCode;
use App\Models\PaymentReceipt_Models\OverPayment;
use Exception;
use Illuminate\Support\Facades\DB;

class OverPaymentController extends Controller
{
    public function index()
    {
        try {
            $overPayment  = OverPayment::select('code', 'amount','receipt_code','mode_of_payment_code')->where('is_active', '=', 1)->get();
            return response()->json(['status' => 200, 'OverPayment' =>  $overPayment]);
        } catch (\Exception $e) {

            throw new Exception($e);
        }
    }


    public function show($id)
    {
        try {
            $overPayment  = OverPayment::select('code', 'amount','receipt_code','mode_of_payment_code')->where('code', $id)->where('is_active', '=', 1)->first();
            return response()->json(['status' => 200, 'OverPayment' =>  $overPayment]);
        } catch (\Exception $e) {
            
            throw new Exception($e);
        }
    }

    public function create()
    {
        //
    }

    public function store(Request $request)
    {
        try {

            DB::transaction(function () {
            });
            DB::beginTransaction();

            $payment_code = TransactionCode::OVER_PAYMENT_CODE;
            $cus_code = OverPayment::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $overPayment = OverPayment::create([

                'code' => $payment_code.$max_id,
                'amount'=>$request->Paid_amount,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),

            ]);
            DB::commit();

            return response()->json(['status' => 200, 'message' => "Payment  created"]);
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    public function update(Request $request, $id)
    {
        try {

            DB::transaction(function () {
            });
            DB::beginTransaction();
            $cashPayment = OverPayment::where('code', $id)->first();
            $cashPayment->update([
                'amount' => $request->amount,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow()
            ]);
            DB::commit();
            return response()->json(['status' => 200, 'message' => "Payment  updated"]);
        } catch (\Exception $e) {

            DB::rollBack();
            throw new Exception($e);
        }
    }

}
