<?php

namespace App\Http\Controllers\Payment_Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\PaymentReceipt_Models\CashPayment;
use App\Enums\TransactionCode;
use Exception;
use Illuminate\Support\Facades\DB;

class CashPaymentController extends Controller
{
    public function index()
    {
        try {
            $cashPayment  = CashPayment::select('code', 'bill_amount','Paid_amount','balance')->where('is_active', '=', 1)->get();
            return response()->json(['status' => 200, 'CashPayment' =>  $cashPayment]);
        } catch (\Exception $e) {

            throw new Exception($e);
        }
    }

    public function show($id)
    {
        try {
            $cashPayment  = CashPayment::select('code', 'bill_amount','Paid_amount','balance')->where('code', $id)->where('is_active', '=', 1)->first();
            return response()->json(['status' => 200, 'CashPayment' =>  $cashPayment]);
        } catch (\Exception $e) {
            
            throw new Exception($e);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        try {

            DB::transaction(function () {
            });
            DB::beginTransaction();

            $payment_code = TransactionCode::CASH_PAYMENT_CODE;
            $cus_code = CashPayment::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $cashPayment = CashPayment::create([

                'code' => $payment_code.$max_id,
                'bill_amount' => $request->bill_amount,
                'Paid_amount'=>$request->Paid_amount,
                //'balance'=>$request->balance,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),

            ]);
            DB::commit();

            return response()->json(['status' => 200, 'message' => "Payment  created"]);
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    public function edit($id)
    {
        //
    }


    public function update(Request $request, $id)
    {
        try {

            DB::transaction(function () {
            });
            DB::beginTransaction();
            $cashPayment = CashPayment::where('code', $id)->first();
            $cashPayment->update([
                'bill_amount' => $request->bill_amount,
                'Paid_amount'=>$request->Paid_amount,
                'balance'=>$request->balance,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow()
            ]);
            DB::commit();
            return response()->json(['status' => 200, 'message' => "Payment  updated"]);
        } catch (\Exception $e) {

            DB::rollBack();
            throw new Exception($e);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {
            $cashPayment = CashPayment::select('id', 'is_active')->where('code', $id)->where('is_active', '=', 1)->first();
            $cashPayment->update([
                'is_active' => 0
            ]);
            return response()->json([
                'status' => 204,
                'message' => "Payment  - Deleted"
            ]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }
}
