<?php

namespace App\Http\Controllers\Payment_Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Enums\TransactionCode;
use App\Models\PaymentReceipt_Models\CardPayment;
use Exception;
use Illuminate\Support\Facades\DB;

class CardPaymentController extends Controller
{

    public function index()
    {
        try {
            $cardPayment  = CardPayment::select('code','payment_receipt_code', 'bank_code','card_number','amount')->where('is_active', '=', 1)->get();
            return response()->json(['status' => 200, 'cardPayment' =>  $cardPayment]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    public function show($id)
    {
        try {
            $cardPayment  = CardPayment::select('code', 'payment_receipt_code','bank_code','card_number','amount')
            ->where('code', $id)->where('is_active', '=', 1)->first();
            return response()->json(['status' => 200, 'cardPayment' =>  $cardPayment]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        try {


            DB::beginTransaction();

            $payment_code = TransactionCode::CARD_PAYMENT_CODE;
            $cus_code = CardPayment::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $CardPayment = CardPayment::create([

                'code' => $payment_code.$max_id,
                'bank_code' => $request->bank_code,
                'card_number'=>$request->Card_number,
                'amount'=>$request->amount,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),

            ]);
            DB::commit();

            return response()->json(['status' => 200, 'message' => "Payment  created"]);
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    public function edit($id)
    {
        //
    }


    public function update(Request $request, $id)
    {
        try {


            DB::beginTransaction();
            $cardPayment = CardPayment::where('code', $id)->first();
            $cardPayment->update([
                'bank_code' => $request->bank_code,
                'card_number'=>$request->card_number,
                'amount'=>$request->amount,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow()
            ]);
            DB::commit();
            return response()->json(['status' => 200, 'message' => "Payment  updated"]);
        } catch (\Exception $e) {

            DB::rollBack();
            throw new Exception($e);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {
            $CardPayment = CardPayment::select('id', 'is_active')->where('code', $id)->where('is_active', '=', 1)->first();
            $CardPayment->update([
                'is_active' => 0
            ]);
            return response()->json([
                'status' => 204,
                'message' => "Payment  - Deleted"
            ]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

}
