<?php

namespace App\Http\Controllers\PaymentVoucher_Controllers;

use App\Http\Controllers\Controller;
use App\Enums\ChequeStatusCode;
use App\Models\PaymentVoucher_Models\SupplierChequePayment;
use App\Models\PaymentVoucher_Models\SupplierModeOfPayment;
use App\Models\PaymentVoucher_Models\PaymentVoucher;
use App\Models\Supplier_Models\Supplier;
use Exception;
use Illuminate\Http\Request;

class SupplierChequePaymentController extends Controller
{

    /**
     * index
     * Authro:  Suhail Jamaldeen
     * Version: 01
     * Date: 12.01.2023
     * Logic: Get the supplier cheque payment for the current location and by status.
     * The request should have the status as well.
     * @param  mixed $request
     * @return void
     */
    public function index(Request $request)
    {
        try {
            $currentLocation = getCurrentLocationCode($request);
            $chequePayment = SupplierChequePayment::select(
                'code',
                'stock_location_code',
                'supplier_mode_of_payment_code',
                'bank_code',
                'number',
                'deposit_date',
                'amount',
                'remarks'
            )->with([
                    'supplierModeOfPayment' => function ($query) {
                        $query->where('is_active', '=', 1);
                    },
                    'supplierModeOfPayment.paymentVoucher' => function ($query) use ($currentLocation) {
                        $query
                            ->where('is_active', '=', 1)
                            ->where('stock_location_code', '=', $currentLocation);
                    },
                    'supplierModeOfPayment.paymentVoucher.supplier' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->where('is_active', '=', 1)
                ->Where('status', '=', $request->status)
                ->get();

            return response()->json([
                'status' => 200,
                'chequePayment' => $chequePayment
            ]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }


    /**
     * show
     * Author: Suhail Jamaldeen
     * Version: 01
     * Date: 16.01.2023
     * Logic: Get the supplier cheque payments details by id
     * @param  mixed $id
     * @return void
     */
    public function show($id)
    {
        try {
            $supplierChequePayment = SupplierChequePayment::select(
                'code',
                'stock_location_code',
                'supplier_mode_of_payment_code',
                'bank_code',
                'branch_code',
                'amount',
                'number',
                'deposit_date',
                'remarks',

            )
                ->with([
                    'bank' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'supplierModeOfPayment' => function ($query) {
                        $query->where('is_active', '=', 1);
                    },
                    'supplierModeOfPayment.paymentVoucher' => function ($query) {
                        $query->where('is_active', '=', 1);
                    },
                    'supplierModeOfPayment.paymentVoucher.supplier' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->where('code', $id)
                ->where('is_active', '=', 1)
                ->first();

            return response([
                'status' => 200,
                'chequePayment' => $supplierChequePayment
            ]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }
    public function chequeProcess(Request $request, $status)
    {
        try {
            $cheques = $request->selected;

            foreach ($cheques as $cheque) {
                $chequePayment = SupplierChequePayment::select(
                    'supplier_cheque_payments.code',
                    'supplier_cheque_payments.amount',
                    'suppliers.code AS supplierCode',
                    'supplier_cheque_payments.status'
                )
                    ->join(
                        'supplier_mode_of_payments',
                        'supplier_mode_of_payments.code',
                        '=',
                        'supplier_cheque_payments.supplier_mode_of_payment_code'
                    )
                    ->join(
                        'payment_vouchers',
                        'payment_vouchers.code',
                        '=',
                        'supplier_mode_of_payments.payment_voucher_code'
                    )
                    ->join(
                        'suppliers',
                        'suppliers.code',
                        '=',
                        'payment_vouchers.supplier_code'
                    )
                    ->where('supplier_cheque_payments.code', $cheque)

                    ->first();
                SupplierChequePayment::where('code', $cheque)
                    ->first()
                    ->update([
                        'status' => $status,
                        'updated_by' => getUserCode(),
                        'updated_at' => getDateTimeNow()
                    ]);


                if ($status == ChequeStatusCode::CHEQUE_RETURNED) {
                    $supplier = Supplier::where('code', $chequePayment['supplierCode'])
                        ->first();
                    $supplier->update([
                        'cheque_return_amount' => $supplier['cheque_return_amount'] + ($chequePayment->amount),
                        'updated_by' => getUserCode(),
                        'updated_at' => getDateTimeNow()
                    ]);
                }
            }


            return response()->json([
                'status' => 200,
                'message' => "updated"
            ]);

        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    public function chequePayment(Request $request)
    {
        try {
            $chequePayment = SupplierChequePayment::select(
                'supplier_cheque_payments.code',
                'supplier_cheque_payments.supplier_mode_of_payment_code',
                'suppliers.name',
                'suppliers.phone_1',
                'supplier_cheque_payments.bank_code',
                'supplier_cheque_payments.number',
                'supplier_cheque_payments.deposit_date',
                'supplier_cheque_payments.amount'
            )
                ->join(
                    'supplier_mode_of_payments',
                    'supplier_mode_of_payments.code',
                    '=',
                    'supplier_cheque_payments.supplier_mode_of_payment_code'
                )
                ->join(
                    'payment_vouchers',
                    'payment_vouchers.code',
                    '=',
                    'supplier_mode_of_payments.payment_voucher_code'
                )
                ->join(
                    'suppliers',
                    'suppliers.code',
                    '=',
                    'payment_vouchers.supplier_code'
                )
                ->Where('supplier_cheque_payments.status', '=', $request->status)
                ->get();

            return response()->json([
                'status' => 200,
                'chequePayment' => $chequePayment
            ]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }


    public function chequeCancel($code)
    {
        try {
            $chequePayment = SupplierChequePayment::select('code', 'is_active', 'supplier_mode_of_payment_code')->where('code', $code)->where('is_active', '=', 1)->first();
            $chequePayment->update([
                'is_active' => 0
            ]);
            $supplier_mode_of_payment = SupplierModeOfPayment::select('code', 'is_active', 'payment_voucher_code')->where('code', '=', $chequePayment->supplier_mode_of_payment_code)->where('is_active', '=', 1)->first();
            $supplier_mode_of_payment->update([
                'is_active' => 0
            ]);
            $payment_voucher = PaymentVoucher::select('code', 'is_active')->where('code', '=', $supplier_mode_of_payment->payment_voucher_code)->where('is_active', '=', 1)->first();
            $payment_voucher->update([
                'is_active' => 0
            ]);

            return response()->json([
                'status' => 200,
                'message' => "Cheque Cancel"
            ]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
