<?php

namespace App\Http\Controllers\PaymentVoucher_Controllers;

use App\Http\Controllers\Controller;
use App\Models\PaymentVoucher_Models\SupplierBankPayment;
use Exception;
use Illuminate\Http\Request;

class SupplierBankPaymentController extends Controller
{

    public function index()
    {
        try {
            $paymentVoucher =  SupplierBankPayment::select('code', 'supplier_mode_of_payment_code',  'bank_code', 'amount', 'reference_number', 'date')
                ->with(['bank' => function ($query) {
                    $query->where('is_active', '=', 1);
                }])
                ->with(['supplierModeOfPayment' => function ($query) {
                    $query->where('is_active', '=', 1);
                }])
                ->where('is_active', '=', 1)
                ->orderBy('created_at', 'DESC')
                ->get();

            return response(['status' => 200, 'paymentVoucher' => $paymentVoucher]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    public function show($id)
    {
        try {
            $paymentVoucher =  SupplierBankPayment::select('code', 'supplier_mode_of_payment_code',  'bank_code', 'amount AS PaidAmount', 'reference_number', 'date')
                ->with(['bank' => function ($query) {
                    $query->where('is_active', '=', 1);
                }])
                ->with(['supplierModeOfPayment' => function ($query) {
                    $query->where('is_active', '=', 1);
                }])
                ->where('code', $id)->where('is_active', '=', 1)
                ->orderBy('created_at', 'DESC')
                ->first();

            return response(['status' => 200, 'paymentVoucher' => $paymentVoucher]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
