<?php

namespace App\Http\Controllers\PaymentVoucher_Controllers;

use App\Enums\PaymentStatus;
use App\Enums\PaymentTypeCode;
use App\Enums\MultiPurposeStatus;
use App\Enums\TransactionCode;
use App\Enums\ChequeStatusCode;
use App\Http\Controllers\Controller;
use App\Models\PaymentVoucher_Models\GrnPaymentVoucher;
use App\Models\PaymentVoucher_Models\PaymentVoucher;
use App\Models\PaymentVoucher_Models\SupplierBankPayment;
use App\Models\PaymentVoucher_Models\SupplierGrnPayment;
use App\Models\PaymentVoucher_Models\SupplierCardPayment;
use App\Models\PaymentVoucher_Models\SupplierOverPayment;
use App\Models\PaymentVoucher_Models\SupplierCashPayment;
use App\Models\PaymentVoucher_Models\SupplierReturnAmount;
use App\Models\PaymentVoucher_Models\SupplierChequePayment;
use App\Models\PaymentVoucher_Models\SupplierModeOfPayment;
use App\Models\PaymentVoucher_Models\SupplierOnlineTransfer;
use App\Models\Stock_Models\Grn;
use App\Models\Supplier_Models\Supplier;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class PaymentVoucherController extends Controller
{
    public function index(Request $request)
    {
        try {
            $paymentVoucher = PaymentVoucher::query()
                ->with([
                    'supplier' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                // ->with([
                //     'user' => function ($query) {
                //         $query->where('is_active', '=', 1);
                //     }
                // ])
                ->with([
                    'stockLocation' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->where('is_active', '=', 1)
                ->orderBy('code', 'DESC')
                ->get();
            return response()->Json([
                'status' => 200,
                'paymentVoucher' => $paymentVoucher
            ]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    /**
     * show
     * Author : fathima sajana
     * Date : 2022.10.11
     * Version : 2
     * Logic : showing paymentvoucher  with selected grndetails
     *
     * Author : Suhail Jamaldeen
     * Date : 2022.12.14
     * Version : 2
     * Logic : Added Status
     * @param  mixed $id
     * @return void
     */

    public function show($id)
    {
        try {
            $paymentVoucher = PaymentVoucher::select(
                'code',
                'supplier_code',
                'total_amount',
                'settled_amount',
                'over_payment',
                'remarks',
                'payment_date_time',
                'status',
                'created_by'
            )
                ->with([
                    'supplier' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'supplierModeOfPayments' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'user' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                // ->with(['grnPaymentVoucher' => function($query){
                //     $query->select('code', 'payment_voucher_code')->where('is_active', '=', 1);
                // }])
                ->with([
                    'stockLocation' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->where('code', $id)
                ->where('is_active', '=', 1)
                ->first();

            if ($paymentVoucher) {

                $cash = SupplierCashPayment::select('amount')
                ->where('voucher_code', $paymentVoucher->code)
                ->where('is_active', '=', 1)
                ->get();

            $overPay = SupplierOverPayment::select('amount')
                ->where('voucher_code', $paymentVoucher->code)
                ->where('is_active', '=', 1)
                ->get();

            $returnAmnt = SupplierReturnAmount::select('amount')
                ->where('voucher_code', $paymentVoucher->code)
                ->where('is_active', '=', 1)
                ->get();

            $cheque = SupplierChequePayment::select('number', 'bank_code','branch_code', 'deposit_date', 'amount')
            ->with([
                'bank' => function ($query) {
                    $query->select('code','name')
                    ->where('is_active', '=', 1);
                }
            ])
                ->where('voucher_code', $paymentVoucher->code)
                ->where('is_active', '=', 1)
                ->get();

            $bank = SupplierBankPayment::select('bank_code', 'reference_number', 'date', 'amount')
            ->with([
                'bank' => function ($query) {
                    $query->select('code','name')
                    ->where('is_active', '=', 1);
                }
            ])  
            ->where('voucher_code', $paymentVoucher->code)
                ->where('is_active', '=', 1)
                ->get();

            $onlineTransfer = SupplierOnlineTransfer::select('bank_code', 'transfer_id', 'transfer_date', 'amount')
            ->with([
                'bank' => function ($query) {
                    $query->select('code','name')
                    ->where('is_active', '=', 1);
                }
            ])  
                ->where('voucher_code', $paymentVoucher->code)
                ->where('is_active', '=', 1)
                ->get();

            $card = SupplierCardPayment::select('bank_code', 'card_number', 'amount', 'created_at')
            ->with([
                'bank' => function ($query) {
                    $query->select('code','name')
                    ->where('is_active', '=', 1);
                }
            ])
            ->where('voucher_code', $paymentVoucher->code)
                ->where('is_active', '=', 1)
                ->get();

            $grnDetails = GrnPaymentVoucher::select('code', 'payment_voucher_code', 'grn_total', 'paid_amount', 'outstanding', 'grn_code')
                ->with([
                    'grn' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->where('payment_voucher_code', $paymentVoucher->code)
                ->where('is_active', '=', 1)
                ->get();


                return response()->Json([
                    'status' => 200,
                    'paymentVoucher' => $paymentVoucher,
                    'cashPayment' => $cash,
                    'overPayment' => $overPay,
                    'returnAmount' => $returnAmnt,
                    'chequePayment' => $cheque,
                    'bankPayment' => $bank,
                    'cardPayment' => $card,
                    'onlineTransfer' => $onlineTransfer,
                    'grnDetails' => $grnDetails
                ]);
            } else {
                return response()->Json([
                    'status' => 200,
                    'message' => 'Payment voucher code ' . $id . ' not found',

                ]);
            }
        } catch (\Exception $e) {
            throw new Exception($e);
            // return response(['status' => 500, 'message' => $e]);
        }
    }


    public function create()
    {
        //
    }


    public function store(Request $request)
    {

        try {
            DB::beginTransaction();
            $payment_code = TransactionCode::PAYMENT_VOUCHER_CODE;

            $stockLocationCode = getCurrentLocationCode($request);
            $locationPrefix = substr("$stockLocationCode", -2);
            $max_code = PaymentVoucher::select('code')
                ->where('stock_location_code', '=', $stockLocationCode)
                ->max('code');

            $max_id = $max_code == null || $max_code == '' ? config('global.code_value') + 1 : substr("$max_code",5) + 1;

            $paymentVoucher = PaymentVoucher::create([
                'code' => $payment_code . $locationPrefix .$max_id,
                'stock_location_code' => getCurrentLocationCode($request),
                'supplier_code' => $request['supplier']['code'] ?? null,
                'total_amount' => $request->totalAmount,
                'settled_amount' => $request->settledAmount,
                'over_payment' => ($request->totalAmount - $request->settledAmount),
                'status' => 1,
                //$request->payment['paidStatus'],
                'remarks' => $request->remarks,
                'payment_date_time' =>$request->paymentDateTime,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);
            $supplier = $request->supplier;

            $modeOfPayments = $request->supplierModeOfPayments;
            $paidByOverPayment = 0; // This set the values settled by over payment
            $paidByReturnPayment = 0;
            if ($paymentVoucher) {

                if (count($modeOfPayments) > 0) {
                    foreach ($modeOfPayments as $mode_of_payment) {
                        $modePayment_code = TransactionCode::PAYMENT_SUPPLIER_MODE_OF_PAYMENT;
                        $max_code = SupplierModeOfPayment::max('code');
                        $max_id = $max_code == null ? config('global.code_value') + 1 : substr("$max_code", 3) + 1;

                        $modeOfPayment = SupplierModeOfPayment::create([
                            'code' => $modePayment_code . $max_id,
                            'payment_voucher_code' => $paymentVoucher->code,
                            'payment_type_code' => $mode_of_payment['paymentType'],
                            'amount' => $mode_of_payment['amount'],
                            'created_by' => getUserCode(),
                            'created_at' => getDateTimeNow(),
                            'updated_by' => getUserCode(),
                            'updated_at' => getDateTimeNow(),
                        ]);
                        if ($mode_of_payment) {

                            if ($modeOfPayment->payment_type_code == PaymentTypeCode::CASH_PAYMENT_CODE ) {
                                $this->addCashPayment($mode_of_payment, $modeOfPayment->code, $paymentVoucher, $supplier);
                            } else if ($modeOfPayment->payment_type_code == PaymentTypeCode::OVER_PAYMENT_CODE) {
                                $paidByOverPayment = $paidByOverPayment+ $modeOfPayment['amount'];
                                $this->addOverPayment($mode_of_payment, $modeOfPayment->code, $paymentVoucher,$supplier);
                            } else if ($modeOfPayment->payment_type_code == PaymentTypeCode::RETURN_AMOUNT_CODE) {
                                $paidByReturnPayment = $paidByReturnPayment + $modeOfPayment['amount'];
                                $this->addReturnAmount($mode_of_payment, $modeOfPayment->code, $paymentVoucher, $supplier);
                            } else if ($modeOfPayment->payment_type_code == PaymentTypeCode::CHEQUE_PAYMENT_CODE) {
                                $this->addChequePayment($mode_of_payment, $modeOfPayment->code, $paymentVoucher, $supplier,$request);
                            } elseif ($modeOfPayment->payment_type_code == PaymentTypeCode::BANK_PAYMENT_CODE) {
                                $this->addBankPayment($mode_of_payment, $modeOfPayment->code, $paymentVoucher, $supplier);
                            } elseif ($modeOfPayment->payment_type_code == PaymentTypeCode::CARD_PAYMENT_CODE) {
                                $this->addCardPayment($mode_of_payment, $modeOfPayment->code, $paymentVoucher, $supplier);
                            } elseif ($modeOfPayment->payment_type_code == PaymentTypeCode::ONLINE_TRANSFER_PAYMENT_CODE) {
                                $this->addOnlineTransferPayment($mode_of_payment, $modeOfPayment->code, $paymentVoucher, $supplier);
                            }

                        }
                    }


                    $supplier = Supplier::where('code', $paymentVoucher->supplier_code)->first();
                    if ($supplier) {
                        $supplier->update([
                            'grn_total' => $supplier['grn_total'],
                            'received_amount' => ($supplier['received_amount'] + $paymentVoucher['total_amount']) - ($paidByOverPayment + $paidByReturnPayment),
                            'over_payment' => $supplier['over_payment'] + ($request->totalAmount - ($request->settledAmount + $paidByOverPayment)),
                            'return_amount' => $supplier['return_amount'] - $paidByReturnPayment,
                            'debit_amount' => $supplier['debit_amount'] - $request->settledAmount,
                            'updated_by' => getUserCode(),
                            'updated_at' => getDateTimeNow()
                        ]);
                    }
                }
                $selectedGrns = $request->grn;
                foreach ($selectedGrns as $selectedGrn) {
                    $existingGrn = Grn::where('code', $selectedGrn['code'])->first();
                    $this->addGrnPaymentVoucher($paymentVoucher, $selectedGrn, $existingGrn);

                    //Update the grn table to identify how much is paid pof the grn value
                    if ($existingGrn) {
                        $paidStatus = PaymentStatus::PAYMENT_PARTIAL;
                        $totalPaidAmount = $existingGrn['paid_amount'] + $selectedGrn['paymentAmount'];
                        if ($totalPaidAmount >= $existingGrn['total_amount']) {
                            $paidStatus = PaymentStatus::PAYMENT_COMPLETED;
                        }
                        $existingGrn->update([
                            'paid_amount' => $totalPaidAmount,
                            'paid_status' => $paidStatus,
                            'updated_by' => getUserCode(),
                            'updated_at' => getDateTimeNow(),
                        ]);
                    }
                }
            }
            DB::commit();
            return response()->Json(['status' => 200, 'message' => 'Payment Voucher Created']);
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    /**
     * reversal
     * Author : fathima sajana
     * Date : 2022.10.11
     * Version : 1
     * Logic : when supplier paid amount will be wrong , this function call to reverse that paid amount
     *
     * @param  mixed $request
     * @return void
     */
    public function reversal(Request $request)
    {
        try {
            $paymentVoucherCode = $request->transactionCode;

            $paymentVoucher = PaymentVoucher::where('code', '=', $paymentVoucherCode)
                ->where('is_active', '=', 1)->first();

            if ($paymentVoucher) {

                DB::beginTransaction();

                $paymentVoucher->update([
                    'status' => MultiPurposeStatus::REVERSED,
                    'updated_by' => getUserCode(),
                    'updated_at' => getDateTimeNow(),
                ]);


                $suppliermodeOfPayment = SupplierModeOfPayment::where('payment_voucher_code', '=', $paymentVoucherCode)
                    ->where('is_active', '=', 1)->get();
                $rtrn = 0;
                $over = 0;

                if (count($suppliermodeOfPayment) > 0) {
                    foreach ($suppliermodeOfPayment as $supplier_mode_of_payment) {
                        $supplier_mode_of_payment->update([
                            'status' => MultiPurposeStatus::REVERSED,
                            'updated_by' => getUserCode(),
                            'updated_at' => getDateTimeNow()
                        ]);

                        $paymentType = $supplier_mode_of_payment->payment_type_code;
                        switch ($paymentType) {
                            case PaymentTypeCode::CASH_PAYMENT_CODE:
                                SupplierCashPayment::where('supplier_mode_of_payment_code', $supplier_mode_of_payment->code)
                                    ->update([
                                        'status' => MultiPurposeStatus::REVERSED,
                                        'updated_by' => getUserCode(),
                                        'updated_at' => getDateTimeNow(),
                                    ]);
                                break;

                            case PaymentTypeCode::OVER_PAYMENT_CODE:
                                SupplierOverPayment::where('supplier_mode_of_payment_code', $supplier_mode_of_payment->code)
                                    ->update([
                                        'status' => MultiPurposeStatus::REVERSED,
                                        'updated_by' => getUserCode(),
                                        'updated_at' => getDateTimeNow(),
                                    ]);
                                $overPmnt = SupplierOverPayment::where('supplier_mode_of_payment_code', $supplier_mode_of_payment->code)
                                    ->first();
                                $over = $over + $overPmnt['amount'];
                                break;

                            case PaymentTypeCode::RETURN_AMOUNT_CODE:
                                SupplierReturnAmount::where('supplier_mode_of_payment_code', $supplier_mode_of_payment->code)
                                    ->update([
                                        'amount' => $supplier_mode_of_payment['amount'],
                                        'status' => MultiPurposeStatus::REVERSED,
                                        'updated_by' => getUserCode(),
                                        'updated_at' => getDateTimeNow(),
                                    ]);
                                $amnt = SupplierReturnAmount::where('supplier_mode_of_payment_code', $supplier_mode_of_payment->code)
                                    ->first();
                                $rtrn = $rtrn + $amnt['amount'];
                                break;

                            case PaymentTypeCode::CARD_PAYMENT_CODE:
                                SupplierCardPayment::where('supplier_mode_of_payment_code', $supplier_mode_of_payment->code)
                                    ->update([
                                        'status' => MultiPurposeStatus::REVERSED,
                                        'updated_by' => getUserCode(),
                                        'updated_at' => getDateTimeNow(),
                                    ]);
                                break;

                            case PaymentTypeCode::CHEQUE_PAYMENT_CODE:
                                SupplierChequePayment::where('supplier_mode_of_payment_code', $supplier_mode_of_payment->code)
                                    ->update([
                                        'status' => MultiPurposeStatus::REVERSED,
                                        'updated_by' => getUserCode(),
                                        'updated_at' => getDateTimeNow(),
                                    ]);
                                break;

                            case PaymentTypeCode::BANK_PAYMENT_CODE:
                                SupplierBankPayment::where('supplier_mode_of_payment_code', $supplier_mode_of_payment->code)
                                    ->update([
                                        'status' => MultiPurposeStatus::REVERSED,
                                        'updated_by' => getUserCode(),
                                        'updated_at' => getDateTimeNow(),
                                    ]);
                                break;

                            case PaymentTypeCode::ONLINE_TRANSFER_PAYMENT_CODE:
                                SupplierOnlineTransfer::where('supplier_mode_of_payment_code', $supplier_mode_of_payment->code)
                                    ->update([
                                        'status' => MultiPurposeStatus::REVERSED,
                                        'updated_by' => getUserCode(),
                                        'updated_at' => getDateTimeNow(),
                                    ]);
                                break;
                            default:
                                # code...
                                break;
                        }
                    }

                    $supplier = Supplier::where('code', $paymentVoucher->supplier_code)->first();
                    if ($supplier) {
                        $supplier->update([
                            'debit_amount' => $supplier['debit_amount'] + $paymentVoucher->settled_amount,
                            'over_payment' => $supplier['over_payment'] - $paymentVoucher->over_payment,
                            'received_amount' => $supplier['received_amount'] - ($paymentVoucher->total_amount - ($over + $rtrn)),
                            'over_payment' => $supplier['over_payment'] ? ($supplier['over_payment'] + $over) - $paymentVoucher->over_payment : $supplier['over_payment'] - $paymentVoucher->over_payment,
                            'return_amount' => $supplier['return_amount'] + $rtrn,
                            'updated_by' => getUserCode(),
                            'updated_at' => getDateTimeNow()
                        ]);
                    }
                }

                $grnPaymentVoucher = GrnPaymentVoucher::where('payment_voucher_code', '=', $paymentVoucher->code)
                    ->where('is_active', '=', 1)->get();

                foreach ($grnPaymentVoucher as $grn_payment_voucher) {

                    $grn = Grn::where('code', $grn_payment_voucher['grn_code'])->first();

                    if ($grn) {
                        $totalPaidAmount = $grn['paid_amount'] - $grn_payment_voucher['paid_amount'];

                        $grn->update([
                            'paid_amount' => $totalPaidAmount,
                            'status' => MultiPurposeStatus::REVERSED,
                            'paid_status' => PaymentStatus::PAYMENT_NOT_DONE,
                            'updated_by' => getUserCode(),
                            'updated_at' => getDateTimeNow(),
                        ]);
                    }
                }


                DB::commit();
                return response()->json([
                    'status' => 200,
                    'paymentVoucher' => $paymentVoucher
                ]);
            }
            else
            {
                return response()->json([
                    'status' => 200,
                    'message' => 'Payment Voucher Code - ' . $paymentVoucherCode . ' Not Found'
                ]);
            }
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    public function addGrnPaymentVoucher($paymentVoucher, $selectedGrn, $existingGrn)
    {
        try {
            DB::beginTransaction();

            $payment_code = TransactionCode::PAYMENT_GRN_PAYMENT_VOUCHER_CODE;
            $cus_code = GrnPaymentVoucher::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            // $grn = json_decode(json_encode($grn, true));
            // $grnCode = $grn[0]->code;
            // $grnTotal = $grn[0]->outstanding;

            $billPayment = GrnPaymentVoucher::create([
                'code' => $payment_code . $max_id,
                'payment_voucher_code' => $paymentVoucher->code,
                'grn_code' => $selectedGrn['code'],
                'grn_total' => $selectedGrn['totalAmount'],
                'paid_amount' => $selectedGrn['paymentAmount'],
                'date_time' => $paymentVoucher['payment_date_time'],
                'outstanding' => $selectedGrn? ($selectedGrn['totalAmount'] - ($existingGrn['paid_amount'] + $selectedGrn['paymentAmount'])) : ($selectedGrn['totalAmount']),
                //$grnTotal < $paymentVoucher->amount ? $grnTotal : $paymentVoucher->amount,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);

            DB::commit();
            return response()->Json(['status' => 200, 'message' => 'Bill Payment Updated']);
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    public function addCashPayment($modeOfPayment, $modeOfPaymentCode, $paymentVoucher, $supplier)
    {
        try {
            DB::beginTransaction();

            $payment_code = TransactionCode::PAYMENT_SUPPLIER_CASH_PAYMENT_CODE;
            $cus_code = SupplierCashPayment::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $cashPayment = SupplierCashPayment::create([

                'code' => $payment_code . $max_id,
                'voucher_code' => $paymentVoucher['code'],
                'supplier_mode_of_payment_code' => $modeOfPaymentCode,
                'supplier_code' => $supplier['code'] ?? null,
                'amount' => $modeOfPayment['amount'],
                'date_time' => $paymentVoucher['payment_date_time'],
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),

            ]);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    public function addOverPayment($modeOfPayment, $modeOfPaymentCode, $paymentVoucher, $supplier)
    {
        try {
            DB::beginTransaction();

            $payment_code = TransactionCode::PAYMENT_SUPPLIER_OVER_PAYMENT_CODE;
            $cus_code = SupplierOverPayment::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $supplierOverPayment = SupplierOverPayment::create([

                'code' => $payment_code . $max_id,
                'voucher_code' => $paymentVoucher['code'],
                'supplier_mode_of_payment_code' => $modeOfPaymentCode,
                'supplier_code' => $supplier['code'] ?? null,
                'amount' => $modeOfPayment['amount'],
                'date_time' => $paymentVoucher['payment_date_time'],
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),

            ]);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    public function addReturnAmount($modeOfPayment, $modeOfPaymentCode, $paymentVoucher, $supplier)
    {
        try {
            DB::beginTransaction();

            $payment_code = TransactionCode::PAYMENT_SUPPLIER_RETURN_AMOUNT_CODE;
            $cus_code = SupplierReturnAmount::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $returnAmount = SupplierReturnAmount::create([

                'code' => $payment_code . $max_id,
                'voucher_code' => $paymentVoucher['code'],
                'supplier_mode_of_payment_code' => $modeOfPaymentCode,
                'supplier_code' => $supplier['code'] ?? null,
                'amount' => $modeOfPayment['amount'],
                'date_time' => $paymentVoucher['payment_date_time'],
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),

            ]);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    public function addChequePayment($modeOfPayment, $modeOfPaymentCode, $paymentVoucher, $supplier,$request)
    {
        try {
            DB::beginTransaction();

            $payment_code = TransactionCode::PAYMENT_SUPPLIER_CHEQUE_PAYMENT_CODE;
            $cus_code = SupplierChequePayment::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $cheque_Payment = SupplierChequePayment::create([
                'code' => $payment_code . $max_id,
                'voucher_code' => $paymentVoucher['code'],
                'stock_location_code'=> getCurrentLocationCode($request),
                'supplier_mode_of_payment_code' => $modeOfPaymentCode,
                'bank_code' => $modeOfPayment['chequePayment']['bank'],
                'branch_code' => $modeOfPayment['chequePayment']['branchCode'],
                'number' => $modeOfPayment['chequePayment']['chequeNumber'],
                'deposit_date' => $modeOfPayment['chequePayment']['chequeDate'],
                'supplier_code' => $supplier['code'] ?? null,
                'amount' => $modeOfPayment['amount'],
                'date_time' => $paymentVoucher['payment_date_time'],
                'remarks' =>  $modeOfPayment['chequePayment']['remarks'],
                'status' => ChequeStatusCode::CHEQUE_IN_HAND,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    public function addBankPayment($modeOfPayment, $modeOfPaymentCode, $paymentVoucher, $supplier)
    {
        try {
            DB::beginTransaction();

            $payment_code = TransactionCode::PAYMENT_SUPPLIER_BANK_PAYMENT_CODE;
            $cus_code = SupplierBankPayment::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $bankPayment = SupplierBankPayment::create([

                'code' => $payment_code . $max_id,
                'voucher_code' => $paymentVoucher['code'],
                'supplier_mode_of_payment_code' => $modeOfPaymentCode,
                'bank_code' => $modeOfPayment['chequePayment']['bank'],
                //'bank_code' => null,
                //$modeOfPayment['bank']['code'],
                'reference_number' => $modeOfPayment['bankDeposit']['refNumber'],
                'supplier_code' => $supplier['code'] ?? null,
                'amount' => $modeOfPayment['amount'],
                'date_time' => $paymentVoucher['payment_date_time'],
                'date' => $modeOfPayment['bankDeposit']['date'],
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);
            DB::commit();
            return response()->Json(['status' => 200, 'message' => 'Bank Payment Updated']);
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    public function addOnlineTransferPayment($modeOfPayment, $modeOfPaymentCode, $paymentVoucher, $supplier)
    {
        try {
            DB::beginTransaction();

            $payment_code = TransactionCode::SUPPLIER_ONLINE_TRANSFER_AMOUNT_CODE;
            $cus_code = SupplierOnlineTransfer::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $supplierOnlineTransfer = SupplierOnlineTransfer::create([

                'code' => $payment_code . $max_id,
                'voucher_code' => $paymentVoucher['code'],
                'supplier_mode_of_payment_code' => $modeOfPaymentCode,
                'bank_code' => $modeOfPayment['onlineTransfer']['bank'],
                //'bank_code' => null,
                //$modeOfPayment['bank']['code'],
                'transfer_id' => $modeOfPayment['onlineTransfer']['transferId'],
                'supplier_code' => $supplier['code'] ?? null,
                'amount' => $modeOfPayment['amount'],
                'date_time' => $paymentVoucher['payment_date_time'],
                'remarks' => $modeOfPayment['remarks']?? null,
                'transfer_date' => $modeOfPayment['onlineTransfer']['transferDate'],
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);
            DB::commit();
            return response()->Json(['status' => 200, 'message' => 'Online Transfer Created']);
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    public function addCardPayment($modeOfPayment, $modeOfPaymentCode, $paymentVoucher, $supplier)
    {
        try {
            DB::beginTransaction();

            $payment_code = TransactionCode::PAYMENT_SUPPLIER_CARD_PAYMENT_CODE;
            $cus_code = SupplierCardPayment::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $CardPayment = SupplierCardPayment::create([
                'code' => $payment_code . $max_id,
                'voucher_code' => $paymentVoucher['code'],
                'supplier_mode_of_payment_code' => $modeOfPaymentCode,
                'bank_code' => $modeOfPayment['chequePayment']['bank'],
                'card_number' => $modeOfPayment['cardPayment']['cardNumber'],
                'supplier_code' => $supplier['code'] ?? null,
                'amount' => $modeOfPayment['amount'],
                'date_time' => $paymentVoucher['payment_date_time'],
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),

            ]);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }




    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
