<?php

namespace App\Http\Controllers\Item_Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Item_Models\ItemUnit;
use App\Enums\TransactionCode;

class ItemUnitController extends Controller
{

    public function index()
    {
        try{
                $unit = ItemUnit::select('code','name','description')->where('is_active','=',1)->get();
                return response()->json(['status'=> 200, 'unit'=>$unit]);
        }catch (\Exception $e) {
            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }

    }

    public function show($id)
    {
        try{
            $unit = ItemUnit::select('code','name','description')->where('code',$id)->where('is_active','=',1)->first();
            return response()->json(['status'=> 200, 'unit'=>$unit]);
            }catch (\Exception $e) {
                return response()->json([
                    'status'=> 500,
                    'message'=> $e
                ],500);
            }
    }


    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        try{
            $itemUnit =TransactionCode::ITEM_UNIT_CODE;
            $bixz_code = ItemUnit::max('code');
            $max_id= $bixz_code==null ? config('global.code_value')+1 : substr("$bixz_code",3)+1;

            $unit = ItemUnit::create([
                'code'=>$itemUnit.$max_id,
                'name'=>$request->name,
                'description'=>$request->description,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow()
            ]);
            return response()->json(['status'=> 200, 'message'=>"Unit Created"]);

        }catch (\Exception $e) {
            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }

    public function edit($id)
    {
        //
    }



    public function update(Request $request, $id)
    {

        try{

            $unit = ItemUnit::where('code',$id)->first();
            $unit ->update([
                'name'=>$request->name,
                'description'=>$request->description,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);
            return response()->json(['status'=> 200, 'message'=>"Unit Updated"]);

        }catch (\Exception $e) {
            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try{

            $unit = ItemUnit::findOrFail($id);
            $unit ->update([
               'is_active'=>0
            ]);
            return response()->json(['status'=> 200, 'message'=>"Unit Deleted"]);

        }catch (\Exception $e) {
            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }
}
